/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.delivery.subtitles;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.serviio.config.Configuration;
import org.serviio.db.dao.PersistenceException;
import org.serviio.delivery.subtitles.EmbeddedSubtitlesReader;
import org.serviio.delivery.subtitles.ExternalFileSubtitlesReader;
import org.serviio.delivery.subtitles.SubtitlesReader;
import org.serviio.dlna.SubtitleCodec;
import org.serviio.dlna.VideoContainer;
import org.serviio.library.entities.Video;
import org.serviio.library.local.EmbeddedSubtitles;
import org.serviio.library.local.service.MediaService;
import org.serviio.library.local.service.VideoService;
import org.serviio.library.service.Service;
import org.serviio.profile.Profile;
import org.serviio.util.CollectionUtils;
import org.serviio.util.FileUtils;
import org.serviio.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubtitlesService
implements Service {
    public static final String FONT_CONFIG_XML = "fonts.conf";
    public static final String FONT_CONFIG_DIR = FileUtils.getFilePathOfClasspathResource("/fonts", SubtitlesService.class);
    private static final Logger log = LoggerFactory.getLogger(SubtitlesService.class);
    private static final String subtitleFileExtensionsRegEx = "(" + CollectionUtils.listToCSV(SubtitleCodec.getAllSupportedExtensions(), "|", false) + ")";

    public static boolean isSoftSubsAvailable(Video item, Profile rendererProfile) {
        if (rendererProfile.getSubtitlesConfiguration().isSoftSubsEnabled()) {
            File extSubs = SubtitlesService.findExternalSubtitleFile(item);
            EmbeddedSubtitles embSubs = SubtitlesService.findEmbeddedSubtitles(item);
            if (extSubs != null || embSubs != null) {
                if (extSubs != null) {
                    log.debug("Found external subtitles file: " + extSubs.getName());
                }
                if (embSubs != null) {
                    log.debug("Found embedded subtitles track: " + embSubs.getLanguageCode());
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public static SubtitlesReader getSoftSubs(Long itemId, Profile rendererProfile) {
        Video mediaItem;
        if (rendererProfile.getSubtitlesConfiguration().isSoftSubsEnabled() && (mediaItem = VideoService.getVideo(itemId)) != null) {
            return SubtitlesService.findAvailableSubtitles(mediaItem);
        }
        return null;
    }

    public static SubtitlesReader getHardSubs(Video video, Profile rendererProfile) {
        List<VideoContainer> requiredForContainers = rendererProfile.getSubtitlesConfiguration().getHardSubsRequiredFor();
        if (Configuration.isHardSubsForced() || requiredForContainers.contains((Object)VideoContainer.ANY) || requiredForContainers.contains((Object)video.getContainer())) {
            return SubtitlesService.findAvailableSubtitles(video);
        }
        return null;
    }

    private static SubtitlesReader findAvailableSubtitles(Video item) {
        File externalFile = SubtitlesService.findExternalSubtitleFile(item);
        if (externalFile != null) {
            log.debug(String.format("Found external subtitle file: %s", externalFile.toString()));
            return new ExternalFileSubtitlesReader(externalFile);
        }
        EmbeddedSubtitles es = SubtitlesService.findEmbeddedSubtitles(item);
        if (es != null) {
            log.debug(String.format("Found embedded subtitle track: %s (%s)", es.getStreamId(), es.getLanguageCode()));
            return new EmbeddedSubtitlesReader(item, es);
        }
        return null;
    }

    private static EmbeddedSubtitles findEmbeddedSubtitles(Video item) {
        if (Configuration.isEmbeddedSubtitlesExtracted()) {
            return SubtitlesService.findPreferredEmbeddedSubtitles(Configuration.getSubtitlesPreferredLanguages(), item.getEmbeddedSubtitles());
        }
        return null;
    }

    protected static EmbeddedSubtitles findPreferredEmbeddedSubtitles(List<String> preferredLanguages, List<EmbeddedSubtitles> availableEmbeddedSubtitles) {
        ArrayList<EmbeddedSubtitles> suitableSubs = new ArrayList<EmbeddedSubtitles>();
        if (preferredLanguages.size() > 0) {
            for (EmbeddedSubtitles es : availableEmbeddedSubtitles) {
                Integer foundSubLanguageIndex = CollectionUtils.findIndexOf(preferredLanguages, es.getLanguageCode(), false);
                if (foundSubLanguageIndex <= -1) continue;
                suitableSubs.add(es);
            }
            if (suitableSubs.size() > 0) {
                Collections.sort(suitableSubs, new EmbeddedSubtitlesComparator());
                return (EmbeddedSubtitles)suitableSubs.get(0);
            }
        }
        return null;
    }

    private static File findExternalSubtitleFile(Video mediaItem) {
        if (mediaItem.isLocalMedia()) {
            try {
                File mediaFile = MediaService.getFile(mediaItem.getId());
                if (mediaFile != null && mediaFile.getParentFile().exists()) {
                    List<String> preferredLanguages = Configuration.getSubtitlesPreferredLanguages();
                    File[] foundFiles = mediaFile.getParentFile().listFiles((FilenameFilter)new RegexFileFilter(SubtitlesService.generateSubtitleSearchRegEx(mediaFile, preferredLanguages), IOCase.INSENSITIVE));
                    File selectedSubtitleFile = SubtitlesService.selectBestSubtitleFile(mediaFile.getName(), foundFiles, preferredLanguages);
                    if (selectedSubtitleFile != null) {
                        return selectedSubtitleFile;
                    }
                }
            }
            catch (PersistenceException e) {
                log.warn(e.getMessage());
            }
        }
        return null;
    }

    protected static String generateSubtitleSearchRegEx(File mediaFile, List<String> preferredLanguages) {
        if (preferredLanguages.isEmpty()) {
            return "^" + Pattern.quote(FileUtils.getFileNameWithoutExtension(mediaFile)) + "\\." + subtitleFileExtensionsRegEx + "$";
        }
        return "^" + Pattern.quote(FileUtils.getFileNameWithoutExtension(mediaFile)) + "([-_(\\.](" + CollectionUtils.listToCSV(preferredLanguages, "|", true) + ")(\\))?)?\\." + subtitleFileExtensionsRegEx + "$";
    }

    protected static File selectBestSubtitleFile(String mediaFileName, File[] subtitleFiles, List<String> preferredLanguages) {
        if (subtitleFiles.length == 0) {
            return null;
        }
        if (preferredLanguages.isEmpty()) {
            ArrayList<File> subtitleFilesWithmatchingName = new ArrayList<File>();
            for (File subtitleFile : subtitleFiles) {
                if (!FileUtils.getFileNameWithoutExtension(subtitleFile).equals(FilenameUtils.getBaseName((String)mediaFileName))) continue;
                subtitleFilesWithmatchingName.add(subtitleFile);
            }
            if (subtitleFilesWithmatchingName.size() == 0) {
                return null;
            }
            Collections.sort(subtitleFilesWithmatchingName, new SubtitleFilesComparator(null));
            return (File)subtitleFilesWithmatchingName.get(0);
        }
        Arrays.sort(subtitleFiles, new SubtitleFilesComparator(preferredLanguages));
        return subtitleFiles[0];
    }

    private static class EmbeddedSubtitlesComparator
    implements Comparator<EmbeddedSubtitles> {
        private EmbeddedSubtitlesComparator() {
        }

        @Override
        public int compare(EmbeddedSubtitles o1, EmbeddedSubtitles o2) {
            if (o1.isDefaultLanguage()) {
                return -1;
            }
            if (o2.isDefaultLanguage()) {
                return 1;
            }
            return 0;
        }
    }

    private static class SubtitleFilesComparator
    implements Comparator<File> {
        private List<String> preferredLanguages;

        public SubtitleFilesComparator(List<String> preferredLanguages) {
            this.preferredLanguages = preferredLanguages;
        }

        @Override
        public int compare(File o1, File o2) {
            if (o1.equals(o2)) {
                return 0;
            }
            String fileName1 = o1.getName();
            String fileName2 = o2.getName();
            String fileName1Language = null;
            String fileName2Language = null;
            if (this.preferredLanguages != null && this.preferredLanguages.size() > 0) {
                Pattern filenameWithLanguage = Pattern.compile(".*[-_(\\.](" + CollectionUtils.listToCSV(this.preferredLanguages, "|", true) + ")(\\))?\\." + subtitleFileExtensionsRegEx, 2);
                Matcher fileName1Matcher = filenameWithLanguage.matcher(fileName1);
                Matcher fileName2Matcher = filenameWithLanguage.matcher(fileName2);
                if (fileName1Matcher.find()) {
                    fileName1Language = fileName1Matcher.group(1);
                }
                if (fileName2Matcher.find()) {
                    fileName2Language = fileName2Matcher.group(1);
                }
            }
            if (fileName1Language != null && fileName2Language != null) {
                int language2Order;
                int language1Order = CollectionUtils.findIndexOf(this.preferredLanguages, fileName1Language, false);
                if (language1Order == (language2Order = CollectionUtils.findIndexOf(this.preferredLanguages, fileName2Language, false))) {
                    return this.prioritizeSrt(fileName1);
                }
                return language1Order < language2Order ? -1 : 1;
            }
            if (fileName1Language == null && fileName2Language == null) {
                return this.prioritizeSrt(fileName1);
            }
            if (fileName1Language != null) {
                return -1;
            }
            return 1;
        }

        private int prioritizeSrt(String filename) {
            return StringUtils.localeSafeToLowercase(filename).endsWith("." + SubtitleCodec.SRT.getFileExtensions().get(0)) ? -1 : 1;
        }
    }
}

