/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.delivery.subtitles;

import java.io.File;
import java.io.IOException;
import org.serviio.delivery.subtitles.HardSubs;
import org.serviio.delivery.subtitles.SubtitlesReader;
import org.serviio.dlna.SubtitleCodec;
import org.serviio.external.FFMPEGWrapper;
import org.serviio.util.FileUtils;

public class ExternalFileSubtitlesReader
implements SubtitlesReader {
    private File subtitlesFile;

    public ExternalFileSubtitlesReader(File subtitlesFile) {
        this.subtitlesFile = subtitlesFile;
    }

    @Override
    public Long getExpectedSubtitlesSize() {
        return this.subtitlesFile.length();
    }

    @Override
    public SubtitleCodec getSubtitleCodec() {
        return SubtitleCodec.getByFileName(this.subtitlesFile.getName());
    }

    @Override
    public byte[] getSubtitlesAsSRT() throws IOException {
        if (this.getSubtitleCodec() == SubtitleCodec.SRT) {
            return FileUtils.readFileBytes(this.subtitlesFile);
        }
        return FFMPEGWrapper.transcodeSubtitleFileToSRT(this.subtitlesFile);
    }

    @Override
    public HardSubs getSubtitlesInOriginalFormat() throws IOException {
        return new HardSubs(FileUtils.getProperFilePath(this.subtitlesFile));
    }
}

