/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.delivery.subtitles;

import java.io.File;
import java.io.IOException;
import org.serviio.delivery.resource.transcode.AbstractTranscodingDeliveryEngine;
import org.serviio.delivery.subtitles.HardSubs;
import org.serviio.delivery.subtitles.SubtitlesReader;
import org.serviio.dlna.SubtitleCodec;
import org.serviio.external.FFMPEGWrapper;
import org.serviio.library.entities.Video;
import org.serviio.library.local.EmbeddedSubtitles;
import org.serviio.util.FileUtils;

public class EmbeddedSubtitlesReader
implements SubtitlesReader {
    private EmbeddedSubtitles embeddedSubtitles;
    private Video video;

    public EmbeddedSubtitlesReader(Video video, EmbeddedSubtitles embeddedSubtitles) {
        this.embeddedSubtitles = embeddedSubtitles;
        this.video = video;
    }

    @Override
    public Long getExpectedSubtitlesSize() {
        return null;
    }

    @Override
    public SubtitleCodec getSubtitleCodec() {
        return this.embeddedSubtitles.getCodec();
    }

    @Override
    public byte[] getSubtitlesAsSRT() throws IOException {
        return FFMPEGWrapper.extractSubtitleFileAsSRT(this.video, this.embeddedSubtitles);
    }

    @Override
    public HardSubs getSubtitlesInOriginalFormat() throws IOException {
        return new HardSubs(FileUtils.getProperFilePath(FFMPEGWrapper.extractSubtitleFile(this.video, this.embeddedSubtitles, this.createTargetSubtitlesFilename())));
    }

    private String createTargetSubtitlesFilename() {
        return FileUtils.getProperFilePath(new File(AbstractTranscodingDeliveryEngine.getTranscodingFolder(), String.format("subtitles_%s_%s", this.video.getId(), this.embeddedSubtitles.getStreamId())));
    }
}

