/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.delivery.resource.transcode;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.serviio.dlna.AudioCodec;
import org.serviio.dlna.H264Profile;
import org.serviio.dlna.VideoCodec;
import org.serviio.dlna.VideoContainer;
import org.serviio.library.local.H264LevelType;
import org.serviio.profile.H264LevelCheckType;
import org.serviio.profile.OnlineContentType;
import org.serviio.util.ObjectValidator;
import org.serviio.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VideoTranscodingMatch {
    private static final Logger log = LoggerFactory.getLogger(VideoTranscodingMatch.class);
    private VideoContainer container;
    private VideoCodec videoCodec;
    private AudioCodec audioCodec;
    private H264Profile h264Profile;
    private Float h264LevelGT;
    private List<String> ftypNotIn = new ArrayList<String>();
    private OnlineContentType onlineContentType = OnlineContentType.ANY;
    private Boolean squarePixels;
    private List<String> vFourCC = new ArrayList<String>();
    private H264LevelCheckType h264LevelCheckType;

    public VideoTranscodingMatch(VideoContainer container, VideoCodec videoCodec, AudioCodec audioCodec, H264Profile h264Profile, Float h264LevelGT, String ftypNotIn, OnlineContentType onlineContentType, Boolean squarePixels, String vFourCC, H264LevelCheckType h264LevelCheckType) {
        this.container = container;
        this.videoCodec = videoCodec;
        this.audioCodec = audioCodec;
        this.h264Profile = h264Profile;
        this.h264LevelGT = h264LevelGT;
        if (ObjectValidator.isNotEmpty(ftypNotIn)) {
            this.ftypNotIn.addAll(Arrays.asList(ftypNotIn.split(",")));
        }
        this.onlineContentType = onlineContentType;
        this.squarePixels = squarePixels;
        if (ObjectValidator.isNotEmpty(vFourCC)) {
            this.vFourCC.addAll(Arrays.asList(vFourCC.split(",")));
        }
        this.h264LevelCheckType = h264LevelCheckType;
    }

    public VideoTranscodingMatch(VideoContainer container) {
        this.container = container;
    }

    public boolean matches(VideoContainer container, VideoCodec videoCodec, AudioCodec audioCodec, H264Profile h264Profile, Map<H264LevelType, String> h264Levels, String ftyp, OnlineContentType onlineContentType, boolean squarePixels, String vFourCC) {
        return !(container != this.container && this.container != VideoContainer.ANY || this.videoCodec != null && videoCodec != this.videoCodec || this.audioCodec != null && audioCodec != this.audioCodec || !this.checkFtyp(ftyp) || !this.checkVFourCC(vFourCC) || !this.checkH264Profile(videoCodec, h264Profile, h264Levels) || this.onlineContentType != OnlineContentType.ANY && this.onlineContentType != onlineContentType || this.squarePixels != null && !this.squarePixels.equals(squarePixels));
    }

    private boolean checkFtyp(String ftyp) {
        return this.ftypNotIn.isEmpty() || ftyp != null && !this.ftypNotIn.contains(StringUtils.localeSafeToLowercase(ftyp));
    }

    private boolean checkVFourCC(String vFourCC) {
        return this.vFourCC.isEmpty() || vFourCC != null && this.vFourCC.contains(StringUtils.localeSafeToLowercase(vFourCC));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkH264Profile(VideoCodec videoCodec, H264Profile videoH264Profile, Map<H264LevelType, String> videoH264Levels) {
        if (videoCodec != VideoCodec.H264) return true;
        if (this.h264Profile == null) {
            return true;
        }
        if (this.h264LevelGT == null) {
            if (videoH264Profile == null) return false;
            if (this.h264Profile != videoH264Profile) return false;
            return true;
        }
        String videoH264Level = this.getLevelToMatch(videoH264Levels);
        try {
            if (videoH264Profile == null) return false;
            if (videoH264Level == null) return false;
            if (this.h264Profile != videoH264Profile) return false;
            Float f = new Float(videoH264Level);
            if (!(f.floatValue() > this.h264LevelGT.floatValue())) return false;
            return true;
        }
        catch (NumberFormatException e) {
            log.warn(String.format("H264 level of the file is not a valid number: %s", videoH264Level));
            return false;
        }
    }

    private String getLevelToMatch(Map<H264LevelType, String> videoH264Levels) {
        if (this.h264LevelCheckType == H264LevelCheckType.FILE_ATTRIBUTES) {
            return videoH264Levels.get((Object)H264LevelType.RF);
        }
        if (this.h264LevelCheckType == H264LevelCheckType.HEADER) {
            return videoH264Levels.get((Object)H264LevelType.H);
        }
        return this.selectHigherH264Level(videoH264Levels.get((Object)H264LevelType.H), videoH264Levels.get((Object)H264LevelType.RF));
    }

    private String selectHigherH264Level(String headerLevel, String refFramesLevel) {
        if (ObjectValidator.isEmpty(headerLevel)) {
            return refFramesLevel;
        }
        if (ObjectValidator.isEmpty(refFramesLevel)) {
            return headerLevel;
        }
        Float headerLevelFloat = new Float(headerLevel);
        Float refFramesLevelFloat = new Float(refFramesLevel);
        if (headerLevelFloat.floatValue() > refFramesLevelFloat.floatValue()) {
            return headerLevel;
        }
        return refFramesLevel;
    }

    public VideoContainer getContainer() {
        return this.container;
    }

    public VideoCodec getVideoCodec() {
        return this.videoCodec;
    }

    public AudioCodec getAudioCodec() {
        return this.audioCodec;
    }

    public H264Profile getH264Profile() {
        return this.h264Profile;
    }

    public Float getH264LevelGT() {
        return this.h264LevelGT;
    }

    public List<String> getFtypNotIn() {
        return Collections.unmodifiableList(this.ftypNotIn);
    }

    public OnlineContentType getOnlineContentType() {
        return this.onlineContentType;
    }

    public Boolean getSquarePixels() {
        return this.squarePixels;
    }

    public H264LevelCheckType getH264LevelCheckType() {
        return this.h264LevelCheckType;
    }

    public List<String> getvFourCC() {
        return Collections.unmodifiableList(this.vFourCC);
    }
}

