/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.delivery.resource.transcode;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.serviio.delivery.Client;
import org.serviio.delivery.resource.transcode.TranscodeInputStream;
import org.serviio.external.ProcessListener;
import org.serviio.util.DateUtils;
import org.serviio.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TranscodingJobListener
extends ProcessListener {
    private static final Logger log = LoggerFactory.getLogger(TranscodingJobListener.class);
    private String transcodingIdentifier;
    private File transcodedFile;
    private PipedInputStream transcodedStream;
    private boolean isSegmentedOutput;
    private Set<TranscodeInputStream> processingStreams = new HashSet<TranscodeInputStream>();
    private boolean started = false;
    private boolean successful = true;
    private TreeMap<Double, ProgressData> timeFilesizeMap = new TreeMap();
    private volatile boolean shuttingDown = false;

    public TranscodingJobListener(String transcodingIdentifier, boolean isSegmentedOutput) {
        this.transcodingIdentifier = transcodingIdentifier;
        this.isSegmentedOutput = isSegmentedOutput;
    }

    @Override
    public void processEnded(boolean success) {
        log.debug(String.format("Transcoding finished; successful: %s", success));
        for (TranscodeInputStream stream : this.processingStreams) {
            stream.setTranscodeFinished(true);
        }
        this.finished = true;
        this.successful = success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void outputUpdated(String updatedLine) {
        block10: {
            if (!this.started) {
                if (updatedLine.startsWith("Press [q] to stop")) {
                    this.started = true;
                }
            } else {
                int sizePos = updatedLine.indexOf("size=");
                if (sizePos > -1) {
                    String sizeStr = updatedLine.substring(sizePos + 5);
                    int timePos = sizeStr.indexOf("time=");
                    int bitratePos = sizeStr.indexOf(" bitrate=");
                    if (timePos > -1 && bitratePos > -1) {
                        String size = sizeStr.substring(0, timePos - 3).trim();
                        String time = sizeStr.substring(timePos + 5, bitratePos);
                        try {
                            Double txTime = DateUtils.timeToSecondsPrecise(time);
                            String bitrateStr = sizeStr.substring(bitratePos + 9);
                            int unitPos = bitrateStr.indexOf("kbits/s");
                            if (unitPos <= -1) break block10;
                            String bitrate = bitrateStr.substring(0, unitPos);
                            TreeMap<Double, ProgressData> treeMap = this.timeFilesizeMap;
                            synchronized (treeMap) {
                                this.timeFilesizeMap.put(txTime, new ProgressData(Long.parseLong(size), Float.valueOf(Float.parseFloat(bitrate))));
                            }
                        }
                        catch (NumberFormatException e) {
                            log.debug(String.format("Error updating FFmpeg output for line '%s': %s", updatedLine, e.getMessage()));
                        }
                    }
                }
            }
        }
    }

    public void closeStream(Client client) {
        Iterator<TranscodeInputStream> i = this.processingStreams.iterator();
        while (i.hasNext()) {
            TranscodeInputStream tis = i.next();
            if (!tis.getClient().equals(client)) continue;
            try {
                tis.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            i.remove();
        }
    }

    @Override
    public synchronized void releaseResources() {
        if (!this.shuttingDown) {
            this.shuttingDown = true;
            this.closeFFmpegConsumer();
            this.getExecutor().stopProcess(true);
            this.closeAllStreams();
            if (this.getTranscodedFile() != null) {
                File fileToDelete = this.isSegmentedOutput ? this.getTranscodedFile().getParentFile() : this.getTranscodedFile();
                boolean deleted = FileUtils.deleteFileOrFolder(fileToDelete);
                log.debug(String.format("Deleted temp file '%s': %s", fileToDelete, deleted));
            }
        }
    }

    public String getTranscodingIdentifier() {
        return this.transcodingIdentifier;
    }

    public void addStream(TranscodeInputStream stream) {
        this.processingStreams.add(stream);
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public TreeMap<Double, ProgressData> getFilesizeMap() {
        return new TreeMap<Double, ProgressData>((SortedMap<Double, ProgressData>)this.timeFilesizeMap);
    }

    public File getTranscodedFile() {
        return this.transcodedFile;
    }

    public PipedInputStream getTranscodedStream() {
        return this.transcodedStream;
    }

    public void setTranscodedStream(PipedInputStream transcodedStream) {
        this.transcodedStream = transcodedStream;
    }

    public void setTranscodedFile(File transcodedFile) {
        this.transcodedFile = transcodedFile;
    }

    private void closeAllStreams() {
        Iterator<TranscodeInputStream> i = this.processingStreams.iterator();
        while (i.hasNext()) {
            TranscodeInputStream tis = i.next();
            FileUtils.closeQuietly((InputStream)((Object)tis));
            i.remove();
        }
    }

    private void closeFFmpegConsumer() {
        if (this.transcodedStream != null) {
            FileUtils.closeQuietly(this.transcodedStream);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.transcodingIdentifier == null ? 0 : this.transcodingIdentifier.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TranscodingJobListener other = (TranscodingJobListener)obj;
        return !(this.transcodingIdentifier == null ? other.transcodingIdentifier != null : !this.transcodingIdentifier.equals(other.transcodingIdentifier));
    }

    public static class ProgressData {
        private Long fileSize;
        private Float bitrate;

        public ProgressData(Long fileSize, Float bitrate) {
            this.fileSize = fileSize;
            this.bitrate = bitrate;
        }

        public Long getFileSize() {
            return this.fileSize;
        }

        public Float getBitrate() {
            return this.bitrate;
        }
    }
}

