/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.delivery.resource.transcode;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.serviio.delivery.resource.transcode.TranscodingDefinition;
import org.serviio.library.metadata.MediaFileType;

public class TranscodingConfiguration {
    private boolean keepStreamOpen = true;
    private Map<MediaFileType, List<TranscodingDefinition>> config = new HashMap<MediaFileType, List<TranscodingDefinition>>();

    public List<TranscodingDefinition> getDefinitions(MediaFileType fileType) {
        List<TranscodingDefinition> result = this.config.get((Object)fileType);
        if (result != null) {
            return Collections.unmodifiableList(this.config.get((Object)fileType));
        }
        return Collections.emptyList();
    }

    public List<TranscodingDefinition> getDefinitions() {
        ArrayList<TranscodingDefinition> result = new ArrayList<TranscodingDefinition>();
        for (List<TranscodingDefinition> configs : this.config.values()) {
            result.addAll(configs);
        }
        return Collections.unmodifiableList(result);
    }

    public void addDefinition(MediaFileType fileType, TranscodingDefinition definition) {
        if (!this.config.containsKey((Object)fileType)) {
            this.config.put(fileType, new ArrayList());
        }
        List<TranscodingDefinition> defs = this.config.get((Object)fileType);
        defs.add(definition);
    }

    public boolean isKeepStreamOpen() {
        return this.keepStreamOpen;
    }

    public void setKeepStreamOpen(boolean keepStreamOpen) {
        this.keepStreamOpen = keepStreamOpen;
    }
}

