/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.delivery.resource.transcode;

import org.serviio.dlna.MediaFormatProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TranscodingCache {
    private static final Logger log = LoggerFactory.getLogger(TranscodingCache.class);
    private Long mediaItemId;
    private MediaFormatProfile transcodedProfile;
    private byte[] transcodedData;

    public void storeInCache(Long mediaItemId, MediaFormatProfile transcodedProfile, byte[] transcodedData) {
        log.debug(String.format("Storing media item %s with profile %s to cache", mediaItemId, transcodedProfile.toString()));
        this.mediaItemId = mediaItemId;
        this.transcodedProfile = transcodedProfile;
        this.transcodedData = transcodedData;
    }

    public boolean isInCache(Long mediaItemId, MediaFormatProfile transcodedProfile) {
        return this.mediaItemId != null && this.mediaItemId.equals(mediaItemId) && this.transcodedProfile == transcodedProfile;
    }

    public byte[] getCachedBytes() {
        if (this.transcodedData != null) {
            log.debug(String.format("Retrieving media item %s with profile %s from cache", this.mediaItemId, this.transcodedProfile.toString()));
            byte[] dst = new byte[this.transcodedData.length];
            System.arraycopy(this.transcodedData, 0, dst, 0, this.transcodedData.length);
            return dst;
        }
        return null;
    }
}

