/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.delivery.resource.transcode;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.serviio.delivery.Client;
import org.serviio.delivery.resource.transcode.TranscodeInputStream;
import org.serviio.util.ThreadUtils;

public class TranscodedMediaInputStream
extends FileInputStream
implements TranscodeInputStream {
    private boolean transcodeFinished = false;
    private Client client;

    public TranscodedMediaInputStream(File file, Client client) throws FileNotFoundException {
        super(file);
        this.client = client;
    }

    @Override
    public int available() throws IOException {
        int av = super.available();
        if (av < 0 && !this.transcodeFinished) {
            return 1;
        }
        return av;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int n = -1;
        while (n == -1) {
            n = super.read(b, off, len);
            if (n < 0 && !this.transcodeFinished) {
                ThreadUtils.currentThreadSleep(1000L);
                continue;
            }
            if (n >= 0 || !this.transcodeFinished) continue;
            return n;
        }
        return n;
    }

    @Override
    public void setTranscodeFinished(boolean transcodeFinished) {
        this.transcodeFinished = transcodeFinished;
    }

    @Override
    public Client getClient() {
        return this.client;
    }
}

