/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.delivery.resource.transcode;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.serviio.ApplicationSettings;
import org.serviio.delivery.Client;
import org.serviio.delivery.DeliveryListener;
import org.serviio.delivery.NonClosingPipedInputStream;
import org.serviio.delivery.resource.transcode.AbstractTranscodingDeliveryStrategy;
import org.serviio.delivery.resource.transcode.StreamDescriptor;
import org.serviio.delivery.resource.transcode.TranscodingDefinition;
import org.serviio.delivery.resource.transcode.TranscodingDeliveryStrategy;
import org.serviio.delivery.resource.transcode.TranscodingJobListener;
import org.serviio.library.entities.MediaItem;
import org.serviio.util.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamBasedTranscodingDeliveryStrategy
extends AbstractTranscodingDeliveryStrategy
implements TranscodingDeliveryStrategy<OutputStream> {
    private static final int PIPE_BUFFER_BYTES = ApplicationSettings.getIntegerProperty("live_stream_buffer");
    private static final Logger log = LoggerFactory.getLogger(StreamBasedTranscodingDeliveryStrategy.class);

    @Override
    public StreamDescriptor createInputStream(TranscodingJobListener jobListener, Long resourceId, TranscodingDefinition trDef, Client client, DeliveryListener deliveryListener) throws IOException {
        PipedInputStream pis = jobListener.getTranscodedStream();
        if (pis == null) {
            throw new IOException("Transcoded stream cannot be found, FFmpeg execution probably failed");
        }
        if (pis.available() <= 0) {
            int counter = 10;
            while (pis.available() <= 0 && counter++ <= 10) {
                ThreadUtils.currentThreadSleep(1000L);
            }
            if (pis.available() <= 0) {
                log.debug("Transcoded stream is empty, connection may have been lost");
            }
        } else if (jobListener.isFinished() && !jobListener.isSuccessful()) {
            throw new IOException("FFmpeg execution failed");
        }
        return new StreamDescriptor(pis, null);
    }

    @Override
    public TranscodingJobListener invokeTranscoder(String transcodingIdentifier, MediaItem mediaItem, Double timeOffsetInSeconds, Double durationInSeconds, TranscodingDefinition trDef, Client client, DeliveryListener deliveryListener) throws IOException {
        TranscodingJobListener jobListener = new TranscodingJobListener(transcodingIdentifier, false);
        OutputStream transcodedOutput = this.invokeTranscoder(mediaItem, timeOffsetInSeconds, durationInSeconds, null, trDef, jobListener);
        if (transcodedOutput != null) {
            jobListener.setTranscodedStream(new NonClosingPipedInputStream((PipedOutputStream)transcodedOutput, PIPE_BUFFER_BYTES, jobListener, client, deliveryListener, !trDef.getTranscodingConfiguration().isKeepStreamOpen()));
            int retries = 0;
            while (jobListener.getTranscodedStream().available() <= 0 && retries++ < 50) {
                ThreadUtils.currentThreadSleep(500L);
            }
        } else {
            log.debug("Live stream doesn't produce any bytes.");
        }
        return jobListener;
    }
}

