/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.delivery.resource.transcode;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.serviio.delivery.Client;
import org.serviio.delivery.DefaultResourceURLGenerator;
import org.serviio.delivery.DeliveryListener;
import org.serviio.delivery.ResourceURLGenerator;
import org.serviio.delivery.resource.transcode.FileBasedTranscodingDeliveryStrategy;
import org.serviio.delivery.resource.transcode.ManifestTranscodeInputStream;
import org.serviio.delivery.resource.transcode.TranscodeInputStream;
import org.serviio.delivery.resource.transcode.TranscodingJobListener;
import org.serviio.external.FFMPEGWrapper;
import org.serviio.util.FileUtils;

public class SegmentBasedTranscodingDeliveryStrategy
extends FileBasedTranscodingDeliveryStrategy {
    protected ResourceURLGenerator urlGenerator = new DefaultResourceURLGenerator();

    @Override
    protected boolean isSegmentedOutput() {
        return true;
    }

    @Override
    protected TranscodeInputStream createStreamForTranscodedFile(File transcodedFile, TranscodingJobListener jobListener, Long resourceId, Client client, DeliveryListener deliveryListener, boolean forceClosing) throws FileNotFoundException {
        return new ManifestTranscodeInputStream(transcodedFile, client, this.urlGenerator, resourceId);
    }

    @Override
    protected InputStream createStreamForFinishedFile(File transcodedFile, TranscodingJobListener jobListener, Long resourceId, Client client, DeliveryListener deliveryListener, boolean forceClosing) throws FileNotFoundException {
        return new ManifestTranscodeInputStream(transcodedFile, client, this.urlGenerator, resourceId);
    }

    @Override
    protected void markTranscodedFileForDeletion(File transcodedFile) {
        FileUtils.deleteDirOnExit(transcodedFile.getParentFile());
    }

    @Override
    protected File prepareTranscodedOutput(String transcodingIdentifier) throws IOException {
        File transcodingFolder = super.prepareTranscodedOutput(transcodingIdentifier);
        return new File(this.createFolder(transcodingFolder), FFMPEGWrapper.SEGMENT_PLAYLIST_FILE_NAME);
    }

    @Override
    protected Long getFileSizeForFinishedFile(File transcodedFile) {
        return null;
    }
}

