/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.delivery.resource.transcode;

import com.googlecode.streamflyer.core.AfterModification;
import com.googlecode.streamflyer.core.Modifier;
import com.googlecode.streamflyer.core.ModifyingReader;
import com.googlecode.streamflyer.regex.RegexModifier;
import com.googlecode.streamflyer.util.ModificationFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Reader;
import java.util.regex.Matcher;
import org.serviio.delivery.HostInfo;
import org.serviio.delivery.ResourceURLGenerator;
import org.serviio.delivery.resource.transcode.LiveSegmentBasedTranscodingDeliveryStrategy;
import org.serviio.upnp.service.contentdirectory.classes.InvalidResourceException;
import org.serviio.upnp.service.contentdirectory.classes.Resource;

public class ManifestTranscodeInputStreamModifier {
    public static Reader modifyReader(Reader originalReader, ResourceURLGenerator urlGenerator, HostInfo hostInfo, File manifestFile, Long resourceId, boolean live, LiveSegmentBasedTranscodingDeliveryStrategy.SegmentRemover segmentRemover) throws FileNotFoundException {
        try {
            String segmentsFolder = ManifestTranscodeInputStreamModifier.buildSegmentResourcePath(manifestFile);
            String serverUrl = urlGenerator.getGeneratedURL(hostInfo, Resource.ResourceType.SEGMENT, resourceId, segmentsFolder);
            String[] serverUrlTemplate = ManifestTranscodeInputStreamModifier.buildTargetUrlTemplate(serverUrl);
            RegexModifier segmentUrlModifier = new RegexModifier(".*?(\\\\|/)(segment\\d{5}.ts)", 0, serverUrlTemplate[0] + "/$2" + serverUrlTemplate[1]);
            ModifyingReader modifyingReader = new ModifyingReader(originalReader, (Modifier)segmentUrlModifier);
            if (live) {
                return new ModifyingReader((Reader)modifyingReader, (Modifier)new LiveStreamSegmentListener(segmentRemover));
            }
            return modifyingReader;
        }
        catch (InvalidResourceException e) {
            throw new FileNotFoundException(e.getMessage());
        }
    }

    private static String buildSegmentResourcePath(File manifestFile) {
        return manifestFile.getParentFile().getName();
    }

    private static String[] buildTargetUrlTemplate(String serverUrl) {
        int queryStringIndex = serverUrl.indexOf(63);
        String[] result = new String[2];
        if (queryStringIndex > -1) {
            result[0] = serverUrl.substring(0, queryStringIndex);
            result[1] = serverUrl.substring(queryStringIndex);
        } else {
            result[0] = serverUrl;
            result[1] = "";
        }
        return result;
    }

    private static class LiveStreamSegmentListener
    implements Modifier {
        private ModifierState state = ModifierState.INITIAL;
        private ModificationFactory factory = new ModificationFactory(0, 4096);
        private final LiveSegmentBasedTranscodingDeliveryStrategy.SegmentRemover segmentRemover;

        public LiveStreamSegmentListener(LiveSegmentBasedTranscodingDeliveryStrategy.SegmentRemover segmentRemover) {
            this.segmentRemover = segmentRemover;
        }

        public AfterModification modify(StringBuilder characterBuffer, int firstModifiableCharacterInBuffer, boolean endOfStreamHit) {
            switch (this.state) {
                case SEGMENT_FOUND: {
                    return this.factory.skipEntireBuffer(characterBuffer, firstModifiableCharacterInBuffer, endOfStreamHit);
                }
                case INITIAL: {
                    this.state = ModifierState.SEGMENT_SEARCH;
                    return this.factory.modifyAgainImmediately(4096, firstModifiableCharacterInBuffer);
                }
                case SEGMENT_SEARCH: {
                    Matcher matcher = LiveSegmentBasedTranscodingDeliveryStrategy.segmentPattern.matcher(characterBuffer.toString());
                    if (matcher.find() && matcher.groupCount() == 1) {
                        if (this.segmentRemover != null) {
                            this.segmentRemover.removeSegments(new Integer(matcher.group(1)));
                        }
                        this.state = ModifierState.SEGMENT_FOUND;
                    }
                    return this.factory.skipEntireBuffer(characterBuffer, firstModifiableCharacterInBuffer, endOfStreamHit);
                }
            }
            throw new IllegalStateException("state " + (Object)((Object)this.state) + " not supported");
        }

        private static enum ModifierState {
            INITIAL,
            SEGMENT_SEARCH,
            SEGMENT_FOUND;

        }
    }
}

