/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.delivery.resource.transcode;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.serviio.delivery.Client;
import org.serviio.delivery.DeliveryListener;
import org.serviio.delivery.resource.transcode.LiveManifestTranscodeInputStream;
import org.serviio.delivery.resource.transcode.SegmentBasedTranscodingDeliveryStrategy;
import org.serviio.delivery.resource.transcode.TranscodeInputStream;
import org.serviio.delivery.resource.transcode.TranscodingJobListener;
import org.serviio.util.FileUtils;
import org.serviio.util.ServiioThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiveSegmentBasedTranscodingDeliveryStrategy
extends SegmentBasedTranscodingDeliveryStrategy {
    public static final Pattern segmentPattern = Pattern.compile("segment(\\d{5}).ts", 8);

    @Override
    protected TranscodeInputStream createStreamForTranscodedFile(File transcodedFile, TranscodingJobListener jobListener, Long resourceId, Client client, DeliveryListener deliveryListener, boolean forceClosing) throws FileNotFoundException {
        return new LiveManifestTranscodeInputStream(jobListener, transcodedFile, client, this.urlGenerator, resourceId, deliveryListener, forceClosing, new SegmentRemover(transcodedFile.getParentFile()));
    }

    @Override
    protected InputStream createStreamForFinishedFile(File transcodedFile, TranscodingJobListener jobListener, Long resourceId, Client client, DeliveryListener deliveryListener, boolean forceClosing) throws FileNotFoundException {
        return new LiveManifestTranscodeInputStream(jobListener, transcodedFile, client, this.urlGenerator, resourceId, deliveryListener, forceClosing, new SegmentRemover(transcodedFile.getParentFile()));
    }

    private static class SegmentRemoverWorker
    implements Runnable {
        private static final Logger log = LoggerFactory.getLogger(SegmentRemoverWorker.class);
        private final File segmentsFolder;
        private final Integer firstUsedSegmentNumber;

        public SegmentRemoverWorker(File segmentsFolder, Integer firstUsedSegmentNumber) {
            this.segmentsFolder = segmentsFolder;
            this.firstUsedSegmentNumber = firstUsedSegmentNumber;
        }

        @Override
        public void run() {
            if (this.segmentsFolder.exists() && this.segmentsFolder.isDirectory()) {
                File[] segmentsToRemove;
                for (File segmentFile : segmentsToRemove = this.segmentsFolder.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        Matcher matcher = segmentPattern.matcher(name);
                        return matcher.find() && matcher.groupCount() == 1 && new Integer(matcher.group(1)) < SegmentRemoverWorker.this.firstUsedSegmentNumber;
                    }
                })) {
                    boolean deleted = FileUtils.deleteFileOrFolder(segmentFile);
                    if (!deleted) continue;
                    log.debug(String.format("Removed segment file: %s", segmentFile.getPath()));
                }
            }
        }
    }

    static class SegmentRemover {
        private final File segmentsFolder;

        public SegmentRemover(File segmentsFolder) {
            this.segmentsFolder = segmentsFolder;
        }

        public synchronized void removeSegments(Integer firstUsedSegmentNumber) {
            ServiioThreadFactory.getInstance().newThread(new SegmentRemoverWorker(this.segmentsFolder, firstUsedSegmentNumber)).start();
        }
    }
}

