/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.delivery.resource.transcode;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.serviio.delivery.Client;
import org.serviio.delivery.ClosableStreamDelegator;
import org.serviio.delivery.DeliveryListener;
import org.serviio.delivery.ResourceURLGenerator;
import org.serviio.delivery.TimeoutStreamDelegator;
import org.serviio.delivery.resource.transcode.LiveSegmentBasedTranscodingDeliveryStrategy;
import org.serviio.delivery.resource.transcode.ManifestTranscodeInputStream;
import org.serviio.external.ProcessListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiveManifestTranscodeInputStream
extends ManifestTranscodeInputStream
implements ClosableStreamDelegator {
    private static final Logger log = LoggerFactory.getLogger(LiveManifestTranscodeInputStream.class);
    private static final Map<File, TimeoutStreamDelegator> delegators = Collections.synchronizedMap(new HashMap());
    private final TimeoutStreamDelegator closingDelegator;
    private final File manifestFile;

    public LiveManifestTranscodeInputStream(ProcessListener processListener, File file, Client client, ResourceURLGenerator urlGenerator, Long resourceId, DeliveryListener deliveryListener, boolean forceClosing, LiveSegmentBasedTranscodingDeliveryStrategy.SegmentRemover segmentRemover) throws FileNotFoundException {
        super(file, client, urlGenerator, resourceId, true, segmentRemover);
        this.manifestFile = file;
        this.closingDelegator = LiveManifestTranscodeInputStream.getClosingDelegator((InputStream)((Object)this), processListener, file, client, deliveryListener, forceClosing);
    }

    public synchronized int read() throws IOException {
        this.closingDelegator.onRead();
        return super.read();
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        this.closingDelegator.onRead();
        return super.read(b, off, len);
    }

    @Override
    public synchronized void close() throws IOException {
        this.closingDelegator.close();
    }

    @Override
    public void closeParent() throws IOException {
        super.close();
        delegators.remove(this.manifestFile);
    }

    private static synchronized TimeoutStreamDelegator getClosingDelegator(InputStream is, ProcessListener processListener, File manifestFile, Client client, DeliveryListener deliveryListener, boolean forceClosing) {
        if (delegators.containsKey(manifestFile)) {
            log.debug(String.format("Using existing TimeoutStreamDelegator for file %s", manifestFile.getPath()));
            return delegators.get(manifestFile);
        }
        log.debug(String.format("Creating new TimeoutStreamDelegator for file %s", manifestFile.getPath()));
        TimeoutStreamDelegator closingDelegator = new TimeoutStreamDelegator(is, processListener, client, deliveryListener, forceClosing);
        delegators.put(manifestFile, closingDelegator);
        return closingDelegator;
    }
}

