/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.delivery.resource.transcode;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.serviio.dlna.MediaFormatProfile;

public class ImageTranscodingProfilesProvider {
    private static Map<MediaFormatProfile, List<MediaFormatProfile>> transcodingConfig = new HashMap<MediaFormatProfile, List<MediaFormatProfile>>();

    public static List<MediaFormatProfile> getAvailableTranscodingProfiles(List<MediaFormatProfile> profiles) {
        HashSet availableProfiles = new HashSet();
        for (MediaFormatProfile profile : profiles) {
            if (!transcodingConfig.containsKey((Object)profile)) continue;
            availableProfiles.addAll(transcodingConfig.get((Object)profile));
        }
        return new ArrayList<MediaFormatProfile>(availableProfiles);
    }

    static {
        transcodingConfig.put(MediaFormatProfile.JPEG_MED, Arrays.asList(MediaFormatProfile.JPEG_SM));
        transcodingConfig.put(MediaFormatProfile.JPEG_LRG, Arrays.asList(MediaFormatProfile.JPEG_SM, MediaFormatProfile.JPEG_MED));
        transcodingConfig.put(MediaFormatProfile.PNG_LRG, Arrays.asList(MediaFormatProfile.JPEG_LRG));
        transcodingConfig.put(MediaFormatProfile.GIF_LRG, Arrays.asList(MediaFormatProfile.JPEG_LRG));
        transcodingConfig.put(MediaFormatProfile.RAW, Arrays.asList(MediaFormatProfile.JPEG_SM, MediaFormatProfile.JPEG_MED, MediaFormatProfile.JPEG_LRG));
    }
}

