/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.delivery.resource.transcode;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.serviio.delivery.Client;
import org.serviio.delivery.DeliveryListener;
import org.serviio.delivery.resource.transcode.AbstractTranscodingDeliveryEngine;
import org.serviio.delivery.resource.transcode.AbstractTranscodingDeliveryStrategy;
import org.serviio.delivery.resource.transcode.StreamDescriptor;
import org.serviio.delivery.resource.transcode.TranscodeInputStream;
import org.serviio.delivery.resource.transcode.TranscodedMediaInputStream;
import org.serviio.delivery.resource.transcode.TranscodingDefinition;
import org.serviio.delivery.resource.transcode.TranscodingDeliveryStrategy;
import org.serviio.delivery.resource.transcode.TranscodingJobListener;
import org.serviio.library.entities.MediaItem;
import org.serviio.util.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBasedTranscodingDeliveryStrategy
extends AbstractTranscodingDeliveryStrategy
implements TranscodingDeliveryStrategy<File> {
    private static final Logger log = LoggerFactory.getLogger(FileBasedTranscodingDeliveryStrategy.class);

    @Override
    public StreamDescriptor createInputStream(TranscodingJobListener jobListener, Long resourceId, TranscodingDefinition trDef, Client client, DeliveryListener deliveryListener) throws IOException {
        File transcodedFile = jobListener.getTranscodedFile();
        if (!transcodedFile.exists()) {
            throw new IOException(String.format("Transcoded file '%s' cannot be found, FFmpeg execution probably failed", transcodedFile.getPath()));
        }
        if (jobListener.isFinished() && !jobListener.isSuccessful()) {
            throw new IOException("FFmpeg execution failed");
        }
        this.markTranscodedFileForDeletion(transcodedFile);
        StreamDescriptor stream = null;
        if (!jobListener.isFinished()) {
            log.debug("Sending transcoding stream");
            TranscodeInputStream fis = this.createStreamForTranscodedFile(transcodedFile, jobListener, resourceId, client, deliveryListener, !trDef.getTranscodingConfiguration().isKeepStreamOpen());
            jobListener.addStream(fis);
            stream = new StreamDescriptor((InputStream)((Object)fis), null);
        } else {
            log.debug(String.format("Transcoded file '%s' is complete, sending simple stream", transcodedFile));
            InputStream fis = this.createStreamForFinishedFile(transcodedFile, jobListener, resourceId, client, deliveryListener, !trDef.getTranscodingConfiguration().isKeepStreamOpen());
            stream = new StreamDescriptor(fis, this.getFileSizeForFinishedFile(transcodedFile));
        }
        return stream;
    }

    @Override
    public TranscodingJobListener invokeTranscoder(String transcodingIdentifier, MediaItem mediaItem, Double timeOffsetInSeconds, Double durationInSeconds, TranscodingDefinition trDef, Client client, DeliveryListener deliveryListener) throws IOException {
        int maxRetries;
        File transcodedFile = this.prepareTranscodedOutput(transcodingIdentifier);
        TranscodingJobListener jobListener = new TranscodingJobListener(transcodingIdentifier, this.isSegmentedOutput());
        jobListener.setTranscodedFile(transcodedFile);
        this.invokeTranscoder(mediaItem, timeOffsetInSeconds, durationInSeconds, jobListener.getTranscodedFile(), trDef, jobListener);
        int retries = 0;
        int n = maxRetries = mediaItem.isLocalMedia() ? 20 : 50;
        while (!(transcodedFile.exists() && transcodedFile.length() != 0L || retries++ >= maxRetries)) {
            ThreadUtils.currentThreadSleep(500L);
        }
        return jobListener;
    }

    protected Long getFileSizeForFinishedFile(File transcodedFile) {
        return transcodedFile.length();
    }

    protected TranscodeInputStream createStreamForTranscodedFile(File transcodedFile, TranscodingJobListener jobListener, Long resourceId, Client client, DeliveryListener deliveryListener, boolean forceClosing) throws FileNotFoundException {
        return new TranscodedMediaInputStream(transcodedFile, client);
    }

    protected InputStream createStreamForFinishedFile(File transcodedFile, TranscodingJobListener jobListener, Long resourceId, Client client, DeliveryListener deliveryListener, boolean forceClosing) throws FileNotFoundException {
        return new FileInputStream(transcodedFile);
    }

    protected boolean isSegmentedOutput() {
        return false;
    }

    protected File prepareTranscodedOutput(String transcodingIdentifier) throws IOException {
        File transcodingFolder = this.prepareTranscodingFolder();
        return new File(transcodingFolder, transcodingIdentifier);
    }

    protected void markTranscodedFileForDeletion(File transcodedFile) {
        transcodedFile.deleteOnExit();
    }

    protected File createFolder(File folder) throws IOException {
        boolean created;
        if (!folder.exists() && !(created = folder.mkdirs())) {
            throw new IOException(String.format("Cannot create transcoding folder: %s", folder.getAbsolutePath()));
        }
        return folder;
    }

    private File prepareTranscodingFolder() throws IOException {
        File transcodingFolder = AbstractTranscodingDeliveryEngine.getTranscodingFolder();
        return this.createFolder(transcodingFolder);
    }
}

