/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.delivery.resource.transcode;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.serviio.config.Configuration;
import org.serviio.db.entities.PersistedEntity;
import org.serviio.delivery.Client;
import org.serviio.delivery.DeliveryContainer;
import org.serviio.delivery.DeliveryListener;
import org.serviio.delivery.MediaFormatProfileResource;
import org.serviio.delivery.ResourceInfo;
import org.serviio.delivery.StreamDeliveryContainer;
import org.serviio.delivery.resource.AbstractDeliveryEngine;
import org.serviio.delivery.resource.transcode.FileBasedTranscodingDeliveryStrategy;
import org.serviio.delivery.resource.transcode.LiveSegmentBasedTranscodingDeliveryStrategy;
import org.serviio.delivery.resource.transcode.SegmentBasedTranscodingDeliveryStrategy;
import org.serviio.delivery.resource.transcode.StreamBasedTranscodingDeliveryStrategy;
import org.serviio.delivery.resource.transcode.StreamDescriptor;
import org.serviio.delivery.resource.transcode.TranscodingDefinition;
import org.serviio.delivery.resource.transcode.TranscodingDeliveryStrategy;
import org.serviio.delivery.resource.transcode.TranscodingJobListener;
import org.serviio.dlna.MediaFormatProfile;
import org.serviio.dlna.SubtitleCodec;
import org.serviio.dlna.UnsupportedDLNAMediaFileFormatException;
import org.serviio.library.entities.MediaItem;
import org.serviio.profile.DeliveryQuality;
import org.serviio.profile.OnlineContentType;
import org.serviio.profile.Profile;
import org.serviio.util.FileUtils;
import org.serviio.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTranscodingDeliveryEngine<RI extends MediaFormatProfileResource, MI extends MediaItem>
extends AbstractDeliveryEngine<RI, MI>
implements DeliveryListener {
    private static final String TRANSCODING_SUBFOLDER_NAME = "Serviio";
    public static final String TRANSCODED_FILE_EXTENSION = "stf";
    private static Map<Client, TranscodingJobListener> transcodeJobs = Collections.synchronizedMap(new HashMap());
    private static TranscodingDeliveryStrategy<File> fileBasedStrategy = new FileBasedTranscodingDeliveryStrategy();
    private static TranscodingDeliveryStrategy<File> segmentBasedStrategy = new SegmentBasedTranscodingDeliveryStrategy();
    private static TranscodingDeliveryStrategy<File> liveSegmentBasedStrategy = new LiveSegmentBasedTranscodingDeliveryStrategy();
    private static TranscodingDeliveryStrategy<OutputStream> streamBasedStrategy = new StreamBasedTranscodingDeliveryStrategy();
    private static final Logger log = LoggerFactory.getLogger(AbstractTranscodingDeliveryEngine.class);

    public static void cleanupTranscodingEngine() {
        log.info("Cleaning transcode engine and its data");
        for (TranscodingJobListener listener : transcodeJobs.values()) {
            listener.releaseResources();
        }
        AbstractTranscodingDeliveryEngine.deleteTranscodeFiles();
    }

    public static File getTranscodingFolder() {
        File f = new File(Configuration.getTranscodingFolder(), TRANSCODING_SUBFOLDER_NAME);
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deliveryComplete(Client client) {
        Map<Client, TranscodingJobListener> map = transcodeJobs;
        synchronized (map) {
            transcodeJobs.remove(client);
        }
    }

    @Override
    protected DeliveryContainer retrieveTranscodedResource(MI mediaItem, MediaFormatProfile selectedVersion, DeliveryQuality.QualityType selectedQuality, Double timeOffsetInSeconds, Double durationInSeconds, Client client) throws IOException, UnsupportedDLNAMediaFileFormatException {
        Map<DeliveryQuality.QualityType, TranscodingDefinition> trDefs = this.getMatchingTranscodingDefinitions(mediaItem, client.getRendererProfile(), true);
        TranscodingDefinition trDef = trDefs.get((Object)selectedQuality);
        if (trDef != null) {
            String timeOffset = timeOffsetInSeconds != null ? String.format("-%s-%s", timeOffsetInSeconds, durationInSeconds != null ? durationInSeconds : 0.0) : "";
            String subtitle = ((MediaItem)mediaItem).getDeliveryContext().getHardsubsSubtitlesFile() != null ? String.format("-%s", ((MediaItem)mediaItem).getDeliveryContext().getHardsubsSubtitlesFile().getIdentifier()) : "";
            String transcodingIdentifier = String.format("transcoding-temp-%s-%s-%s%s%s.%s", ((PersistedEntity)mediaItem).getId(), client.getRendererProfile().getId(), selectedQuality.toString(), timeOffset, subtitle, TRANSCODED_FILE_EXTENSION);
            TranscodingJobListener jobListener = this.startTranscodeJob(mediaItem, transcodingIdentifier, timeOffsetInSeconds, durationInSeconds, client, trDef, selectedVersion);
            StreamDescriptor stream = null;
            try {
                stream = this.getDeliveryStrategy(mediaItem, selectedVersion).createInputStream(jobListener, ((PersistedEntity)mediaItem).getId(), trDef, client, this);
            }
            catch (IOException e) {
                jobListener.releaseResources();
                this.deliveryComplete(client);
                log.debug(String.format("Removing transcoding listener with id %s", transcodingIdentifier));
                throw e;
            }
            LinkedHashMap transcodedMediaInfos = this.retrieveTranscodedMediaInfo(mediaItem, client.getRendererProfile(), stream.getFileSize());
            Object transcodedMediaInfo = this.findMediaInfoForFileProfile(transcodedMediaInfos.get((Object)selectedQuality), selectedVersion);
            return new StreamDeliveryContainer(new BufferedInputStream(stream.getStream(), 65536), (ResourceInfo)transcodedMediaInfo, jobListener);
        }
        throw new IOException(String.format("Cannot find transcoding definition for %s quality", selectedQuality.toString()));
    }

    @Override
    protected RI retrieveTranscodedMediaInfoForVersion(MI mediaItem, MediaFormatProfile selectedVersion, DeliveryQuality.QualityType selectedQuality, Profile rendererProfile) throws UnsupportedDLNAMediaFileFormatException {
        log.debug(String.format("Getting media info for transcoded version of file %s", ((MediaItem)mediaItem).getFileName()));
        LinkedHashMap mediaInfos = this.retrieveTranscodedMediaInfo(mediaItem, rendererProfile, null);
        return this.findMediaInfoForFileProfile(mediaInfos.get((Object)selectedQuality), selectedVersion);
    }

    @Override
    protected boolean fileCanBeTranscoded(MI mediaItem, Profile rendererProfile) {
        return (((MediaItem)mediaItem).isLocalMedia() && (Configuration.isTranscodingEnabled() || rendererProfile.isAlwaysEnableTranscoding()) && rendererProfile.hasAnyTranscodingDefinitions() || !((MediaItem)mediaItem).isLocalMedia() && rendererProfile.hasAnyOnlineTranscodingDefinitions() || AbstractTranscodingDeliveryEngine.hardSubsTranscodingConfigured(mediaItem, rendererProfile)) && this.getMatchingTranscodingDefinitions(mediaItem, rendererProfile, false).size() > 0;
    }

    @Override
    protected boolean fileWillBeTranscoded(MI mediaItem, MediaFormatProfile selectedVersion, DeliveryQuality.QualityType selectedQuality, Profile rendererProfile) throws UnsupportedDLNAMediaFileFormatException {
        return this.fileCanBeTranscoded(mediaItem, rendererProfile) && this.getMatchingTranscodingDefinitions(mediaItem, rendererProfile, false).get((Object)selectedQuality) != null;
    }

    protected OnlineContentType getOnlineContentType(MediaItem mediaItem) {
        if (mediaItem.isLocalMedia()) {
            return OnlineContentType.ANY;
        }
        if (mediaItem.isLive()) {
            return OnlineContentType.LIVE;
        }
        return OnlineContentType.VOD;
    }

    private void prepareClientStream(Client client, String transcodingIdentifier, TranscodingDefinition trDef) {
        if (transcodeJobs.containsKey(client)) {
            TranscodingJobListener existingJobListener = transcodeJobs.get(client);
            boolean closeStream = false;
            if (trDef.getTranscodingConfiguration().isKeepStreamOpen()) {
                if (existingJobListener != null && !existingJobListener.getTranscodingIdentifier().equals(transcodingIdentifier)) {
                    if (this.getCountOfListenerUsers(existingJobListener) <= 1) {
                        log.debug(String.format("No other client uses transcoding job of file '%s', will stop the job", existingJobListener.getTranscodingIdentifier()));
                        closeStream = true;
                    } else {
                        log.debug(String.format("Removing the client from transcoding job of file '%s'", existingJobListener.getTranscodingIdentifier()));
                        existingJobListener.closeStream(client);
                    }
                }
            } else {
                closeStream = true;
            }
            if (closeStream) {
                log.debug(String.format("Stopping previous transcoding job of file '%s'", existingJobListener.getTranscodingIdentifier()));
                existingJobListener.releaseResources();
                this.deliveryComplete(client);
            }
        }
    }

    private int getCountOfListenerUsers(TranscodingJobListener listener) {
        int c = 0;
        for (TranscodingJobListener l : transcodeJobs.values()) {
            if (!l.getTranscodingIdentifier().equals(listener.getTranscodingIdentifier())) continue;
            ++c;
        }
        return c;
    }

    private synchronized TranscodingJobListener startTranscodeJob(MI mediaItem, String transcodingIdentifier, Double timeOffsetInSeconds, Double durationInSeconds, Client client, TranscodingDefinition trDef, MediaFormatProfile selectedVersion) throws IOException {
        this.prepareClientStream(client, transcodingIdentifier, trDef);
        TranscodingJobListener newListener = null;
        Collection<TranscodingJobListener> availableListeners = this.findExistingJobListeners(client, ((MediaItem)mediaItem).isLive(), trDef.getTranscodingConfiguration().isKeepStreamOpen());
        for (TranscodingJobListener listener : availableListeners) {
            if (!listener.getTranscodingIdentifier().equals(transcodingIdentifier)) continue;
            log.debug(String.format("A suitable transcoding job already exists, re-use it for client '%s'", client));
            newListener = listener;
            break;
        }
        if (newListener == null) {
            log.debug(String.format("No suitable transcoding job exists yet, start one for client '%s'", client));
            this.updateFeedUrl(mediaItem);
            newListener = this.getDeliveryStrategy(mediaItem, selectedVersion).invokeTranscoder(transcodingIdentifier, (MediaItem)mediaItem, timeOffsetInSeconds, durationInSeconds, trDef, client, this);
        }
        this.registerJob(client, newListener);
        return newListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerJob(Client client, TranscodingJobListener jobListener) {
        Map<Client, TranscodingJobListener> map = transcodeJobs;
        synchronized (map) {
            transcodeJobs.put(client, jobListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<TranscodingJobListener> findExistingJobListeners(Client client, boolean liveStream, boolean keepLiveStreamsOpen) {
        Map<Client, TranscodingJobListener> map = transcodeJobs;
        synchronized (map) {
            if (!liveStream) {
                return transcodeJobs.values();
            }
            if (transcodeJobs.containsKey(client) && keepLiveStreamsOpen) {
                return Collections.singleton(transcodeJobs.get(client));
            }
            return Collections.emptySet();
        }
    }

    private static void deleteTranscodeFiles() {
        File transcodeFolder = AbstractTranscodingDeliveryEngine.getTranscodingFolder();
        if (transcodeFolder.exists() && transcodeFolder.isDirectory()) {
            File[] transcodedFiles;
            log.debug(String.format("Deleting temporary transcoded files from: %s", transcodeFolder));
            for (File f : transcodedFiles = transcodeFolder.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    String extension = FileUtils.getFileExtension(StringUtils.localeSafeToLowercase(name));
                    return extension.equals(AbstractTranscodingDeliveryEngine.TRANSCODED_FILE_EXTENSION) || SubtitleCodec.getAllSupportedExtensions().contains(extension);
                }
            })) {
                boolean result = FileUtils.deleteFileOrFolder(f);
                log.debug(String.format("Deleted file %s: %s", f, result));
            }
        }
    }

    private TranscodingDeliveryStrategy<?> getDeliveryStrategy(MI mediaItem, MediaFormatProfile formatProfile) {
        if (formatProfile.isManifestFormat()) {
            return ((MediaItem)mediaItem).isLive() ? liveSegmentBasedStrategy : segmentBasedStrategy;
        }
        return ((MediaItem)mediaItem).isLive() ? streamBasedStrategy : fileBasedStrategy;
    }
}

