/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.delivery.resource;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.serviio.delivery.VideoMediaInfo;
import org.serviio.delivery.resource.transcode.AbstractTranscodingDeliveryEngine;
import org.serviio.delivery.resource.transcode.TranscodingDefinition;
import org.serviio.delivery.resource.transcode.VideoTranscodingDefinition;
import org.serviio.delivery.resource.transcode.VideoTranscodingMatch;
import org.serviio.dlna.AudioCodec;
import org.serviio.dlna.MediaFormatProfile;
import org.serviio.dlna.MediaFormatProfileResolver;
import org.serviio.dlna.UnsupportedDLNAMediaFileFormatException;
import org.serviio.dlna.VideoCodec;
import org.serviio.dlna.VideoContainer;
import org.serviio.external.FFMPEGWrapper;
import org.serviio.external.ResizeDefinition;
import org.serviio.library.entities.Video;
import org.serviio.library.local.metadata.TransportStreamTimestamp;
import org.serviio.profile.DeliveryQuality;
import org.serviio.profile.Profile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VideoDeliveryEngine
extends AbstractTranscodingDeliveryEngine<VideoMediaInfo, Video> {
    private static VideoDeliveryEngine instance;
    private static final Logger log;

    protected VideoDeliveryEngine() {
    }

    public static VideoDeliveryEngine getInstance() {
        if (instance == null) {
            instance = new VideoDeliveryEngine();
        }
        return instance;
    }

    @Override
    protected LinkedHashMap<DeliveryQuality.QualityType, List<VideoMediaInfo>> retrieveOriginalMediaInfo(Video mediaItem, Profile rendererProfile) throws UnsupportedDLNAMediaFileFormatException {
        List<MediaFormatProfile> fileProfiles = MediaFormatProfileResolver.resolve(mediaItem);
        LinkedHashMap<DeliveryQuality.QualityType, List<VideoMediaInfo>> mediaInfoMap = new LinkedHashMap<DeliveryQuality.QualityType, List<VideoMediaInfo>>();
        ArrayList<VideoMediaInfo> mediaInfos = new ArrayList<VideoMediaInfo>();
        for (MediaFormatProfile fileProfile : fileProfiles) {
            mediaInfos.add(new VideoMediaInfo(mediaItem.getId(), fileProfile, mediaItem.getFileSize(), mediaItem.getWidth(), mediaItem.getHeight(), mediaItem.getBitrate(), false, mediaItem.isLive(), mediaItem.getDuration(), rendererProfile.getMimeType(fileProfile), DeliveryQuality.QualityType.ORIGINAL));
        }
        mediaInfoMap.put(DeliveryQuality.QualityType.ORIGINAL, mediaInfos);
        return mediaInfoMap;
    }

    @Override
    protected LinkedHashMap<DeliveryQuality.QualityType, List<VideoMediaInfo>> retrieveTranscodedMediaInfo(Video mediaItem, Profile rendererProfile, Long fileSize) {
        LinkedHashMap<DeliveryQuality.QualityType, List<VideoMediaInfo>> transcodedMI = new LinkedHashMap<DeliveryQuality.QualityType, List<VideoMediaInfo>>();
        Map<DeliveryQuality.QualityType, TranscodingDefinition> trDefs = this.getMatchingTranscodingDefinitions(mediaItem, rendererProfile, false);
        if (trDefs.size() > 0) {
            for (Map.Entry<DeliveryQuality.QualityType, TranscodingDefinition> trDefEntry : trDefs.entrySet()) {
                DeliveryQuality.QualityType qualityType = trDefEntry.getKey();
                VideoTranscodingDefinition trDef = (VideoTranscodingDefinition)trDefEntry.getValue();
                AudioCodec targetAudioCodec = mediaItem.getAudioCodec() != null && trDef.getTargetAudioCodec() != null ? trDef.getTargetAudioCodec() : mediaItem.getAudioCodec();
                VideoCodec targetVideoCodec = FFMPEGWrapper.getTargetVideoCodec(mediaItem, trDef);
                Integer targetBitrate = trDef.getMaxVideoBitrate() != null ? trDef.getMaxVideoBitrate() : mediaItem.getBitrate();
                ResizeDefinition targetDimensions = FFMPEGWrapper.getTargetVideoDimensions(mediaItem, trDef.getMaxHeight(), trDef.getDar(), trDef.getTargetContainer());
                try {
                    ArrayList<VideoMediaInfo> mediaInfos = new ArrayList<VideoMediaInfo>();
                    List<MediaFormatProfile> transcodedProfiles = MediaFormatProfileResolver.resolveVideoFormat(mediaItem.getFileName(), trDef.getTargetContainer(), targetVideoCodec, targetAudioCodec, targetDimensions.width, targetDimensions.height, targetBitrate, trDef.getTargetContainer() == VideoContainer.M2TS ? TransportStreamTimestamp.VALID : TransportStreamTimestamp.NONE);
                    for (MediaFormatProfile transcodedProfile : transcodedProfiles) {
                        log.debug(String.format("Found Format profile for transcoded file %s: %s", new Object[]{mediaItem.getFileName(), transcodedProfile}));
                        mediaInfos.add(new VideoMediaInfo(mediaItem.getId(), transcodedProfile, fileSize, targetDimensions.width, targetDimensions.height, targetBitrate, true, mediaItem.isLive(), mediaItem.getDuration(), rendererProfile.getMimeType(transcodedProfile), qualityType));
                    }
                    transcodedMI.put(qualityType, mediaInfos);
                }
                catch (UnsupportedDLNAMediaFileFormatException e) {
                    log.warn(String.format("Cannot get media info for transcoded file %s: %s", mediaItem.getFileName(), e.getMessage()));
                }
            }
            return transcodedMI;
        }
        log.warn(String.format("Cannot find matching transcoding definition for file %s", mediaItem.getFileName()));
        return new LinkedHashMap<DeliveryQuality.QualityType, List<VideoMediaInfo>>();
    }

    @Override
    public TranscodingDefinition getMatchingTranscodingDefinition(List<TranscodingDefinition> tDefs, Video mediaItem) {
        if (tDefs != null && tDefs.size() > 0) {
            for (TranscodingDefinition tDef : tDefs) {
                List<VideoTranscodingMatch> matches = ((VideoTranscodingDefinition)tDef).getMatches();
                for (VideoTranscodingMatch match : matches) {
                    if (!match.matches(mediaItem.getContainer(), mediaItem.getVideoCodec(), mediaItem.getAudioCodec(), mediaItem.getH264Profile(), mediaItem.getH264Levels(), mediaItem.getFtyp(), this.getOnlineContentType(mediaItem), mediaItem.getSar().isSquarePixels(), mediaItem.getVideoFourCC())) continue;
                    return (VideoTranscodingDefinition)tDef;
                }
            }
        }
        return null;
    }

    static {
        log = LoggerFactory.getLogger(VideoDeliveryEngine.class);
    }
}

