/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.delivery.resource;

import java.awt.Dimension;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.serviio.delivery.Client;
import org.serviio.delivery.DeliveryContainer;
import org.serviio.delivery.ImageMediaInfo;
import org.serviio.delivery.StreamDeliveryContainer;
import org.serviio.delivery.resource.AbstractDeliveryEngine;
import org.serviio.delivery.resource.transcode.ImageTranscodingDefinition;
import org.serviio.delivery.resource.transcode.ImageTranscodingMatch;
import org.serviio.delivery.resource.transcode.ImageTranscodingProfilesProvider;
import org.serviio.delivery.resource.transcode.TranscodingCache;
import org.serviio.delivery.resource.transcode.TranscodingDefinition;
import org.serviio.dlna.ImageContainer;
import org.serviio.dlna.MediaFormatProfile;
import org.serviio.dlna.MediaFormatProfileResolver;
import org.serviio.dlna.UnsupportedDLNAMediaFileFormatException;
import org.serviio.external.DCRawWrapper;
import org.serviio.library.entities.Image;
import org.serviio.library.local.service.MediaService;
import org.serviio.profile.DeliveryQuality;
import org.serviio.profile.Profile;
import org.serviio.util.FileUtils;
import org.serviio.util.ImageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageDeliveryEngine
extends AbstractDeliveryEngine<ImageMediaInfo, Image> {
    private static final Logger log = LoggerFactory.getLogger(ImageDeliveryEngine.class);
    private static final List<MediaFormatProfile> JPEG_PROFILES = Arrays.asList(MediaFormatProfile.JPEG_LRG, MediaFormatProfile.JPEG_MED, MediaFormatProfile.JPEG_SM);
    private static TranscodingCache transcodingCache = new TranscodingCache();
    private static ImageDeliveryEngine instance;

    private ImageDeliveryEngine() {
    }

    public static ImageDeliveryEngine getInstance() {
        if (instance == null) {
            instance = new ImageDeliveryEngine();
        }
        return instance;
    }

    @Override
    protected LinkedHashMap<DeliveryQuality.QualityType, List<ImageMediaInfo>> retrieveTranscodedMediaInfo(Image mediaItem, Profile rendererProfile, Long fileSize) {
        log.debug(String.format("Getting media info for transcoded versions of file %s", mediaItem.getFileName()));
        LinkedHashMap<DeliveryQuality.QualityType, List<ImageMediaInfo>> resourceInfos = new LinkedHashMap<DeliveryQuality.QualityType, List<ImageMediaInfo>>();
        try {
            List<MediaFormatProfile> fileProfiles;
            List<MediaFormatProfile> optionalProfiles;
            boolean originalWillBeTransformed = this.imageWillBeTransformed(mediaItem, rendererProfile, DeliveryQuality.QualityType.ORIGINAL);
            if (originalWillBeTransformed) {
                try {
                    resourceInfos.put(this.getQualityType(MediaFormatProfile.JPEG_LRG), Collections.singletonList(this.createTranscodedImageInfoForProfile(mediaItem, MediaFormatProfile.JPEG_LRG, null, rendererProfile)));
                }
                catch (UnsupportedDLNAMediaFileFormatException ex) {
                    log.warn(String.format("Cannot get media info for resized original file %s: %s", mediaItem.getFileName(), ex.getMessage()));
                }
            }
            if ((optionalProfiles = ImageTranscodingProfilesProvider.getAvailableTranscodingProfiles(fileProfiles = MediaFormatProfileResolver.resolve(mediaItem))) != null && this.imageIsResizable(mediaItem)) {
                for (MediaFormatProfile targetProfile : optionalProfiles) {
                    if (originalWillBeTransformed && (!originalWillBeTransformed || targetProfile == MediaFormatProfile.JPEG_LRG)) continue;
                    try {
                        resourceInfos.put(this.getQualityType(targetProfile), Collections.singletonList(this.createTranscodedImageInfoForProfile(mediaItem, targetProfile, fileSize, rendererProfile)));
                    }
                    catch (UnsupportedDLNAMediaFileFormatException ex) {
                        log.warn(String.format("Cannot get media info for transcoded file %s: %s", mediaItem.getFileName(), ex.getMessage()));
                    }
                }
            }
        }
        catch (UnsupportedDLNAMediaFileFormatException ex1) {
            log.warn(String.format("Unknown DLNA format profile of file %s: %s", mediaItem.getFileName(), ex1.getMessage()));
        }
        return resourceInfos;
    }

    @Override
    protected ImageMediaInfo retrieveTranscodedMediaInfoForVersion(Image mediaItem, MediaFormatProfile selectedVersion, DeliveryQuality.QualityType selectedQuality, Profile rendererProfile) throws UnsupportedDLNAMediaFileFormatException {
        log.debug(String.format("Getting media info for transcoded version of file %s", mediaItem.getFileName()));
        return this.createTranscodedImageInfoForProfile(mediaItem, selectedVersion, null, rendererProfile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected DeliveryContainer retrieveTranscodedResource(Image mediaItem, MediaFormatProfile selectedVersion, DeliveryQuality.QualityType selectedQuality, Double timeOffsetInSeconds, Double durationInSeconds, Client client) throws IOException, UnsupportedDLNAMediaFileFormatException {
        log.debug(String.format("Retrieving transcoded version of file %s using format profile %s", new Object[]{mediaItem.getFileName(), selectedVersion}));
        byte[] transcodedImageBytes = null;
        TranscodingCache transcodingCache = ImageDeliveryEngine.transcodingCache;
        synchronized (transcodingCache) {
            if (ImageDeliveryEngine.transcodingCache.isInCache(mediaItem.getId(), selectedVersion)) {
                transcodedImageBytes = ImageDeliveryEngine.transcodingCache.getCachedBytes();
            } else {
                transcodedImageBytes = this.transcodeImage(mediaItem, selectedVersion, client.getRendererProfile());
                ImageDeliveryEngine.transcodingCache.storeInCache(mediaItem.getId(), selectedVersion, transcodedImageBytes);
            }
        }
        StreamDeliveryContainer container = new StreamDeliveryContainer(new ByteArrayInputStream(transcodedImageBytes), this.createTranscodedImageInfoForProfile(mediaItem, selectedVersion, Long.valueOf(transcodedImageBytes.length), client.getRendererProfile()));
        return container;
    }

    @Override
    protected boolean fileCanBeTranscoded(Image mediaItem, Profile rendererProfile) {
        return this.imageIsResizable(mediaItem);
    }

    @Override
    protected boolean fileWillBeTranscoded(Image mediaItem, MediaFormatProfile selectedVersion, DeliveryQuality.QualityType selectedQuality, Profile rendererProfile) throws UnsupportedDLNAMediaFileFormatException {
        List<MediaFormatProfile> fileProfiles = MediaFormatProfileResolver.resolve(mediaItem);
        boolean imageWillBeTransformed = this.imageWillBeTransformed(mediaItem, rendererProfile, selectedQuality);
        if (selectedVersion == null || fileProfiles.contains((Object)selectedVersion)) {
            return imageWillBeTransformed;
        }
        List<MediaFormatProfile> optionalProfiles = ImageTranscodingProfilesProvider.getAvailableTranscodingProfiles(fileProfiles);
        return optionalProfiles != null && optionalProfiles.size() > 0;
    }

    @Override
    protected LinkedHashMap<DeliveryQuality.QualityType, List<ImageMediaInfo>> retrieveOriginalMediaInfo(Image image, Profile rendererProfile) throws UnsupportedDLNAMediaFileFormatException {
        if (!this.transcodeNeeded(image, rendererProfile, DeliveryQuality.QualityType.ORIGINAL)) {
            if (this.imageWillRotate(image, rendererProfile, false)) {
                return null;
            }
            List<MediaFormatProfile> fileProfiles = MediaFormatProfileResolver.resolve(image);
            LinkedHashMap<DeliveryQuality.QualityType, List<ImageMediaInfo>> result = new LinkedHashMap<DeliveryQuality.QualityType, List<ImageMediaInfo>>();
            for (MediaFormatProfile fileProfile : fileProfiles) {
                result.put(DeliveryQuality.QualityType.ORIGINAL, Collections.singletonList(new ImageMediaInfo(image.getId(), fileProfile, image.getFileSize(), image.getWidth(), image.getHeight(), false, rendererProfile.getMimeType(fileProfile), DeliveryQuality.QualityType.ORIGINAL)));
            }
            return result;
        }
        return null;
    }

    @Override
    protected TranscodingDefinition getMatchingTranscodingDefinition(List<TranscodingDefinition> tDefs, Image mediaItem) {
        if (tDefs != null && tDefs.size() > 0) {
            for (TranscodingDefinition tDef : tDefs) {
                List<ImageTranscodingMatch> matches = ((ImageTranscodingDefinition)tDef).getMatches();
                for (ImageTranscodingMatch match : matches) {
                    if (!match.matches(mediaItem.getContainer(), mediaItem.getChromaSubsampling())) continue;
                    return (ImageTranscodingDefinition)tDef;
                }
            }
        }
        return null;
    }

    private boolean imageWillBeTransformed(Image mediaItem, Profile rendererProfile, DeliveryQuality.QualityType quality) {
        boolean originalTranscoded = this.transcodeNeeded(mediaItem, rendererProfile, quality);
        boolean imageRotated = this.imageWillRotate(mediaItem, rendererProfile, originalTranscoded);
        return originalTranscoded || imageRotated;
    }

    private ImageMediaInfo createTranscodedImageInfoForProfile(Image originalImage, MediaFormatProfile selectedVersion, Long fileSize, Profile rendererProfile) throws UnsupportedDLNAMediaFileFormatException {
        if (this.isTranscodingValid(originalImage, selectedVersion)) {
            int maxWidth = 0;
            int maxHeight = 0;
            DeliveryQuality.QualityType quality = this.getQualityType(selectedVersion);
            if (selectedVersion == MediaFormatProfile.JPEG_SM) {
                maxWidth = rendererProfile.getAllowedImageResolutions().getSmall().getValueA();
                maxHeight = rendererProfile.getAllowedImageResolutions().getSmall().getValueB();
            } else if (selectedVersion == MediaFormatProfile.JPEG_MED) {
                maxWidth = rendererProfile.getAllowedImageResolutions().getMedium().getValueA();
                maxHeight = rendererProfile.getAllowedImageResolutions().getMedium().getValueB();
            } else {
                maxWidth = rendererProfile.getAllowedImageResolutions().getLarge().getValueA();
                maxHeight = rendererProfile.getAllowedImageResolutions().getLarge().getValueB();
            }
            Dimension newDimension = ImageUtils.getResizedDimensions(originalImage.getWidth(), originalImage.getHeight(), maxWidth, maxHeight);
            if (this.imageWillRotate(originalImage, rendererProfile, true)) {
                return new ImageMediaInfo(originalImage.getId(), selectedVersion, fileSize, (int)newDimension.getHeight(), (int)newDimension.getWidth(), true, rendererProfile.getMimeType(selectedVersion), quality);
            }
            return new ImageMediaInfo(originalImage.getId(), selectedVersion, fileSize, (int)newDimension.getWidth(), (int)newDimension.getHeight(), true, rendererProfile.getMimeType(selectedVersion), quality);
        }
        throw new UnsupportedDLNAMediaFileFormatException("Images can only be transformed to JPEG continer");
    }

    private DeliveryQuality.QualityType getQualityType(MediaFormatProfile mediaFormatProfile) {
        if (mediaFormatProfile == MediaFormatProfile.JPEG_SM) {
            return DeliveryQuality.QualityType.LOW;
        }
        if (mediaFormatProfile == MediaFormatProfile.JPEG_MED) {
            return DeliveryQuality.QualityType.MEDIUM;
        }
        return DeliveryQuality.QualityType.ORIGINAL;
    }

    private byte[] transcodeImage(Image originalImage, MediaFormatProfile selectedVersion, Profile rendererProfile) throws UnsupportedDLNAMediaFileFormatException, IOException {
        byte[] originalImageBytes = this.getImageBytes(originalImage);
        if (this.isTranscodingValid(originalImage, selectedVersion)) {
            try {
                byte[] transcodedImage = null;
                if (selectedVersion == MediaFormatProfile.JPEG_SM) {
                    transcodedImage = ImageUtils.resizeImageAsJPG(originalImageBytes, (int)rendererProfile.getAllowedImageResolutions().getSmall().getValueA(), (int)rendererProfile.getAllowedImageResolutions().getSmall().getValueB()).getImageData();
                } else if (selectedVersion == MediaFormatProfile.JPEG_MED) {
                    transcodedImage = ImageUtils.resizeImageAsJPG(originalImageBytes, (int)rendererProfile.getAllowedImageResolutions().getMedium().getValueA(), (int)rendererProfile.getAllowedImageResolutions().getMedium().getValueB()).getImageData();
                } else if (selectedVersion == MediaFormatProfile.JPEG_LRG) {
                    transcodedImage = ImageUtils.resizeImageAsJPG(originalImageBytes, (int)rendererProfile.getAllowedImageResolutions().getLarge().getValueA(), (int)rendererProfile.getAllowedImageResolutions().getLarge().getValueB()).getImageData();
                } else {
                    throw new UnsupportedDLNAMediaFileFormatException(String.format("Unsupported transcoding profile requested: %s", selectedVersion.toString()));
                }
                if (this.imageWillRotate(originalImage, rendererProfile, true)) {
                    transcodedImage = ImageUtils.rotateImage(transcodedImage, originalImage.getRotation()).getImageData();
                }
                return transcodedImage;
            }
            catch (Throwable e) {
                throw new IOException("Cannot transcode image: " + e.getMessage(), e);
            }
        }
        throw new UnsupportedDLNAMediaFileFormatException("Only JPEG can be usedas a target container for image trancoding at the moment");
    }

    private byte[] getImageBytes(Image image) {
        try {
            if (image.isLocalMedia()) {
                File imageFile = MediaService.getFile(image.getId());
                if (image.getContainer() == ImageContainer.RAW) {
                    return DCRawWrapper.retrieveThumbnailFromRawFile(FileUtils.getProperFilePath(imageFile));
                }
                return FileUtils.readFileBytes(imageFile);
            }
            InputStream onlineStream = this.getOnlineInputStream(image);
            return FileUtils.readFileBytes(onlineStream);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean transcodeNeeded(Image image, Profile rendererProfile, DeliveryQuality.QualityType quality) {
        if (this.getMatchingTranscodingDefinitions(image, rendererProfile, false).get((Object)quality) != null) {
            return true;
        }
        if (this.imageIsResizable(image) && rendererProfile.isLimitImageResolution()) {
            if (image.getContainer() == ImageContainer.JPEG) {
                return image.getWidth() > rendererProfile.getAllowedImageResolutions().getLarge().getValueA() || image.getHeight() > rendererProfile.getAllowedImageResolutions().getLarge().getValueB();
            }
            if (image.getContainer() == ImageContainer.PNG) {
                return image.getWidth() > rendererProfile.getAllowedImageResolutions().getLarge().getValueA() || image.getHeight() > rendererProfile.getAllowedImageResolutions().getLarge().getValueB();
            }
            if (image.getContainer() == ImageContainer.GIF) {
                return image.getWidth() > 1600 || image.getHeight() > 1200;
            }
            return false;
        }
        return false;
    }

    private boolean imageWillRotate(Image image, Profile profile, boolean willBeResized) {
        return image.getRotation() != null && !image.getRotation().equals(new Integer(0)) && (profile.isAutomaticImageRotation() || willBeResized);
    }

    private boolean isTranscodingValid(Image originalImage, MediaFormatProfile targetFormat) {
        return (originalImage.getContainer() == ImageContainer.JPEG || originalImage.getContainer() == ImageContainer.PNG || originalImage.getContainer() == ImageContainer.GIF || originalImage.getContainer() == ImageContainer.RAW) && JPEG_PROFILES.contains((Object)targetFormat);
    }

    private boolean imageIsResizable(Image image) {
        return image.getWidth() != null && image.getHeight() != null;
    }
}

