/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.delivery.resource;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.serviio.delivery.AudioMediaInfo;
import org.serviio.delivery.resource.transcode.AbstractTranscodingDeliveryEngine;
import org.serviio.delivery.resource.transcode.AudioTranscodingDefinition;
import org.serviio.delivery.resource.transcode.AudioTranscodingMatch;
import org.serviio.delivery.resource.transcode.TranscodingDefinition;
import org.serviio.dlna.AudioContainer;
import org.serviio.dlna.MediaFormatProfile;
import org.serviio.dlna.MediaFormatProfileResolver;
import org.serviio.dlna.UnsupportedDLNAMediaFileFormatException;
import org.serviio.external.FFMPEGWrapper;
import org.serviio.library.entities.MusicTrack;
import org.serviio.profile.DeliveryQuality;
import org.serviio.profile.Profile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AudioDeliveryEngine
extends AbstractTranscodingDeliveryEngine<AudioMediaInfo, MusicTrack> {
    private static AudioDeliveryEngine instance;
    private static final Logger log;

    private AudioDeliveryEngine() {
    }

    public static AudioDeliveryEngine getInstance() {
        if (instance == null) {
            instance = new AudioDeliveryEngine();
        }
        return instance;
    }

    @Override
    protected LinkedHashMap<DeliveryQuality.QualityType, List<AudioMediaInfo>> retrieveOriginalMediaInfo(MusicTrack mediaItem, Profile rendererProfile) throws UnsupportedDLNAMediaFileFormatException {
        List<MediaFormatProfile> fileProfiles = MediaFormatProfileResolver.resolve(mediaItem);
        LinkedHashMap<DeliveryQuality.QualityType, List<AudioMediaInfo>> result = new LinkedHashMap<DeliveryQuality.QualityType, List<AudioMediaInfo>>();
        ArrayList<AudioMediaInfo> mediaInfos = new ArrayList<AudioMediaInfo>();
        for (MediaFormatProfile fileProfile : fileProfiles) {
            mediaInfos.add(new AudioMediaInfo(mediaItem.getId(), fileProfile, mediaItem.getFileSize(), false, mediaItem.isLive(), mediaItem.getDuration(), rendererProfile.getMimeType(fileProfile), mediaItem.getChannels(), mediaItem.getSampleFrequency(), mediaItem.getBitrate(), DeliveryQuality.QualityType.ORIGINAL));
        }
        result.put(DeliveryQuality.QualityType.ORIGINAL, mediaInfos);
        return result;
    }

    @Override
    protected LinkedHashMap<DeliveryQuality.QualityType, List<AudioMediaInfo>> retrieveTranscodedMediaInfo(MusicTrack mediaItem, Profile rendererProfile, Long fileSize) {
        LinkedHashMap<DeliveryQuality.QualityType, List<AudioMediaInfo>> transcodedMI = new LinkedHashMap<DeliveryQuality.QualityType, List<AudioMediaInfo>>();
        Map<DeliveryQuality.QualityType, TranscodingDefinition> trDefs = this.getMatchingTranscodingDefinitions(mediaItem, rendererProfile, false);
        if (trDefs.size() > 0) {
            for (Map.Entry<DeliveryQuality.QualityType, TranscodingDefinition> trDefEntry : trDefs.entrySet()) {
                DeliveryQuality.QualityType qualityType = trDefEntry.getKey();
                AudioTranscodingDefinition trDef = (AudioTranscodingDefinition)trDefEntry.getValue();
                Integer targetSamplerate = FFMPEGWrapper.getAudioFrequency(trDef, mediaItem.getSampleFrequency(), trDef.getTargetContainer() == AudioContainer.LPCM);
                Integer targetBitrate = FFMPEGWrapper.getAudioBitrate(mediaItem.getBitrate(), trDef);
                Integer targetChannels = FFMPEGWrapper.getAudioChannelNumber(mediaItem.getChannels(), null, true, false);
                try {
                    MediaFormatProfile transcodedProfile = MediaFormatProfileResolver.resolveAudioFormat(mediaItem.getFileName(), trDef.getTargetContainer(), targetBitrate, targetSamplerate, targetChannels);
                    log.debug(String.format("Found Format profile for transcoded file %s: %s", new Object[]{mediaItem.getFileName(), transcodedProfile}));
                    transcodedMI.put(qualityType, Collections.singletonList(new AudioMediaInfo(mediaItem.getId(), transcodedProfile, fileSize, true, mediaItem.isLive(), mediaItem.getDuration(), rendererProfile.getMimeType(transcodedProfile), targetChannels, targetSamplerate, targetBitrate, qualityType)));
                }
                catch (UnsupportedDLNAMediaFileFormatException e) {
                    log.warn(String.format("Cannot get media info for transcoded file %s: %s", mediaItem.getFileName(), e.getMessage()));
                }
            }
            return transcodedMI;
        }
        log.warn(String.format("Cannot find matching transcoding definition for file %s", mediaItem.getFileName()));
        return new LinkedHashMap<DeliveryQuality.QualityType, List<AudioMediaInfo>>();
    }

    @Override
    protected TranscodingDefinition getMatchingTranscodingDefinition(List<TranscodingDefinition> tDefs, MusicTrack mediaItem) {
        if (tDefs != null && tDefs.size() > 0) {
            for (TranscodingDefinition tDef : tDefs) {
                List<AudioTranscodingMatch> matches = ((AudioTranscodingDefinition)tDef).getMatches();
                for (AudioTranscodingMatch match : matches) {
                    if (!match.matches(mediaItem.getContainer(), this.getOnlineContentType(mediaItem))) continue;
                    return (AudioTranscodingDefinition)tDef;
                }
            }
        }
        return null;
    }

    static {
        log = LoggerFactory.getLogger(AudioDeliveryEngine.class);
    }
}

