/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.delivery.resource;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.serviio.ApplicationSettings;
import org.serviio.config.Configuration;
import org.serviio.db.entities.PersistedEntity;
import org.serviio.delivery.Client;
import org.serviio.delivery.DeliveryContainer;
import org.serviio.delivery.MediaFormatProfileResource;
import org.serviio.delivery.OnlineInputStream;
import org.serviio.delivery.ResourceInfo;
import org.serviio.delivery.StreamDeliveryContainer;
import org.serviio.delivery.resource.DeliveryEngine;
import org.serviio.delivery.resource.VideoDeliveryEngine;
import org.serviio.delivery.resource.transcode.TranscodingDefinition;
import org.serviio.delivery.subtitles.SubtitlesReader;
import org.serviio.delivery.subtitles.SubtitlesService;
import org.serviio.dlna.MediaFormatProfile;
import org.serviio.dlna.UnsupportedDLNAMediaFileFormatException;
import org.serviio.library.entities.MediaItem;
import org.serviio.library.entities.Video;
import org.serviio.library.local.service.MediaService;
import org.serviio.library.metadata.MediaFileType;
import org.serviio.library.online.AbstractUrlExtractor;
import org.serviio.library.online.ContentURLContainer;
import org.serviio.profile.DeliveryQuality;
import org.serviio.profile.Profile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDeliveryEngine<RI extends MediaFormatProfileResource, MI extends MediaItem>
implements DeliveryEngine<RI, MI> {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    public static boolean isHardSubsDelivered(DeliveryQuality quality, MediaItem mediaItem, Profile profile) {
        return AbstractDeliveryEngine.findTranscodingForHardSubs(quality, mediaItem, profile, false) != null;
    }

    @Override
    public List<RI> getMediaInfoForProfile(MI mediaItem, Profile rendererProfile) {
        this.log.debug(String.format("Retrieving resource information for item %s and profile %s", ((PersistedEntity)mediaItem).getId(), rendererProfile.getName()));
        LinkedHashMap<DeliveryQuality.QualityType, List<RI>> infos = new LinkedHashMap<DeliveryQuality.QualityType, List<RI>>();
        try {
            LinkedHashMap<DeliveryQuality.QualityType, List<RI>> originalMediaInfos = this.retrieveOriginalMediaInfo(mediaItem, rendererProfile);
            if (originalMediaInfos != null) {
                infos.putAll(originalMediaInfos);
            }
        }
        catch (UnsupportedDLNAMediaFileFormatException e) {
            // empty catch block
        }
        if (this.fileCanBeTranscoded(mediaItem, rendererProfile)) {
            infos.putAll(this.retrieveTranscodedMediaInfo(mediaItem, rendererProfile, null));
        }
        return this.flattenMediaInfoMap(infos);
    }

    @Override
    public DeliveryContainer deliver(MI mediaItem, MediaFormatProfile selectedVersion, DeliveryQuality.QualityType selectedQuality, Double timeOffsetInSeconds, Double durationInSeconds, Client client) throws UnsupportedDLNAMediaFileFormatException, IOException, FileNotFoundException {
        this.log.debug(String.format("Delivering item '%s' for client '%s'", ((PersistedEntity)mediaItem).getId(), client));
        if (this.fileWillBeTranscoded(mediaItem, selectedVersion, selectedQuality, client.getRendererProfile())) {
            this.log.debug(String.format("Delivering file '%s' using transcoding", ((MediaItem)mediaItem).getFileName()));
            return this.retrieveTranscodedResource(mediaItem, selectedVersion, selectedQuality, timeOffsetInSeconds, durationInSeconds, client);
        }
        this.log.debug(String.format("Delivering file '%s' in native format", ((MediaItem)mediaItem).getFileName()));
        return this.retrieveOriginalFileContainer(mediaItem, selectedVersion, client);
    }

    @Override
    public RI getMediaInfoForMediaItem(MI mediaItem, MediaFormatProfile selectedVersion, DeliveryQuality.QualityType selectedQuality, Profile rendererProfile) throws UnsupportedDLNAMediaFileFormatException {
        this.log.debug(String.format("Retrieving resource information for item %s, format %s and profile %s", new Object[]{((PersistedEntity)mediaItem).getId(), selectedVersion, rendererProfile.getName()}));
        if (this.fileWillBeTranscoded(mediaItem, selectedVersion, selectedQuality, rendererProfile)) {
            return this.retrieveTranscodedMediaInfoForVersion(mediaItem, selectedVersion, selectedQuality, rendererProfile);
        }
        LinkedHashMap<DeliveryQuality.QualityType, List<RI>> originalMediaInfos = this.retrieveOriginalMediaInfo(mediaItem, rendererProfile);
        return this.findMediaInfoForFileProfile((Collection)originalMediaInfos.get((Object)DeliveryQuality.QualityType.ORIGINAL), selectedVersion);
    }

    protected abstract boolean fileCanBeTranscoded(MI var1, Profile var2);

    protected abstract boolean fileWillBeTranscoded(MI var1, MediaFormatProfile var2, DeliveryQuality.QualityType var3, Profile var4) throws UnsupportedDLNAMediaFileFormatException;

    protected abstract LinkedHashMap<DeliveryQuality.QualityType, List<RI>> retrieveOriginalMediaInfo(MI var1, Profile var2) throws UnsupportedDLNAMediaFileFormatException;

    protected abstract LinkedHashMap<DeliveryQuality.QualityType, List<RI>> retrieveTranscodedMediaInfo(MI var1, Profile var2, Long var3);

    protected abstract RI retrieveTranscodedMediaInfoForVersion(MI var1, MediaFormatProfile var2, DeliveryQuality.QualityType var3, Profile var4) throws UnsupportedDLNAMediaFileFormatException;

    protected abstract TranscodingDefinition getMatchingTranscodingDefinition(List<TranscodingDefinition> var1, MI var2);

    protected abstract DeliveryContainer retrieveTranscodedResource(MI var1, MediaFormatProfile var2, DeliveryQuality.QualityType var3, Double var4, Double var5, Client var6) throws IOException, UnsupportedDLNAMediaFileFormatException;

    protected Map<DeliveryQuality.QualityType, TranscodingDefinition> getMatchingTranscodingDefinitions(MI mediaItem, Profile rendererProfile, boolean delivering) {
        LinkedHashMap<DeliveryQuality.QualityType, TranscodingDefinition> defs = new LinkedHashMap<DeliveryQuality.QualityType, TranscodingDefinition>();
        TranscodingDefinition defaultDefinition = this.getMatchingTranscodingDefinitionForQuality(rendererProfile.getDefaultDeliveryQuality(), mediaItem, rendererProfile, delivering);
        if (defaultDefinition != null) {
            defs.put(DeliveryQuality.QualityType.ORIGINAL, defaultDefinition);
        }
        for (DeliveryQuality altQuality : rendererProfile.getAlternativeDeliveryQualities()) {
            TranscodingDefinition def = this.getMatchingTranscodingDefinitionForQuality(altQuality, mediaItem, rendererProfile, delivering);
            if (def == null) continue;
            defs.put(altQuality.getType(), def);
        }
        return defs;
    }

    private TranscodingDefinition getMatchingTranscodingDefinitionForQuality(DeliveryQuality quality, MI mediaItem, Profile profile, boolean delivering) {
        List<TranscodingDefinition> localTDefs = quality.getTranscodingConfiguration() != null ? quality.getTranscodingConfiguration().getDefinitions(((MediaItem)mediaItem).getFileType()) : null;
        List<TranscodingDefinition> onlineTDefs = quality.getOnlineTranscodingConfiguration() != null ? quality.getOnlineTranscodingConfiguration().getDefinitions(((MediaItem)mediaItem).getFileType()) : null;
        TranscodingDefinition result = AbstractDeliveryEngine.findTranscodingForHardSubs(quality, mediaItem, profile, delivering);
        if (result == null && !((MediaItem)mediaItem).isLocalMedia()) {
            result = this.getMatchingTranscodingDefinition(onlineTDefs, mediaItem);
        }
        if (result == null) {
            result = this.getMatchingTranscodingDefinition(localTDefs, mediaItem);
        }
        return result;
    }

    private static TranscodingDefinition findTranscodingForHardSubs(DeliveryQuality quality, MediaItem mediaItem, Profile profile, boolean delivering) {
        SubtitlesReader subsReader;
        List<TranscodingDefinition> hardSubsTDefs = quality.getHardSubsTranscodingConfiguration() != null ? quality.getHardSubsTranscodingConfiguration().getDefinitions(mediaItem.getFileType()) : null;
        TranscodingDefinition result = null;
        if (mediaItem.getFileType() == MediaFileType.VIDEO && AbstractDeliveryEngine.hardSubsTranscodingConfigured(mediaItem, profile) && (subsReader = SubtitlesService.getHardSubs((Video)mediaItem, profile)) != null && (result = new VideoDeliveryEngine().getMatchingTranscodingDefinition(hardSubsTDefs, (Video)mediaItem)) != null && delivering) {
            try {
                mediaItem.getDeliveryContext().setHardsubsSubtitlesFile(subsReader.getSubtitlesInOriginalFormat());
            }
            catch (IOException e) {
                LoggerFactory.getLogger(AbstractDeliveryEngine.class).warn(e.getMessage());
            }
        }
        return result;
    }

    protected DeliveryContainer retrieveOriginalFileContainer(MI mediaItem, MediaFormatProfile selectedVersion, Client client) throws FileNotFoundException, UnsupportedDLNAMediaFileFormatException {
        InputStream fis = null;
        if (((MediaItem)mediaItem).isLocalMedia()) {
            File file = MediaService.getFile(((PersistedEntity)mediaItem).getId());
            fis = new FileInputStream(file);
        } else {
            fis = this.getOnlineInputStream(mediaItem);
        }
        LinkedHashMap<DeliveryQuality.QualityType, List<RI>> mediaInfos = this.retrieveOriginalMediaInfo(mediaItem, client.getRendererProfile());
        return new StreamDeliveryContainer(fis, (ResourceInfo)this.findMediaInfoForFileProfile((Collection)mediaInfos.get((Object)DeliveryQuality.QualityType.ORIGINAL), selectedVersion));
    }

    protected InputStream getOnlineInputStream(MI mediaItem) throws FileNotFoundException {
        try {
            int buffer = ((MediaItem)mediaItem).isLive() ? ApplicationSettings.getIntegerProperty("live_stream_buffer") : 1000000;
            return new BufferedInputStream(new OnlineInputStream(this.getOnlineItemURL(mediaItem), ((MediaItem)mediaItem).getFileSize(), !((MediaItem)mediaItem).isLive()), buffer);
        }
        catch (MalformedURLException e) {
            throw new FileNotFoundException(String.format("Cannot retrieve online media item URL: %s", e.getMessage()));
        }
    }

    protected RI findMediaInfoForFileProfile(Collection<RI> infos, MediaFormatProfile selectedVersion) throws UnsupportedDLNAMediaFileFormatException {
        for (MediaFormatProfileResource mi : infos) {
            if (mi.getFormatProfile() != selectedVersion) continue;
            return (RI)mi;
        }
        throw new UnsupportedDLNAMediaFileFormatException(String.format("No media description available for required version: %s", new Object[]{selectedVersion}));
    }

    protected void updateFeedUrl(MI mediaItem) {
        if (!((MediaItem)mediaItem).isLocalMedia() && ((MediaItem)mediaItem).getOnlineResourcePlugin() != null && ((MediaItem)mediaItem).getOnlineItem() != null) {
            this.log.debug("Extracting new URL for the expired feed item");
            try {
                ContentURLContainer urlContainer = AbstractUrlExtractor.extractItemUrl(((MediaItem)mediaItem).getOnlineResourcePlugin(), ((MediaItem)mediaItem).getOnlineItem());
                if (urlContainer != null) {
                    ((MediaItem)mediaItem).setFileName(urlContainer.getContentUrl());
                    this.log.debug("Successfully set new URL for the feed item");
                } else {
                    this.log.warn("Cannot extract expired URL, using previous one which might not work");
                }
            }
            catch (Throwable t) {
                this.log.debug(String.format("Unexpected error during url extractor plugin invocation (%s) for item %s: %s", ((MediaItem)mediaItem).getOnlineResourcePlugin().getExtractorName(), ((MediaItem)mediaItem).getOnlineItem().getTitle(), t.getMessage()), t);
            }
        }
    }

    private URL getOnlineItemURL(MI mediaItem) throws MalformedURLException {
        this.updateFeedUrl(mediaItem);
        return new URL(((MediaItem)mediaItem).getFileName());
    }

    private List<RI> flattenMediaInfoMap(Map<DeliveryQuality.QualityType, List<RI>> map) {
        ArrayList result = new ArrayList();
        for (Map.Entry<DeliveryQuality.QualityType, List<RI>> entry : map.entrySet()) {
            result.addAll(entry.getValue());
        }
        return result;
    }

    protected static boolean hardSubsTranscodingConfigured(MediaItem mediaItem, Profile rendererProfile) {
        return mediaItem.getFileType() == MediaFileType.VIDEO && Configuration.isSubtitlesEnabled() && Configuration.isHardSubsEnabled() && rendererProfile.getSubtitlesConfiguration().isHardSubsSupported() && rendererProfile.hasAnyHardSubsTranscodingDefinitions();
    }
}

