/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.delivery;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.serviio.ApplicationSettings;
import org.serviio.delivery.Client;
import org.serviio.delivery.ClosableStreamDelegator;
import org.serviio.delivery.DeliveryListener;
import org.serviio.external.ProcessListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeoutStreamDelegator {
    private static final Logger log = LoggerFactory.getLogger(TimeoutStreamDelegator.class);
    private static final int CLOSE_STREAM_AFTER_READ_INACTIVITY_SEC = ApplicationSettings.getIntegerProperty("transcoded_stream_after_read_inactivity_timeout");
    private static final int CLOSE_STREAM_AFTER_CLOSE_INACTIVITY_SEC = ApplicationSettings.getIntegerProperty("transcoded_stream_after_close_inactivity_timeout");
    private InputStream stream;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private ScheduledFuture<?> scheduledFuture;
    private final ProcessListener processListener;
    private AtomicReference<Date> lastBytesRead = new AtomicReference<Date>(new Date());
    private Client client;
    private DeliveryListener deliveryListener;
    private boolean forceClosing = false;
    private boolean closed = false;

    public TimeoutStreamDelegator(InputStream stream, ProcessListener processListener, Client client, DeliveryListener deliveryListener, boolean forceClosing) {
        this.stream = stream;
        this.processListener = processListener;
        this.client = client;
        this.deliveryListener = deliveryListener;
        this.forceClosing = forceClosing;
    }

    public synchronized void onRead() throws IOException {
        this.lastBytesRead.set(new Date());
        this.resetReadTimeoutScheduler(CLOSE_STREAM_AFTER_READ_INACTIVITY_SEC);
    }

    public synchronized void close() throws IOException {
        if (!this.closed) {
            if (this.forceClosing && !this.processListener.isFinished()) {
                this.reallyClose();
            } else if (!this.processListener.isFinished()) {
                log.debug(String.format("Scheduling stream stop to happen in %s seconds if there is no traffic", CLOSE_STREAM_AFTER_CLOSE_INACTIVITY_SEC));
                this.resetReadTimeoutScheduler(CLOSE_STREAM_AFTER_CLOSE_INACTIVITY_SEC);
            } else {
                ((ClosableStreamDelegator)((Object)this.stream)).closeParent();
                this.closed = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void reallyClose() {
        log.debug("Closing piped input stream and closing related feeder process");
        try {
            ((ClosableStreamDelegator)((Object)this.stream)).closeParent();
        }
        catch (IOException e) {
            log.debug("Error while closing piped stream", (Throwable)e);
        }
        finally {
            if (this.processListener != null) {
                this.processListener.releaseResources();
            }
            if (this.deliveryListener != null) {
                this.deliveryListener.deliveryComplete(this.client);
            }
            this.scheduler.shutdownNow();
            this.closed = true;
        }
    }

    protected Date getLastBytesRead() {
        return this.lastBytesRead.get();
    }

    private synchronized void resetReadTimeoutScheduler(int timeout) {
        try {
            if (this.scheduledFuture != null && !this.scheduledFuture.isCancelled()) {
                this.scheduledFuture.cancel(true);
            }
            if (!this.scheduler.isShutdown()) {
                this.scheduledFuture = this.scheduler.schedule(new NonClosingPipedInputStreamCompanion(), (long)timeout, TimeUnit.SECONDS);
            }
        }
        catch (Throwable e) {
            log.warn("Failed to restart stream closing monitor. Possible process leaks might occur.", e);
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    private class NonClosingPipedInputStreamCompanion
    implements Runnable {
        private Date streamClosed = new Date();

        private NonClosingPipedInputStreamCompanion() {
        }

        @Override
        public void run() {
            if (!TimeoutStreamDelegator.this.getLastBytesRead().after(this.streamClosed)) {
                TimeoutStreamDelegator.this.reallyClose();
            }
        }
    }
}

