/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.delivery;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.serviio.delivery.Client;
import org.serviio.delivery.DeliveryContainer;
import org.serviio.delivery.ResourceInfo;
import org.serviio.delivery.ResourceRetrievalStrategy;
import org.serviio.delivery.StreamDeliveryContainer;
import org.serviio.delivery.subtitles.SubtitlesInfo;
import org.serviio.delivery.subtitles.SubtitlesReader;
import org.serviio.delivery.subtitles.SubtitlesService;
import org.serviio.dlna.MediaFormatProfile;
import org.serviio.dlna.SubtitleCodec;
import org.serviio.dlna.UnsupportedDLNAMediaFileFormatException;
import org.serviio.profile.DeliveryQuality;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubtitlesRetrievalStrategy
implements ResourceRetrievalStrategy {
    private static final Logger log = LoggerFactory.getLogger(SubtitlesRetrievalStrategy.class);

    @Override
    public DeliveryContainer retrieveResource(Long mediaItemId, MediaFormatProfile selectedVersion, DeliveryQuality.QualityType selectedQuality, String path, Double timeOffsetInSeconds, Double durationInSeconds, Client client, boolean markAsRead) throws FileNotFoundException, IOException {
        SubtitlesReader subtitleReader = this.findSoftSubs(mediaItemId, client);
        log.debug(String.format("Retrieving Subtitles for media item with id %s", mediaItemId));
        ResourceInfo resourceInfo = this.retrieveResourceInfo(mediaItemId, subtitleReader, client);
        byte[] subtitlesBytes = subtitleReader.getSubtitlesAsSRT();
        resourceInfo.setFileSize(new Long(subtitlesBytes.length));
        return new StreamDeliveryContainer(new ByteArrayInputStream(subtitlesBytes), resourceInfo);
    }

    @Override
    public ResourceInfo retrieveResourceInfo(Long mediaItemId, MediaFormatProfile selectedVersion, DeliveryQuality.QualityType selectedQuality, String path, Client client) throws FileNotFoundException, UnsupportedDLNAMediaFileFormatException {
        SubtitlesReader subtitleReader = this.findSoftSubs(mediaItemId, client);
        log.debug(String.format("Retrieving info of Subtitles for media item with id %s", mediaItemId));
        return this.retrieveResourceInfo(mediaItemId, subtitleReader, client);
    }

    private ResourceInfo retrieveResourceInfo(Long mediaItemId, SubtitlesReader subtitleReader, Client client) throws FileNotFoundException {
        SubtitleCodec codec = subtitleReader.getSubtitleCodec();
        if (codec == null) {
            throw new FileNotFoundException("Unknown subtitles format");
        }
        boolean transcoded = subtitleReader.getSubtitleCodec() != SubtitleCodec.SRT || subtitleReader.getExpectedSubtitlesSize() == null;
        return new SubtitlesInfo(mediaItemId, subtitleReader.getExpectedSubtitlesSize(), transcoded, client.getRendererProfile().getSubtitlesConfiguration().getSoftSubsMimeType());
    }

    private SubtitlesReader findSoftSubs(Long mediaItemId, Client client) throws FileNotFoundException {
        SubtitlesReader subtitleReader = SubtitlesService.getSoftSubs(mediaItemId, client.getRendererProfile());
        if (subtitleReader == null) {
            throw new FileNotFoundException(String.format("Subtitle file for media item %s cannot be found", mediaItemId));
        }
        return subtitleReader;
    }
}

