/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.delivery;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.serviio.delivery.Client;
import org.serviio.delivery.DeliveryContainer;
import org.serviio.delivery.ResourceInfo;
import org.serviio.delivery.ResourceRetrievalStrategy;
import org.serviio.delivery.SegmentInfo;
import org.serviio.delivery.StreamDeliveryContainer;
import org.serviio.delivery.resource.transcode.AbstractTranscodingDeliveryEngine;
import org.serviio.dlna.MediaFormatProfile;
import org.serviio.dlna.UnsupportedDLNAMediaFileFormatException;
import org.serviio.profile.DeliveryQuality;
import org.serviio.upnp.service.contentdirectory.classes.Resource;
import org.serviio.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentRetrievalStrategy
implements ResourceRetrievalStrategy {
    private static final Logger log = LoggerFactory.getLogger(SegmentRetrievalStrategy.class);
    private static final String segmentMimeType = "video/MP2T";

    @Override
    public DeliveryContainer retrieveResource(Long mediaItemId, MediaFormatProfile selectedVersion, DeliveryQuality.QualityType selectedQuality, String path, Double timeOffsetInSeconds, Double durationInSeconds, Client client, boolean markAsRead) throws FileNotFoundException, IOException {
        log.debug(String.format("Retrieving Segment for media item with id %s: %s", mediaItemId, path));
        File segmentFile = this.findSegmentFile(path);
        FileInputStream segmentStream = new FileInputStream(segmentFile);
        ResourceInfo resourceInfo = this.retrieveResourceInfo(mediaItemId, segmentFile);
        return new StreamDeliveryContainer(new BufferedInputStream(segmentStream, 65536), resourceInfo);
    }

    @Override
    public ResourceInfo retrieveResourceInfo(Long mediaItemId, MediaFormatProfile selectedVersion, DeliveryQuality.QualityType selectedQuality, String path, Client client) throws FileNotFoundException, UnsupportedDLNAMediaFileFormatException {
        log.debug(String.format("Retrieving info of Segment for media item with id %s: %s", mediaItemId, path));
        File segmentFile = this.findSegmentFile(path);
        return this.retrieveResourceInfo(mediaItemId, segmentFile);
    }

    private ResourceInfo retrieveResourceInfo(Long mediaItemId, File segmentFile) throws FileNotFoundException {
        return new SegmentInfo(mediaItemId, segmentFile.length(), segmentMimeType);
    }

    private File findSegmentFile(String path) throws FileNotFoundException {
        File segmentFile = new File(AbstractTranscodingDeliveryEngine.getTranscodingFolder(), this.getFilePathFromUrl(path));
        if (segmentFile.exists() && segmentFile.isFile() && segmentFile.canRead()) {
            return segmentFile;
        }
        throw new FileNotFoundException(String.format("Could not find segment file: %s", FileUtils.getProperFilePath(segmentFile)));
    }

    protected String getFilePathFromUrl(String path) {
        int filePathEnd = path.indexOf(63);
        return path.substring(path.indexOf(Resource.ResourceType.SEGMENT.toString()) + Resource.ResourceType.SEGMENT.toString().length() + 1, filePathEnd > -1 ? filePathEnd : path.length());
    }
}

