/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.delivery;

import org.serviio.delivery.CoverImageRetrievalStrategy;
import org.serviio.delivery.ManifestRetrievalStrategy;
import org.serviio.delivery.MediaResourceRetrievalStrategy;
import org.serviio.delivery.ResourceRetrievalStrategy;
import org.serviio.delivery.SegmentRetrievalStrategy;
import org.serviio.delivery.SubtitlesRetrievalStrategy;
import org.serviio.upnp.service.contentdirectory.classes.Resource;

public class ResourceRetrievalStrategyFactory {
    public ResourceRetrievalStrategy instantiateResourceRetrievalStrategy(Resource.ResourceType resourceType) {
        if (resourceType == Resource.ResourceType.MEDIA_ITEM) {
            return new MediaResourceRetrievalStrategy();
        }
        if (resourceType == Resource.ResourceType.COVER_IMAGE) {
            return new CoverImageRetrievalStrategy();
        }
        if (resourceType == Resource.ResourceType.SUBTITLE) {
            return new SubtitlesRetrievalStrategy();
        }
        if (resourceType == Resource.ResourceType.MANIFEST) {
            return new ManifestRetrievalStrategy();
        }
        if (resourceType == Resource.ResourceType.SEGMENT) {
            return new SegmentRetrievalStrategy();
        }
        throw new RuntimeException("Unsupported resource type: " + (Object)((Object)resourceType));
    }
}

