/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.delivery;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import org.apache.http.ProtocolVersion;
import org.serviio.delivery.AbstractMethodProcessor;
import org.serviio.delivery.Client;
import org.serviio.delivery.GETMethodProcessor;
import org.serviio.delivery.HEADMethodProcessor;
import org.serviio.delivery.HttpDeliveryContainer;
import org.serviio.delivery.HttpResponseCodeException;
import org.serviio.delivery.RangeHeaders;
import org.serviio.delivery.ResourceInfo;
import org.serviio.delivery.ResourceRetrievalStrategy;
import org.serviio.delivery.ResourceRetrievalStrategyFactory;
import org.serviio.dlna.MediaFormatProfile;
import org.serviio.dlna.UnsupportedDLNAMediaFileFormatException;
import org.serviio.upnp.protocol.http.transport.InvalidResourceRequestException;
import org.serviio.upnp.protocol.http.transport.RequestedResourceDescriptor;
import org.serviio.upnp.protocol.http.transport.ResourceTransportProtocolHandler;
import org.serviio.util.ObjectValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceDeliveryProcessor {
    private static final Logger log = LoggerFactory.getLogger(ResourceDeliveryProcessor.class);
    private ResourceRetrievalStrategyFactory resourceRetrievalStrategyFactory;
    private HEADMethodProcessor headMethodProcessor = new HEADMethodProcessor();
    private GETMethodProcessor getMethodProcessor = new GETMethodProcessor();

    public ResourceDeliveryProcessor(ResourceRetrievalStrategyFactory resourceRetrievalStrategyFactory) {
        this.resourceRetrievalStrategyFactory = resourceRetrievalStrategyFactory;
    }

    public HttpDeliveryContainer deliverContent(String requestUri, HttpMethod method, ProtocolVersion httpVersion, Map<String, String> requestHeaders, RangeHeaders rangeHeaders, ResourceTransportProtocolHandler protocolHandler, Client client) throws HttpResponseCodeException, IOException {
        log.debug(String.format("Resource request accepted. Using client '%s'", client));
        try {
            RequestedResourceDescriptor resourceReq = protocolHandler.getRequestedResourceDescription(requestUri, client);
            log.debug(String.format("Request for resource %s and type '%s' received", resourceReq.getResourceId() != null ? resourceReq.getResourceId() : resourceReq.getPath(), resourceReq.getResourceType().toString()));
            ResourceRetrievalStrategy resourceRetrievalStrategy = this.resourceRetrievalStrategyFactory.instantiateResourceRetrievalStrategy(resourceReq.getResourceType());
            AbstractMethodProcessor processor = null;
            if (method == HttpMethod.GET) {
                processor = this.getMethodProcessor;
            } else if (method == HttpMethod.HEAD) {
                processor = this.headMethodProcessor;
            } else {
                throw new HttpResponseCodeException(405);
            }
            MediaFormatProfile selectedVersion = this.getSelectedVersion(resourceReq.getTargetProfileName());
            ResourceInfo resourceInfo = resourceRetrievalStrategy.retrieveResourceInfo(resourceReq.getResourceId(), selectedVersion, resourceReq.getQuality(), resourceReq.getPath(), client);
            return processor.handleRequest(resourceRetrievalStrategy, resourceInfo, selectedVersion, resourceReq.getQuality(), resourceReq.getPath(), requestHeaders, rangeHeaders, httpVersion, resourceReq.getProtocolInfoIndex(), client, protocolHandler);
        }
        catch (FileNotFoundException e) {
            log.warn(String.format("Error while processing resource, sending back 404 error. Message: %s", e.getMessage()));
            throw new HttpResponseCodeException(404);
        }
        catch (InvalidResourceRequestException e) {
            log.warn("Invalid request, sending back 400 error", (Throwable)e);
            throw new HttpResponseCodeException(400);
        }
        catch (UnsupportedDLNAMediaFileFormatException e) {
            log.warn("Invalid request, sending back 500 error", (Throwable)e);
            throw new HttpResponseCodeException(500);
        }
    }

    private MediaFormatProfile getSelectedVersion(String profileName) {
        if (ObjectValidator.isNotEmpty(profileName)) {
            try {
                return MediaFormatProfile.valueOf(profileName);
            }
            catch (IllegalArgumentException e) {
                log.warn(String.format("Requested DLNA media format profile %s is not supported, using original profile of the media", profileName));
                return null;
            }
        }
        return null;
    }

    public static enum HttpMethod {
        GET,
        HEAD;

    }
}

