/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.delivery;

import java.util.HashMap;
import java.util.Map;
import org.serviio.util.ObjectValidator;

public class RangeHeaders {
    public static final long UNSPECIFIED = -1L;
    private Map<RangeUnit, RangeTupple> headers;

    private RangeHeaders(Map<RangeUnit, RangeTupple> headers) {
        this.headers = headers;
    }

    public static RangeHeaders parseHttpRange(RangeDefinition definition, String bytesRangeHeaderValue, String timeRangeHeaderValue) {
        if (ObjectValidator.isNotEmpty(bytesRangeHeaderValue) || ObjectValidator.isNotEmpty(timeRangeHeaderValue)) {
            HashMap<RangeUnit, RangeTupple> headers = new HashMap<RangeUnit, RangeTupple>();
            if (ObjectValidator.isNotEmpty(bytesRangeHeaderValue)) {
                headers.put(RangeUnit.BYTES, RangeHeaders.parseHttpBytesRange(bytesRangeHeaderValue));
            }
            if (ObjectValidator.isNotEmpty(timeRangeHeaderValue)) {
                if (definition == RangeDefinition.DLNA) {
                    headers.put(RangeUnit.SECONDS, RangeHeaders.parseHttpDLNATimeRange(timeRangeHeaderValue));
                } else if (definition == RangeDefinition.CDS) {
                    headers.put(RangeUnit.SECONDS, RangeHeaders.parseHttpCDSTimeRange(timeRangeHeaderValue));
                }
            }
            return new RangeHeaders(headers);
        }
        return null;
    }

    public static RangeHeaders create(RangeUnit unit, long from, long to, long total) {
        HashMap<RangeUnit, RangeTupple> headers = new HashMap<RangeUnit, RangeTupple>();
        headers.put(unit, new RangeTupple(from, to, total));
        return new RangeHeaders(headers);
    }

    public static RangeHeaders create(RangeUnit unit, double from, double to, long total) {
        HashMap<RangeUnit, RangeTupple> headers = new HashMap<RangeUnit, RangeTupple>();
        headers.put(unit, new RangeTupple(from, to, total));
        return new RangeHeaders(headers);
    }

    public void add(RangeUnit unit, long from, long to, long total) {
        this.headers.put(unit, new RangeTupple(from, to, total));
    }

    private static RangeTupple parseHttpBytesRange(String headerValue) {
        String rangeDefinition = headerValue.substring(headerValue.indexOf("=") + 1);
        Long startByte = Long.valueOf(rangeDefinition.substring(0, rangeDefinition.indexOf("-")));
        String endByteString = rangeDefinition.substring(rangeDefinition.indexOf("-") + 1);
        Long endByte = !endByteString.equals("") ? Long.valueOf(endByteString) : null;
        return new RangeTupple(startByte.doubleValue(), endByte != null ? Double.valueOf(endByte.doubleValue()) : null);
    }

    private static RangeTupple parseHttpDLNATimeRange(String headerValue) throws NumberFormatException {
        String nptDefinition = headerValue.substring(headerValue.indexOf("=") + 1);
        String startTime = nptDefinition.substring(0, nptDefinition.indexOf("-"));
        String endTime = nptDefinition.substring(nptDefinition.indexOf("-") + 1);
        Double startSecond = null;
        Double endSecond = null;
        startSecond = RangeHeaders.convertNPTToSeconds(startTime);
        endSecond = !endTime.equals("") ? RangeHeaders.convertNPTToSeconds(endTime) : null;
        return new RangeTupple(startSecond, endSecond);
    }

    private static RangeTupple parseHttpCDSTimeRange(String headerValue) throws NumberFormatException {
        String startTime = headerValue;
        Double startSecond = Double.valueOf(startTime);
        return new RangeTupple(startSecond, null);
    }

    protected static Double convertNPTToSeconds(String npt) throws NumberFormatException {
        if (npt.indexOf(":") > -1) {
            String[] timeFields = npt.split(":");
            if (timeFields.length != 3) {
                throw new NumberFormatException();
            }
            Double seconds = Double.valueOf(timeFields[0]) * 3600.0 + Double.valueOf(timeFields[1]) * 60.0 + Double.valueOf(timeFields[2]);
            return seconds;
        }
        return Double.valueOf(npt);
    }

    public Double getStart(RangeUnit unit) {
        return this.headers.containsKey((Object)unit) ? this.headers.get((Object)unit).getStart() : null;
    }

    public Long getStartAsLong(RangeUnit unit) {
        Double value = this.getStart(unit);
        return value != null ? Long.valueOf(value.longValue()) : null;
    }

    public String getStartAsString(RangeUnit unit) {
        Double value = this.getStart(unit);
        return this.formatDoubleToString(value);
    }

    public String getEndAsString(RangeUnit unit) {
        Double value = this.getEnd(unit);
        return this.formatDoubleToString(value);
    }

    public Double getEnd(RangeUnit unit) {
        return this.headers.containsKey((Object)unit) ? (this.headers.get((Object)unit).getEnd() != null ? this.headers.get((Object)unit).getEnd() : null) : null;
    }

    public Long getEndAsLong(RangeUnit unit) {
        Double value = this.getEnd(unit);
        return value != null ? Long.valueOf(value.longValue()) : null;
    }

    public Long getTotal(RangeUnit unit) {
        return this.headers.containsKey((Object)unit) ? Long.valueOf(this.headers.get((Object)unit).getTotal().longValue()) : null;
    }

    public boolean hasHeaders(RangeUnit unit) {
        return this.headers.containsKey((Object)unit);
    }

    private String formatDoubleToString(Double value) {
        if (value != null) {
            if (value == (double)((long)value.doubleValue())) {
                return Long.toString(value.longValue());
            }
            return value.toString();
        }
        return null;
    }

    public static class RangeTupple {
        private Double start;
        private Double end;
        private Double total;

        public RangeTupple(Double start, Double end) {
            this.start = start;
            this.end = end;
        }

        public RangeTupple(long start, long end, long total) {
            this(new Double(Long.toString(start)), new Double(Long.toString(end)));
            this.total = new Double(Long.toString(total));
        }

        public RangeTupple(double start, double end, long total) {
            this(start, end);
            this.total = new Double(Long.toString(total));
        }

        public Double getStart() {
            return this.start;
        }

        public Double getEnd() {
            return this.end;
        }

        public Double getTotal() {
            return this.total;
        }
    }

    public static enum RangeDefinition {
        DLNA,
        CDS;

    }

    public static enum RangeUnit {
        BYTES,
        SECONDS;

    }
}

