/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.delivery;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.restlet.Client;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Method;
import org.restlet.data.Protocol;
import org.restlet.data.Range;
import org.restlet.data.Status;
import org.restlet.representation.EmptyRepresentation;
import org.serviio.delivery.RangeNotSupportedException;
import org.serviio.util.FileUtils;
import org.serviio.util.HttpClient;
import org.serviio.util.HttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlineInputStream
extends InputStream {
    private static final int DEFAULT_CHUNK_SIZE = 1512000;
    private static final Logger log = LoggerFactory.getLogger(OnlineInputStream.class);
    private URL contentURL;
    private String[] credentials;
    private Long contentSize;
    private long pos;
    private int bufferPos;
    private volatile byte[] onlineBuffer;
    boolean allConsumed = false;
    boolean supportsRange = true;
    private InputStream wholeStream;
    private Client restletClient = new Client(Protocol.HTTP);
    private int chunkSize = 1512000;

    public OnlineInputStream(URL contentUrl, Long contentSize, boolean supportsByterange) {
        this.contentURL = contentUrl;
        this.contentSize = contentSize;
        this.credentials = HttpUtils.getCredentialsFormUrl(contentUrl.toString());
        this.supportsRange = supportsByterange;
    }

    public OnlineInputStream(URL contentUrl, Long contentSize, boolean supportsByterange, int chunkSize) {
        this(contentUrl, contentSize, supportsByterange);
        this.chunkSize = chunkSize;
    }

    @Override
    public int read() throws IOException {
        if (this.supportsRange || !this.supportsRange && this.wholeStream == null) {
            try {
                if (!(this.allConsumed || this.onlineBuffer != null && this.bufferPos < this.chunkSize)) {
                    this.fill();
                }
                if (this.onlineBuffer != null && this.bufferPos < this.onlineBuffer.length) {
                    ++this.pos;
                    return this.onlineBuffer[this.bufferPos++] & 0xFF;
                }
                this.cleanup();
                return -1;
            }
            catch (RangeNotSupportedException e) {
                this.supportsRange = false;
                return this.wholeStream.read();
            }
        }
        return this.wholeStream.read();
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.supportsRange) {
            this.pos += n;
            try {
                this.fill();
            }
            catch (RangeNotSupportedException e) {
                this.supportsRange = false;
                return super.skip(n);
            }
            return n;
        }
        return this.wholeStream != null ? this.wholeStream.skip(n) : 0L;
    }

    @Override
    public int available() throws IOException {
        if (this.supportsRange) {
            if (this.onlineBuffer != null) {
                return this.onlineBuffer.length - this.bufferPos;
            }
            return 0;
        }
        return this.wholeStream != null ? this.wholeStream.available() : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        log.debug("Closing stream");
        try {
            if (this.wholeStream != null) {
                this.wholeStream.close();
            }
        }
        finally {
            this.cleanup();
        }
    }

    private void cleanup() {
        try {
            this.restletClient.stop();
            this.onlineBuffer = null;
        }
        catch (Exception e) {
            log.warn("Exception during HTTP client closing: " + e.getMessage());
        }
    }

    private void fill() throws IOException, RangeNotSupportedException {
        this.onlineBuffer = this.readFileChunk(this.pos, this.chunkSize);
        this.bufferPos = 0;
        if (this.onlineBuffer.length < this.chunkSize) {
            this.allConsumed = true;
        }
    }

    private byte[] readFileChunk(long startByte, long byteCount) throws IOException, RangeNotSupportedException {
        Response response;
        log.debug(String.format("Reading %s bytes starting at %s", byteCount, startByte));
        Request request = new Request(Method.GET, this.contentURL.toString());
        if (this.credentials != null) {
            ChallengeScheme scheme = ChallengeScheme.HTTP_BASIC;
            ChallengeResponse authentication = new ChallengeResponse(scheme, this.credentials[0], this.credentials[1]);
            request.setChallengeResponse(authentication);
        }
        if (this.supportsRange) {
            Range byteRange = new Range(startByte, byteCount);
            if (this.contentSize != null && startByte + byteCount > this.contentSize) {
                byteRange = new Range(startByte, this.contentSize - startByte);
            }
            List<Range> ranges = Collections.singletonList(byteRange);
            request.setRanges(ranges);
        }
        if (Status.SUCCESS_OK.equals((Object)(response = this.restletClient.handle(request)).getStatus()) || new Status(-1).equals((Object)response.getStatus())) {
            log.debug(String.format("Byte range not supported for %s, returning the whole stream", this.contentURL.toString()));
            this.wholeStream = this.getResponseStream(response);
            throw new RangeNotSupportedException();
        }
        if (Status.SUCCESS_PARTIAL_CONTENT.equals((Object)response.getStatus())) {
            InputStream content = this.getResponseStream(response);
            byte[] bytes = FileUtils.readFileBytes(content);
            log.debug(String.format("Returning %s bytes from partial content response", bytes.length));
            return bytes;
        }
        if (response.getStatus().isRedirection()) {
            this.contentURL = response.getLocationRef().toUrl();
            log.debug(String.format("302 returned, redirecting to %s", this.contentURL));
            return this.readFileChunk(startByte, byteCount);
        }
        if (response.getStatus().equals((Object)Status.CLIENT_ERROR_REQUESTED_RANGE_NOT_SATISFIABLE)) {
            this.wholeStream = this.getResponseStream(response);
            log.debug(String.format("Byte range not satisfiable for %s, returning the whole stream", this.contentURL.toString()));
            throw new RangeNotSupportedException();
        }
        throw new IOException(String.format("Status '%s' received from '%s', cancelling transfer", response.getStatus(), this.contentURL.toString()));
    }

    private InputStream getResponseStream(Response response) throws IOException {
        block4: {
            if (response.getEntity() != null && !(response.getEntity() instanceof EmptyRepresentation)) {
                return response.getEntity().getStream();
            }
            if (HttpUtils.isHttpUrl(this.contentURL.toString())) {
                log.debug("Trying basic stream handler");
                try {
                    return HttpClient.getStreamFromURL(this.contentURL.toString());
                }
                catch (IOException e) {
                    log.debug("Trying ShoutCast stream handler");
                    InputStream stream = HttpClient.getShoutCastStream(this.contentURL.toString());
                    if (stream == null) break block4;
                    return stream;
                }
            }
        }
        throw new IOException(String.format("Cannot open stream from '%s', possibly incorrect URL or invalid HTTP response", this.contentURL.toString()));
    }
}

