/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.delivery;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import org.serviio.delivery.Client;
import org.serviio.delivery.DeliveryContainer;
import org.serviio.delivery.ResourceInfo;
import org.serviio.delivery.ResourceRetrievalStrategy;
import org.serviio.delivery.resource.AudioDeliveryEngine;
import org.serviio.delivery.resource.ImageDeliveryEngine;
import org.serviio.delivery.resource.VideoDeliveryEngine;
import org.serviio.dlna.MediaFormatProfile;
import org.serviio.dlna.UnsupportedDLNAMediaFileFormatException;
import org.serviio.library.entities.Image;
import org.serviio.library.entities.MediaItem;
import org.serviio.library.entities.MusicTrack;
import org.serviio.library.entities.Video;
import org.serviio.library.local.service.AudioService;
import org.serviio.library.local.service.ImageService;
import org.serviio.library.local.service.MediaService;
import org.serviio.library.local.service.VideoService;
import org.serviio.library.metadata.MediaFileType;
import org.serviio.library.online.OnlineItemService;
import org.serviio.library.online.metadata.OnlineItem;
import org.serviio.profile.DeliveryQuality;
import org.serviio.profile.Profile;
import org.serviio.upnp.service.contentdirectory.ContentDirectoryEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaResourceRetrievalStrategy
implements ResourceRetrievalStrategy {
    private static final Logger log = LoggerFactory.getLogger(MediaResourceRetrievalStrategy.class);

    public static List<? extends ResourceInfo> getMediaInfoForAvailableProfiles(MediaItem mediaItem, Profile rendererProfile) {
        boolean isLocalMedia = mediaItem.isLocalMedia();
        if (mediaItem.getFileType() == MediaFileType.IMAGE) {
            Image image = isLocalMedia ? ImageService.getImage(mediaItem.getId()) : (Image)mediaItem;
            return ImageDeliveryEngine.getInstance().getMediaInfoForProfile(image, rendererProfile);
        }
        if (mediaItem.getFileType() == MediaFileType.AUDIO) {
            MusicTrack track = isLocalMedia ? AudioService.getSong(mediaItem.getId()) : (MusicTrack)mediaItem;
            return AudioDeliveryEngine.getInstance().getMediaInfoForProfile(track, rendererProfile);
        }
        Video video = isLocalMedia ? VideoService.getVideo(mediaItem.getId()) : (Video)mediaItem;
        return VideoDeliveryEngine.getInstance().getMediaInfoForProfile(video, rendererProfile);
    }

    public static MediaItem loadMediaItem(Long mediaItemId) throws FileNotFoundException {
        MediaItem mediaItem = null;
        boolean localMedia = MediaItem.isLocalMedia(mediaItemId);
        log.debug(String.format("Getting information about media item %s (%s)", mediaItemId, localMedia ? "local" : "online"));
        if (localMedia) {
            mediaItem = MediaService.readMediaItemById(mediaItemId);
            mediaItem = mediaItem.getFileType() == MediaFileType.IMAGE ? ImageService.getImage(mediaItem.getId()) : (mediaItem.getFileType() == MediaFileType.AUDIO ? AudioService.getSong(mediaItem.getId()) : VideoService.getVideo(mediaItem.getId()));
        } else {
            OnlineItem onlineItem = OnlineItemService.findOnlineItemById(mediaItemId);
            if (onlineItem != null) {
                mediaItem = onlineItem.toMediaItem();
            }
        }
        if (mediaItem == null) {
            throw new FileNotFoundException(String.format("Media item %s cannot be found", mediaItemId));
        }
        return mediaItem;
    }

    @Override
    public DeliveryContainer retrieveResource(Long mediaItemId, MediaFormatProfile selectedVersion, DeliveryQuality.QualityType selectedQuality, String path, Double timeOffsetInSeconds, Double durationInSeconds, Client client, boolean markAsRead) throws FileNotFoundException, IOException, UnsupportedDLNAMediaFileFormatException {
        if (selectedVersion == null) {
            throw new FileNotFoundException("The request did not provide required version of the resource");
        }
        MediaItem mediaItem = MediaResourceRetrievalStrategy.loadMediaItem(mediaItemId);
        boolean isLocalMedia = mediaItem.isLocalMedia();
        DeliveryContainer deliveryContainer = null;
        deliveryContainer = mediaItem.getFileType() == MediaFileType.IMAGE ? ImageDeliveryEngine.getInstance().deliver((Image)mediaItem, selectedVersion, selectedQuality, null, null, client) : (mediaItem.getFileType() == MediaFileType.AUDIO ? AudioDeliveryEngine.getInstance().deliver((MusicTrack)mediaItem, selectedVersion, selectedQuality, timeOffsetInSeconds, durationInSeconds, client) : VideoDeliveryEngine.getInstance().deliver((Video)mediaItem, selectedVersion, selectedQuality, timeOffsetInSeconds, durationInSeconds, client));
        if (isLocalMedia && markAsRead && mediaItem.getFileType() != MediaFileType.IMAGE) {
            MediaService.markMediaItemAsRead(mediaItemId);
            ContentDirectoryEngine cds = ContentDirectoryEngine.getInstance();
            cds.evictItemsAfterPlay();
        }
        return deliveryContainer;
    }

    @Override
    public ResourceInfo retrieveResourceInfo(Long mediaItemId, MediaFormatProfile selectedVersion, DeliveryQuality.QualityType selectedQuality, String path, Client client) throws FileNotFoundException, UnsupportedDLNAMediaFileFormatException, IOException {
        if (selectedVersion == null) {
            throw new FileNotFoundException("The request did not provide required version of the resource");
        }
        MediaItem mediaItem = MediaResourceRetrievalStrategy.loadMediaItem(mediaItemId);
        Profile rendererProfile = client.getRendererProfile();
        if (mediaItem.getFileType() == MediaFileType.IMAGE) {
            return ImageDeliveryEngine.getInstance().getMediaInfoForMediaItem((Image)mediaItem, selectedVersion, selectedQuality, rendererProfile);
        }
        if (mediaItem.getFileType() == MediaFileType.AUDIO) {
            return AudioDeliveryEngine.getInstance().getMediaInfoForMediaItem((MusicTrack)mediaItem, selectedVersion, selectedQuality, rendererProfile);
        }
        return VideoDeliveryEngine.getInstance().getMediaInfoForMediaItem((Video)mediaItem, selectedVersion, selectedQuality, rendererProfile);
    }
}

