/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.delivery;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import org.serviio.delivery.Client;
import org.serviio.delivery.DeliveryContainer;
import org.serviio.delivery.ManifestInfo;
import org.serviio.delivery.MediaResourceRetrievalStrategy;
import org.serviio.delivery.ResourceInfo;
import org.serviio.delivery.ResourceRetrievalStrategy;
import org.serviio.delivery.StreamDeliveryContainer;
import org.serviio.dlna.MediaFormatProfile;
import org.serviio.dlna.UnsupportedDLNAMediaFileFormatException;
import org.serviio.library.entities.MediaItem;
import org.serviio.library.entities.Video;
import org.serviio.library.metadata.MediaFileType;
import org.serviio.profile.DeliveryQuality;
import org.serviio.upnp.service.contentdirectory.classes.InvalidResourceException;
import org.serviio.upnp.service.contentdirectory.classes.Resource;
import org.serviio.upnp.service.contentdirectory.command.ResourceValuesBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManifestRetrievalStrategy
implements ResourceRetrievalStrategy {
    private static final Logger log = LoggerFactory.getLogger(ManifestRetrievalStrategy.class);

    @Override
    public DeliveryContainer retrieveResource(Long mediaItemId, MediaFormatProfile selectedVersion, DeliveryQuality.QualityType selectedQuality, String path, Double timeOffsetInSeconds, Double durationInSeconds, Client client, boolean markAsRead) throws FileNotFoundException, IOException {
        log.debug(String.format("Retrieving Manifest for media item with id %s", mediaItemId));
        String manifest = this.generateManifest(mediaItemId, client, selectedQuality);
        ResourceInfo resourceInfo = this.retrieveResourceInfo(mediaItemId, selectedVersion, client, manifest.length());
        return new StreamDeliveryContainer(new ByteArrayInputStream(manifest.getBytes("UTF-8")), resourceInfo);
    }

    @Override
    public ResourceInfo retrieveResourceInfo(Long mediaItemId, MediaFormatProfile selectedVersion, DeliveryQuality.QualityType selectedQuality, String path, Client client) throws FileNotFoundException, UnsupportedDLNAMediaFileFormatException {
        log.debug(String.format("Retrieving info of Manifest for media item with id %s", mediaItemId));
        String manifest = this.generateManifest(mediaItemId, client, selectedQuality);
        return this.retrieveResourceInfo(mediaItemId, selectedVersion, client, manifest.length());
    }

    private ResourceInfo retrieveResourceInfo(Long mediaItemId, MediaFormatProfile selectedVersion, Client client, int manifestFileSize) throws FileNotFoundException {
        return new ManifestInfo(mediaItemId, new Long(manifestFileSize), client.getRendererProfile().getMimeType(selectedVersion));
    }

    private String generateManifest(Long mediaItemId, Client client, DeliveryQuality.QualityType selectedQuality) throws FileNotFoundException {
        MediaItem mediaItem = MediaResourceRetrievalStrategy.loadMediaItem(mediaItemId);
        if (mediaItem != null) {
            if (mediaItem.getFileType() == MediaFileType.VIDEO) {
                List<Resource> resources = ResourceValuesBuilder.buildResources((Video)mediaItem, client.getRendererProfile());
                for (Resource resource : resources) {
                    if (resource.getResourceType() != Resource.ResourceType.MANIFEST) continue;
                    StringBuffer sb = new StringBuffer();
                    try {
                        String manifest = sb.append("#EXTM3U").append("\n").append("#EXT-X-STREAM-INF:PROGRAM-ID=1, BANDWIDTH=1600000").append("\n").append(resource.clone(Resource.ResourceType.MEDIA_ITEM, selectedQuality).getGeneratedURL(client.getHostInfo())).toString();
                        return manifest;
                    }
                    catch (InvalidResourceException e) {
                        throw new FileNotFoundException(e.getMessage());
                    }
                }
                throw new FileNotFoundException("No suitable manifest resource found for item " + mediaItemId);
            }
            throw new RuntimeException("Only video files are supported for manifest files.");
        }
        throw new FileNotFoundException(String.format("Video with id %s not found", mediaItemId));
    }
}

