/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.delivery;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.TreeMap;
import org.apache.http.ProtocolVersion;
import org.serviio.delivery.AbstractMethodProcessor;
import org.serviio.delivery.Client;
import org.serviio.delivery.DeliveryContainer;
import org.serviio.delivery.HttpDeliveryContainer;
import org.serviio.delivery.HttpResponseCodeException;
import org.serviio.delivery.RangeHeaders;
import org.serviio.delivery.ResourceDeliveryProcessor;
import org.serviio.delivery.ResourceInfo;
import org.serviio.delivery.ResourceRetrievalStrategy;
import org.serviio.delivery.StreamDeliveryContainer;
import org.serviio.delivery.resource.transcode.TranscodingJobListener;
import org.serviio.dlna.MediaFormatProfile;
import org.serviio.dlna.UnsupportedDLNAMediaFileFormatException;
import org.serviio.profile.DeliveryQuality;
import org.serviio.upnp.protocol.http.transport.TransferMode;

public class GETMethodProcessor
extends AbstractMethodProcessor {
    @Override
    protected ResourceDeliveryProcessor.HttpMethod getMethod() {
        return ResourceDeliveryProcessor.HttpMethod.GET;
    }

    @Override
    protected HttpDeliveryContainer buildDeliveryContainer(ResourceRetrievalStrategy resourceRetrievalStrategy, ResourceInfo resourceInfo, MediaFormatProfile selectedVersion, DeliveryQuality.QualityType quality, String path, TransferMode transferMode, Client client, long skipBytes, long streamSize, Double timeOffsetInSeconds, Double requestedDurationInSeconds, boolean partialContent, boolean deliverStream, ProtocolVersion requestHttpVersion, RangeHeaders requestRangeHeaders) throws IOException, UnsupportedDLNAMediaFileFormatException {
        boolean markAsRead = this.markAsReadRequired(requestRangeHeaders);
        return this.retrieveResource(resourceRetrievalStrategy, resourceInfo, selectedVersion, quality, path, transferMode, client, markAsRead, skipBytes, streamSize, timeOffsetInSeconds, requestedDurationInSeconds, partialContent, deliverStream, requestHttpVersion);
    }

    @Override
    protected HttpDeliveryContainer buildDeliveryContainerForTimeSeek(ResourceRetrievalStrategy resourceRetrievalStrategy, ResourceInfo resourceInfo, MediaFormatProfile selectedVersion, DeliveryQuality.QualityType quality, String path, TransferMode transferMode, Client client, ProtocolVersion requestHttpVersion, Long fileSize, RangeHeaders fixedRange) throws HttpResponseCodeException, UnsupportedDLNAMediaFileFormatException, IOException {
        boolean markAsRead = this.markAsReadRequired(fixedRange);
        DeliveryContainer deliveryContainer = resourceRetrievalStrategy.retrieveResource(resourceInfo.getResourceId(), selectedVersion, quality, path, null, null, client, markAsRead);
        TranscodingJobListener jobListener = deliveryContainer.getTranscodingJobListener();
        if (jobListener == null || jobListener.getFilesizeMap().size() == 0) {
            this.log.debug("Unsupported time range request because current filesize is not available, sending back 406");
            throw new HttpResponseCodeException(406);
        }
        TreeMap<Double, TranscodingJobListener.ProgressData> filesizeMap = jobListener.getFilesizeMap();
        Long startByte = this.convertSecondsToBytes(new Double(fixedRange.getStart(RangeHeaders.RangeUnit.SECONDS)), filesizeMap);
        this.log.debug(String.format("Delivering bytes %s - %s from transcoded file, based on time range %s - %s", startByte, fileSize, fixedRange.getStart(RangeHeaders.RangeUnit.SECONDS), fixedRange.getEnd(RangeHeaders.RangeUnit.SECONDS)));
        return this.retrieveResource(deliveryContainer, resourceInfo, transferMode, client, startByte, fileSize, true, true, requestHttpVersion);
    }

    @Override
    protected HttpDeliveryContainer prepareContainer(Map<String, Object> responseHeaders, DeliveryContainer container, TransferMode transferMode, Long skip, Long fileSize, boolean partialContent, ProtocolVersion requestHttpVersion, boolean transcoded, boolean alwaysCloseConnection, boolean deliverStream) {
        InputStream is = deliverStream ? ((StreamDeliveryContainer)container).getFileStream() : new ByteArrayInputStream(new byte[0]);
        Long contentLengthToRead = deliverStream ? new Long(fileSize) : 0L;
        if (container.getResourceInfo().isTranscoded() && alwaysCloseConnection) {
            contentLengthToRead = -1L;
            this.log.debug("Entity will be consumed till the end");
        }
        this.log.debug(String.format("Stream entity has length: %s", contentLengthToRead));
        this.seekInInputStream(is, skip);
        return new HttpDeliveryContainer(responseHeaders, is, partialContent, requestHttpVersion, transferMode, transcoded, contentLengthToRead);
    }

    private boolean markAsReadRequired(RangeHeaders rangeHeaders) {
        boolean offsetRequested = false;
        if (rangeHeaders != null) {
            Long start = rangeHeaders.hasHeaders(RangeHeaders.RangeUnit.BYTES) ? rangeHeaders.getStartAsLong(RangeHeaders.RangeUnit.BYTES) : null;
            start = start == null && rangeHeaders.hasHeaders(RangeHeaders.RangeUnit.SECONDS) ? rangeHeaders.getStartAsLong(RangeHeaders.RangeUnit.SECONDS) : null;
            boolean bl = offsetRequested = start != null && !start.equals(new Long(0L));
        }
        return !offsetRequested;
    }

    private HttpDeliveryContainer retrieveResource(ResourceRetrievalStrategy resourceRetrievalStrategy, ResourceInfo resourceInfo, MediaFormatProfile selectedVersion, DeliveryQuality.QualityType quality, String path, TransferMode transferMode, Client client, boolean markAsRead, long skipBytes, long streamSize, Double timeOffsetInSeconds, Double requestedDurationInSeconds, boolean partialContent, boolean deliverStream, ProtocolVersion requestHttpVersion) throws UnsupportedDLNAMediaFileFormatException, IOException {
        DeliveryContainer deliveryContainer = resourceRetrievalStrategy.retrieveResource(resourceInfo.getResourceId(), selectedVersion, quality, path, timeOffsetInSeconds, requestedDurationInSeconds, client, markAsRead);
        Long deliveredSize = deliveryContainer.getResourceInfo().getFileSize();
        Long realStreamSize = !partialContent && deliveredSize != null ? deliveredSize : streamSize;
        return this.retrieveResource(deliveryContainer, resourceInfo, transferMode, client, skipBytes, realStreamSize, partialContent, deliverStream, requestHttpVersion);
    }

    private void seekInInputStream(InputStream is, Long skip) {
        try {
            is.skip(skip);
        }
        catch (IOException e) {
            this.log.error("Cannot set starting index for the transport");
            throw new RuntimeException("Cannot skip file stream to requested byte: " + e.getMessage());
        }
    }
}

