/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.delivery;

import java.net.MalformedURLException;
import java.net.URL;
import org.serviio.delivery.HostInfo;
import org.serviio.delivery.ResourceURLGenerator;
import org.serviio.dlna.MediaFormatProfile;
import org.serviio.profile.DeliveryQuality;
import org.serviio.upnp.service.contentdirectory.classes.InvalidResourceException;
import org.serviio.upnp.service.contentdirectory.classes.Resource;
import org.serviio.util.ObjectValidator;

public class DefaultResourceURLGenerator
implements ResourceURLGenerator {
    public static final String RESOURCE_SEPARATOR = "-";

    @Override
    public String getGeneratedURL(HostInfo hostInfo, Resource.ResourceType resourceType, Long resourceId, MediaFormatProfile version, Integer protocolInfoIndex, DeliveryQuality.QualityType quality) throws InvalidResourceException {
        this.validate(resourceType, resourceId, version, protocolInfoIndex, quality);
        StringBuffer file = new StringBuffer();
        file.append(resourceId.toString());
        file.append("/").append(resourceType.toString());
        if (resourceType == Resource.ResourceType.MEDIA_ITEM || resourceType == Resource.ResourceType.MANIFEST) {
            file.append("/").append(version.toString());
            file.append(RESOURCE_SEPARATOR).append(protocolInfoIndex);
            file.append("/").append(quality.toString());
        }
        if (Resource.ResourceType.SUBTITLE == resourceType) {
            file.append(".srt");
        } else if (Resource.ResourceType.MANIFEST == resourceType || version != null && version.isManifestFormat()) {
            file.append(".m3u8");
        }
        return this.generateUrl(hostInfo, this.generatePath(hostInfo, file.toString()));
    }

    @Override
    public String getGeneratedURL(HostInfo hostInfo, Resource.ResourceType resourceType, Long resourceId, String path) throws InvalidResourceException {
        this.validate(resourceType, resourceId, null, null, null);
        StringBuffer file = new StringBuffer();
        file.append(resourceId.toString());
        file.append("/").append(resourceType.toString());
        file.append("/").append(path);
        return this.generateUrl(hostInfo, this.generatePath(hostInfo, file.toString()));
    }

    private String generatePath(HostInfo hostInfo, String path) {
        String queryString;
        StringBuffer file = new StringBuffer();
        file.append(hostInfo.getContext()).append("/").append(path);
        if (hostInfo.getURLParameters() != null && ObjectValidator.isNotEmpty(queryString = hostInfo.getURLParameters().get())) {
            if (path.indexOf(63) > -1) {
                file.append("&");
            } else {
                file.append("?");
            }
            file.append(queryString);
        }
        return file.toString();
    }

    private String generateUrl(HostInfo hostInfo, String path) {
        if (hostInfo.getHost() != null) {
            try {
                return new URL("http", hostInfo.getHost(), hostInfo.getPort(), path).toString();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Cannot resolve Resource URL address.");
            }
        }
        return path;
    }

    private void validate(Resource.ResourceType resourceType, Long resourceId, MediaFormatProfile version, Integer protocolInfoIndex, DeliveryQuality.QualityType quality) throws InvalidResourceException {
        if (resourceId == null || resourceType == null || resourceType == Resource.ResourceType.MEDIA_ITEM && (version == null || quality == null || protocolInfoIndex == null)) {
            throw new InvalidResourceException("Resource is not valid.");
        }
    }
}

