/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.delivery;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.serviio.delivery.Client;
import org.serviio.delivery.DeliveryContainer;
import org.serviio.delivery.ImageMediaInfo;
import org.serviio.delivery.ResourceInfo;
import org.serviio.delivery.ResourceRetrievalStrategy;
import org.serviio.delivery.StreamDeliveryContainer;
import org.serviio.dlna.MediaFormatProfile;
import org.serviio.dlna.ThumbnailResolution;
import org.serviio.dlna.UnsupportedDLNAMediaFileFormatException;
import org.serviio.library.entities.CoverImage;
import org.serviio.library.entities.MediaItem;
import org.serviio.library.local.service.MediaService;
import org.serviio.library.online.OnlineItemService;
import org.serviio.profile.DeliveryQuality;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoverImageRetrievalStrategy
implements ResourceRetrievalStrategy {
    private static final Logger log = LoggerFactory.getLogger(CoverImageRetrievalStrategy.class);

    @Override
    public DeliveryContainer retrieveResource(Long coverImageId, MediaFormatProfile selectedVersion, DeliveryQuality.QualityType selectedQuality, String path, Double timeOffsetInSeconds, Double durationInSeconds, Client client, boolean markAsRead) throws FileNotFoundException, IOException {
        CoverImage coverImage = this.retrieveCoverImage(coverImageId);
        ThumbnailResolution resolution = client.getRendererProfile().getThumbnailsResolution();
        boolean useHD = this.isHD(coverImage, resolution);
        log.debug(String.format("Retrieving Cover image (%s) with id %s", useHD ? "HD" : "SD", coverImageId));
        ResourceInfo resourceInfo = this.retrieveResourceInfo(coverImage, selectedVersion, resolution);
        StreamDeliveryContainer container = new StreamDeliveryContainer(new ByteArrayInputStream(useHD ? coverImage.getImageBytesHD() : coverImage.getImageBytes()), resourceInfo);
        return container;
    }

    @Override
    public ResourceInfo retrieveResourceInfo(Long coverImageId, MediaFormatProfile selectedVersion, DeliveryQuality.QualityType selectedQuality, String path, Client client) throws FileNotFoundException, UnsupportedDLNAMediaFileFormatException, IOException {
        CoverImage coverImage = this.retrieveCoverImage(coverImageId);
        ThumbnailResolution resolution = client.getRendererProfile().getThumbnailsResolution();
        log.debug(String.format("Retrieving info of Cover image with id %s", coverImageId));
        return this.retrieveResourceInfo(coverImage, selectedVersion, resolution);
    }

    private ResourceInfo retrieveResourceInfo(CoverImage coverImage, MediaFormatProfile selectedVersion, ThumbnailResolution resolution) throws FileNotFoundException {
        boolean useHD = this.isHD(coverImage, resolution);
        Long fileSize = new Long(useHD ? (long)coverImage.getImageBytesHD().length : (long)coverImage.getImageBytes().length);
        Integer width = useHD ? coverImage.getWidthHD() : coverImage.getWidth();
        Integer height = useHD ? coverImage.getHeightHD() : coverImage.getHeight();
        ImageMediaInfo resourceInfo = new ImageMediaInfo(coverImage.getId(), MediaFormatProfile.JPEG_TN, fileSize, width, height, false, coverImage.getMimeType(), DeliveryQuality.QualityType.ORIGINAL);
        return resourceInfo;
    }

    private CoverImage retrieveCoverImage(Long resourceId) throws FileNotFoundException, IOException {
        if (MediaItem.isLocalMedia(resourceId)) {
            CoverImage coverImage = MediaService.getCoverImage(resourceId);
            if (coverImage == null) {
                throw new FileNotFoundException(String.format("Cover image %s cannot be found", resourceId));
            }
            return coverImage;
        }
        CoverImage coverImage = OnlineItemService.findThumbnail(resourceId);
        if (coverImage == null) {
            throw new FileNotFoundException(String.format("Cover image for feed item %s cannot be found", resourceId));
        }
        return coverImage;
    }

    private boolean isHD(CoverImage coverImage, ThumbnailResolution resolution) {
        return resolution == ThumbnailResolution.HD && coverImage.getImageBytesHD() != null;
    }
}

