/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.delivery;

import org.serviio.delivery.URLParameters;
import org.serviio.util.StringUtils;

public class CDSUrlParameters
implements URLParameters {
    public static final String AUTH_PARAM_NAME = "authToken";
    public static final String PROFILE_PARAM_NAME = "profile";
    public static final String IGNORE_PRESENTATION_SETTINGS_PARAM_NAME = "ignorePresentationSettings";
    private static final String sharedSecurityToken = StringUtils.generateRandomToken();
    private final boolean useSharedSecurity;
    private final String profileId;

    public CDSUrlParameters(boolean useSharedSecurity, String profileId) {
        this.useSharedSecurity = useSharedSecurity;
        this.profileId = profileId;
    }

    public static String getSharedSecurityToken() {
        return sharedSecurityToken;
    }

    @Override
    public String get() {
        StringBuffer sb = new StringBuffer();
        if (this.profileId != null) {
            sb.append(PROFILE_PARAM_NAME).append("=").append(this.profileId);
        }
        if (this.useSharedSecurity) {
            sb.append("&").append(AUTH_PARAM_NAME).append("=").append(sharedSecurityToken);
        }
        return sb.toString();
    }
}

