/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.delivery;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.http.ProtocolVersion;
import org.serviio.delivery.AudioMediaInfo;
import org.serviio.delivery.Client;
import org.serviio.delivery.DeliveryContainer;
import org.serviio.delivery.HttpDeliveryContainer;
import org.serviio.delivery.HttpResponseCodeException;
import org.serviio.delivery.ImageMediaInfo;
import org.serviio.delivery.RangeHeaders;
import org.serviio.delivery.ResourceDeliveryProcessor;
import org.serviio.delivery.ResourceInfo;
import org.serviio.delivery.ResourceRetrievalStrategy;
import org.serviio.delivery.VideoMediaInfo;
import org.serviio.delivery.resource.transcode.TranscodingJobListener;
import org.serviio.delivery.subtitles.SubtitlesInfo;
import org.serviio.dlna.MediaFormatProfile;
import org.serviio.dlna.UnsupportedDLNAMediaFileFormatException;
import org.serviio.profile.DeliveryQuality;
import org.serviio.upnp.protocol.http.transport.ResourceTransportProtocolHandler;
import org.serviio.upnp.protocol.http.transport.TransferMode;
import org.serviio.util.ObjectValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMethodProcessor {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final Long TRANSCODED_VIDEO_CONTENT_LENGTH = new Long(50000000000L);
    private static final Long TRANSCODED_AUDIO_CONTENT_LENGTH = new Long(900000000L);
    private static final Long TRANSCODED_IMAGE_CONTENT_LENGTH = new Long(9000000L);
    private static final Long TRANSCODED_SUBTITLE_CONTENT_LENGTH = new Long(300000L);

    protected abstract HttpDeliveryContainer buildDeliveryContainer(ResourceRetrievalStrategy var1, ResourceInfo var2, MediaFormatProfile var3, DeliveryQuality.QualityType var4, String var5, TransferMode var6, Client var7, long var8, long var10, Double var12, Double var13, boolean var14, boolean var15, ProtocolVersion var16, RangeHeaders var17) throws IOException, UnsupportedDLNAMediaFileFormatException;

    protected abstract HttpDeliveryContainer buildDeliveryContainerForTimeSeek(ResourceRetrievalStrategy var1, ResourceInfo var2, MediaFormatProfile var3, DeliveryQuality.QualityType var4, String var5, TransferMode var6, Client var7, ProtocolVersion var8, Long var9, RangeHeaders var10) throws HttpResponseCodeException, UnsupportedDLNAMediaFileFormatException, IOException;

    protected abstract HttpDeliveryContainer prepareContainer(Map<String, Object> var1, DeliveryContainer var2, TransferMode var3, Long var4, Long var5, boolean var6, ProtocolVersion var7, boolean var8, boolean var9, boolean var10);

    protected abstract ResourceDeliveryProcessor.HttpMethod getMethod();

    public HttpDeliveryContainer handleRequest(ResourceRetrievalStrategy resourceRetrievalStrategy, ResourceInfo resourceInfo, MediaFormatProfile selectedVersion, DeliveryQuality.QualityType quality, String path, Map<String, String> requestHeaders, RangeHeaders requestRangeHeaders, ProtocolVersion requestHttpVersion, Integer protocolInfoIndex, Client client, ResourceTransportProtocolHandler protocolHandler) throws HttpResponseCodeException, IOException, UnsupportedDLNAMediaFileFormatException {
        TransferMode transferMode = this.getTransferMode(requestHeaders, resourceInfo);
        HttpDeliveryContainer responseContainer = null;
        Long fileSize = this.computeFileSize(resourceInfo);
        RangeHeaders range = null;
        if (requestRangeHeaders != null) {
            if (!resourceInfo.isLive()) {
                if (requestRangeHeaders.hasHeaders(RangeHeaders.RangeUnit.BYTES) && (range = protocolHandler.handleByteRange(requestRangeHeaders, requestHttpVersion, resourceInfo, fileSize)) != null) {
                    responseContainer = this.buildDeliveryContainer(resourceRetrievalStrategy, resourceInfo, selectedVersion, quality, path, transferMode, client, range.getStartAsLong(RangeHeaders.RangeUnit.BYTES), range.getEndAsLong(RangeHeaders.RangeUnit.BYTES) - range.getStartAsLong(RangeHeaders.RangeUnit.BYTES) + 1L, null, null, true, range.getTotal(RangeHeaders.RangeUnit.BYTES) != -1L, requestHttpVersion, requestRangeHeaders);
                }
                if (responseContainer == null && requestRangeHeaders.hasHeaders(RangeHeaders.RangeUnit.SECONDS) && resourceInfo.getDuration() != null && (range = protocolHandler.handleTimeRange(requestRangeHeaders, requestHttpVersion, resourceInfo)) != null) {
                    if (range.getStart(RangeHeaders.RangeUnit.SECONDS).longValue() == 0L && range.getEnd(RangeHeaders.RangeUnit.SECONDS).longValue() == new Long(resourceInfo.getDuration().intValue()).longValue()) {
                        responseContainer = this.buildDeliveryContainer(resourceRetrievalStrategy, resourceInfo, selectedVersion, quality, path, transferMode, client, 0L, fileSize, null, null, false, true, requestHttpVersion, requestRangeHeaders);
                    } else if (resourceInfo.getFileSize() == null) {
                        if (client.isSupportsRandomTimeSeek()) {
                            Double requestedTimeOffset = range.getStart(RangeHeaders.RangeUnit.SECONDS);
                            Double requestedDuration = range.getEnd(RangeHeaders.RangeUnit.SECONDS) - range.getStart(RangeHeaders.RangeUnit.SECONDS);
                            responseContainer = this.buildDeliveryContainer(resourceRetrievalStrategy, resourceInfo, selectedVersion, quality, path, transferMode, client, 0L, fileSize, requestedTimeOffset, requestedDuration, true, true, requestHttpVersion, requestRangeHeaders);
                        } else {
                            responseContainer = this.buildDeliveryContainerForTimeSeek(resourceRetrievalStrategy, resourceInfo, selectedVersion, quality, path, transferMode, client, requestHttpVersion, fileSize, range);
                        }
                    } else {
                        this.log.debug(String.format("Delivering bytes %s - %s from native file, based on time range %s - %s", range.getStart(RangeHeaders.RangeUnit.BYTES), range.getEnd(RangeHeaders.RangeUnit.BYTES), range.getStart(RangeHeaders.RangeUnit.SECONDS), range.getEnd(RangeHeaders.RangeUnit.SECONDS)));
                        responseContainer = this.buildDeliveryContainer(resourceRetrievalStrategy, resourceInfo, selectedVersion, quality, path, transferMode, client, range.getStartAsLong(RangeHeaders.RangeUnit.BYTES), range.getEndAsLong(RangeHeaders.RangeUnit.BYTES) - range.getStartAsLong(RangeHeaders.RangeUnit.BYTES) + 1L, null, null, true, true, requestHttpVersion, requestRangeHeaders);
                    }
                }
            } else {
                this.log.warn("A range header was found on the incoming request for a live stream, sending back the whole stream");
            }
        }
        if (responseContainer == null) {
            responseContainer = this.buildDeliveryContainer(resourceRetrievalStrategy, resourceInfo, selectedVersion, quality, path, transferMode, client, 0L, fileSize, null, null, false, true, requestHttpVersion, requestRangeHeaders);
        }
        protocolHandler.handleResponse(requestHeaders, responseContainer.getResponseHeaders(), this.getMethod(), requestHttpVersion, resourceInfo, protocolInfoIndex, transferMode, client, responseContainer.getFileSize(), range);
        return responseContainer;
    }

    protected TransferMode getTransferMode(Map<String, String> headers, ResourceInfo resourceInfo) {
        String requestedTransferMode = headers.get("transferMode.dlna.org");
        if (requestedTransferMode != null && ObjectValidator.isNotEmpty(requestedTransferMode)) {
            return TransferMode.getValueByHttpHeaderValue(requestedTransferMode);
        }
        if (resourceInfo instanceof ImageMediaInfo || resourceInfo instanceof SubtitlesInfo) {
            return TransferMode.INTERACTIVE;
        }
        return TransferMode.STREAMING;
    }

    protected Long computeFileSize(ResourceInfo resourceInfo) {
        if (resourceInfo.getFileSize() != null) {
            return resourceInfo.getFileSize();
        }
        if (resourceInfo instanceof ImageMediaInfo) {
            return TRANSCODED_IMAGE_CONTENT_LENGTH;
        }
        if (resourceInfo instanceof AudioMediaInfo) {
            return TRANSCODED_AUDIO_CONTENT_LENGTH;
        }
        if (resourceInfo instanceof VideoMediaInfo) {
            return TRANSCODED_VIDEO_CONTENT_LENGTH;
        }
        if (resourceInfo instanceof SubtitlesInfo) {
            return TRANSCODED_SUBTITLE_CONTENT_LENGTH;
        }
        return null;
    }

    protected HttpDeliveryContainer retrieveResource(DeliveryContainer deliveryContainer, ResourceInfo resourceInfo, TransferMode transferMode, Client client, long skipBytes, long streamSize, boolean partialContent, boolean deliverStream, ProtocolVersion requestHttpVersion) throws UnsupportedDLNAMediaFileFormatException, IOException {
        LinkedHashMap<String, Object> responseHeaders = new LinkedHashMap<String, Object>();
        responseHeaders.put("Content-Type", resourceInfo.getMimeType());
        if (resourceInfo.isLive()) {
            responseHeaders.put("Accept-Ranges", "none");
        }
        return this.prepareContainer(responseHeaders, deliveryContainer, transferMode, skipBytes, streamSize, partialContent, requestHttpVersion, resourceInfo.isTranscoded(), client.isExpectsClosedConnection(), deliverStream);
    }

    protected Long convertSecondsToBytes(Double seconds, TreeMap<Double, TranscodingJobListener.ProgressData> filesizeMap) {
        if (seconds == 0.0) {
            return 0L;
        }
        if (seconds <= filesizeMap.lastKey()) {
            Map.Entry<Double, TranscodingJobListener.ProgressData> upperBoundary = filesizeMap.ceilingEntry(seconds);
            Map.Entry<Double, TranscodingJobListener.ProgressData> lowerBoundary = filesizeMap.floorEntry(seconds);
            if (lowerBoundary == null) {
                return this.convertSecondsToBytes(upperBoundary.getValue().getFileSize(), upperBoundary.getKey(), 0L, 0.0, seconds);
            }
            return this.convertSecondsToBytes(upperBoundary.getValue().getFileSize(), upperBoundary.getKey(), lowerBoundary.getValue().getFileSize(), lowerBoundary.getKey(), seconds);
        }
        Map.Entry<Double, TranscodingJobListener.ProgressData> lastEntry = filesizeMap.lastEntry();
        Double secondsFromLast = seconds - lastEntry.getKey();
        Double approxFileSizeSinceLastEntry = (double)lastEntry.getValue().getBitrate().floatValue() * secondsFromLast / 8.0 * 1024.0;
        return lastEntry.getValue().getFileSize() + approxFileSizeSinceLastEntry.longValue();
    }

    private Long convertSecondsToBytes(Long upperFileSize, Double upperTime, Long lowerFilesize, Double lowerTime, Double seconds) {
        if (upperTime.equals(lowerTime)) {
            return upperFileSize * 1024L;
        }
        Long segmentFilesize = upperFileSize - lowerFilesize;
        Double segmentDuration = upperTime - lowerTime;
        Double kBytesPerSecond = (double)segmentFilesize.longValue() / segmentDuration;
        Double approxkBytes = (double)lowerFilesize.longValue() + kBytesPerSecond * (seconds - lowerTime);
        return approxkBytes.longValue() * 1024L;
    }
}

