/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import org.serviio.db.DatabaseManager;
import org.serviio.util.JdbcUtils;

public abstract class JdbcExecutor<T> {
    private static final List<String> lockErrorCodes = Arrays.asList("40XL1", "40XL2", "40001");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeUpdate() throws SQLException {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = this.processStatement(con);
        }
        catch (SQLException e) {
            try {
                if (!lockErrorCodes.contains(e.getSQLState())) {
                    throw e;
                }
                ps = this.processStatement(con);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
            JdbcUtils.closeStatement(ps);
            DatabaseManager.releaseConnection(con);
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
    }

    protected abstract PreparedStatement processStatement(Connection var1) throws SQLException;
}

