/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.serviio.ApplicationSettings;
import org.serviio.db.DBConnectionPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseManager {
    private static final Logger log = LoggerFactory.getLogger(DatabaseManager.class);
    private static final String DB_SCHEMA_URL;
    private static final DBType DB_TYPE;
    private static final DBConnectionPool pool;
    private static final int MAX_POOL_CONNECTION = 20;
    private static final long CONNECTION_TIMEOUT = 2000L;

    public static Connection getConnection() throws SQLException {
        return DatabaseManager.getConnection(true);
    }

    public static Connection getConnection(boolean autoCommit) throws SQLException {
        return pool.getConnection(2000L, autoCommit);
    }

    public static void releaseConnection(Connection con) {
        pool.freeConnection(con);
    }

    public static DBType getDBType() {
        return DB_TYPE;
    }

    public static void stopDatabase() {
        try {
            log.info("Shutting down database");
            DatabaseManager.releasePool();
            if (DB_TYPE == DBType.DERBY) {
                DriverManager.getConnection("jdbc:derby:;shutdown=true");
            }
        }
        catch (SQLException e) {
            log.debug("DB shutdown returned: " + e.getMessage());
        }
    }

    public static void releasePool() {
        pool.release();
    }

    private static DBType getDBType(String dbSchemaUrl) {
        if (dbSchemaUrl.indexOf("derby") > -1) {
            return DBType.DERBY;
        }
        if (dbSchemaUrl.indexOf("mysql") > -1) {
            return DBType.MYSQL;
        }
        throw new RuntimeException(String.format("Unsupported DB URL: %s", dbSchemaUrl));
    }

    static {
        String systemURL = System.getProperty("dbURL");
        DB_SCHEMA_URL = systemURL != null ? systemURL : ApplicationSettings.getStringProperty("db_schema_url");
        pool = new DBConnectionPool("Serviio DB Pool", DB_SCHEMA_URL, 20);
        DB_TYPE = DatabaseManager.getDBType(DB_SCHEMA_URL);
        log.info("Using " + (Object)((Object)DB_TYPE) + " database language");
    }

    public static enum DBType {
        DERBY,
        MYSQL;

    }
}

