/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DBConnectionPool {
    private static final Logger log = LoggerFactory.getLogger(DBConnectionPool.class);
    private int checkedOut;
    private Vector<Connection> freeConnections = new Vector();
    private int maxConn;
    private String name;
    private String URL;

    public DBConnectionPool(String name, String URL2, int maxConn) {
        this.name = name;
        this.URL = URL2;
        this.maxConn = maxConn;
    }

    public synchronized void freeConnection(Connection con) {
        if (con != null) {
            this.freeConnections.addElement(con);
        }
        --this.checkedOut;
        this.notifyAll();
        if (log.isTraceEnabled()) {
            log.trace(String.format("Releasing connection from pool %s", this.name));
        }
    }

    public synchronized Connection getConnection(boolean autoCommit) throws SQLException {
        Connection con = null;
        if (this.freeConnections.size() > 0) {
            con = this.freeConnections.firstElement();
            this.freeConnections.removeElementAt(0);
            if (log.isTraceEnabled()) {
                log.trace(String.format("Getting pooled connection from pool %s", this.name));
            }
            try {
                if (con.isClosed()) {
                    if (log.isTraceEnabled()) {
                        log.trace("Removed bad connection from " + this.name);
                    }
                    con = this.getConnection(autoCommit);
                }
            }
            catch (SQLException e) {
                if (log.isTraceEnabled()) {
                    log.trace("Removed bad connection from " + this.name);
                }
                con = this.getConnection(autoCommit);
            }
        } else if (this.maxConn == 0 || this.checkedOut < this.maxConn) {
            con = this.newConnection();
        }
        if (con != null) {
            ++this.checkedOut;
            con.setAutoCommit(autoCommit);
        }
        return con;
    }

    public synchronized Connection getConnection(long timeout, boolean autoCommit) throws SQLException {
        Connection con;
        long startTime = new Date().getTime();
        while ((con = this.getConnection(autoCommit)) == null) {
            try {
                this.wait(timeout);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (new Date().getTime() - startTime < timeout) continue;
            return null;
        }
        return con;
    }

    public synchronized void release() {
        Enumeration<Connection> allConnections = this.freeConnections.elements();
        while (allConnections.hasMoreElements()) {
            Connection con = allConnections.nextElement();
            try {
                con.close();
                log.debug("Closed connection for pool " + this.name);
            }
            catch (SQLException e) {
                log.debug("Can't close connection for pool " + this.name, (Throwable)e);
            }
        }
        this.freeConnections.removeAllElements();
    }

    private Connection newConnection() {
        Connection con = null;
        try {
            con = DriverManager.getConnection(this.URL);
            if (log.isTraceEnabled()) {
                log.trace("Created a new connection in pool " + this.name);
            }
        }
        catch (SQLException e) {
            log.warn("Can't create a new connection for " + this.URL, (Throwable)e);
            return null;
        }
        return con;
    }
}

