/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.config.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.serviio.config.dao.ConfigEntryDAO;
import org.serviio.config.entities.ConfigEntry;
import org.serviio.db.DatabaseManager;
import org.serviio.db.dao.InvalidArgumentException;
import org.serviio.db.dao.PersistenceException;
import org.serviio.util.JdbcUtils;
import org.serviio.util.ObjectValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigEntryDAOImpl
implements ConfigEntryDAO {
    private static final Logger log = LoggerFactory.getLogger(ConfigEntryDAOImpl.class);

    @Override
    public long create(ConfigEntry newInstance) throws InvalidArgumentException, PersistenceException {
        long l;
        if (newInstance == null || ObjectValidator.isEmpty(newInstance.getName())) {
            throw new InvalidArgumentException("Cannot create ConfigEntry. Required data is missing.");
        }
        log.debug(String.format("Creating a new ConfigEntry (name = %s, value = %s)", newInstance.getName(), newInstance.getValue()));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("INSERT INTO config (name, value) VALUES (?,?)", 1);
            ps.setString(1, newInstance.getName());
            ps.setString(2, newInstance.getValue());
            ps.executeUpdate();
            l = JdbcUtils.retrieveGeneratedID(ps);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot create ConfigEntry with name %s", newInstance.getName()), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return l;
    }

    @Override
    public void delete(Long id) throws PersistenceException {
        log.debug(String.format("Deleting a ConfigEntry (id = %s)", id));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("DELETE FROM config WHERE id = ?");
            ps.setLong(1, id);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot delete ConfigEntry with id = %s", id), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
    }

    @Override
    public ConfigEntry read(Long id) throws PersistenceException {
        ConfigEntry configEntry;
        log.debug(String.format("Reading a ConfigEntry (id = %s)", id));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT id, name, value FROM config where id = ?");
            ps.setLong(1, id);
            ResultSet rs = ps.executeQuery();
            configEntry = this.mapSingleResult(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read ConfigEntry with id = %s", id), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return configEntry;
    }

    @Override
    public void update(ConfigEntry transientObject) throws InvalidArgumentException, PersistenceException {
        if (transientObject == null || transientObject.getId() == null || ObjectValidator.isEmpty(transientObject.getName())) {
            throw new InvalidArgumentException("Cannot update ConfigEntry. Required data is missing.");
        }
        log.debug(String.format("Updating ConfigEntry (name = %s, value = %s)", transientObject.getName(), transientObject.getValue()));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("UPDATE config SET value = ? WHERE id = ?");
            ps.setString(1, transientObject.getValue());
            ps.setLong(2, transientObject.getId());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot update ConfigEntry with id %s", transientObject.getId()), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
    }

    @Override
    public ConfigEntry findConfigEntryByName(String name) {
        ConfigEntry configEntry;
        log.debug(String.format("Reading a ConfigEntry (name = %s)", name));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT id, name, value FROM config where name = ?");
            ps.setString(1, name);
            ResultSet rs = ps.executeQuery();
            configEntry = this.mapSingleResult(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read ConfigEntry with name = %s", name), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return configEntry;
    }

    @Override
    public List<ConfigEntry> findAllConfigEntries() {
        List<ConfigEntry> list;
        log.debug("Reading all ConfigEntries");
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT id, name, value FROM config");
            ResultSet rs = ps.executeQuery();
            list = this.mapResultSet(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException("Cannot read all ConfigEntries", e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return list;
    }

    protected ConfigEntry mapSingleResult(ResultSet rs) throws SQLException {
        if (rs.next()) {
            return this.initConfigEntry(rs);
        }
        return null;
    }

    protected List<ConfigEntry> mapResultSet(ResultSet rs) throws SQLException {
        ArrayList<ConfigEntry> result = new ArrayList<ConfigEntry>();
        while (rs.next()) {
            result.add(this.initConfigEntry(rs));
        }
        return result;
    }

    private ConfigEntry initConfigEntry(ResultSet rs) throws SQLException {
        Long id = rs.getLong("id");
        String name = rs.getString("name");
        String value = rs.getString("value");
        ConfigEntry entry = new ConfigEntry(name, value);
        entry.setId(id);
        return entry;
    }
}

