/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.config;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.serviio.config.ConfigStorage;
import org.serviio.config.entities.ConfigEntry;
import org.serviio.db.dao.DAOFactory;

public class JDBCConfigStorage
implements ConfigStorage {
    @Override
    public Map<String, String> readAllConfigurationValues() {
        HashMap<String, String> values = new HashMap<String, String>();
        List<ConfigEntry> configEntries = DAOFactory.getConfigEntryDAO().findAllConfigEntries();
        for (ConfigEntry configEntry : configEntries) {
            values.put(configEntry.getName(), configEntry.getValue());
        }
        return values;
    }

    @Override
    public void storeValue(String name, String value) {
        ConfigEntry configEntry = DAOFactory.getConfigEntryDAO().findConfigEntryByName(name);
        if (configEntry != null) {
            configEntry.setValue(value);
            DAOFactory.getConfigEntryDAO().update(configEntry);
        } else {
            configEntry = new ConfigEntry(name, value);
            DAOFactory.getConfigEntryDAO().create(configEntry);
        }
    }
}

