/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.serviio.ApplicationSettings;
import org.serviio.config.ConfigStorage;
import org.serviio.library.entities.AccessGroup;
import org.serviio.library.online.PreferredQuality;
import org.serviio.licensing.LicensingManager;
import org.serviio.profile.DeliveryQuality;
import org.serviio.util.CollectionUtils;
import org.serviio.util.FileUtils;
import org.serviio.util.ObjectValidator;
import org.serviio.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration {
    private static final Logger log = LoggerFactory.getLogger(Configuration.class);
    private static final String DATABASE_UPDATE_ID = "db_update_id";
    private static final String SEARCH_HIDDEN_FILES = "search_hidden_files";
    private static final String SEARCH_FOR_UPDATED_FILES = "search_updated_files";
    private static final String RETRIEVE_ART_FROM_ONLINE_SOURCES = "retireve_art_from_online_sources";
    private static final String BOUND_NIC_NAME = "bound_nic_name";
    private static final String TRANSCODING_ENABLED = "transcoding_enabled";
    private static final String TRANSCODING_FOLDER = "transcoding_folder";
    private static final String TRANSCODING_THREADS = "transcoding_threads";
    private static final String TRANSCODING_DOWNMIX_TO_STEREO = "transcoding_downmix_to_stereo";
    private static final String TRANSCODING_BEST_QUALITY = "transcoding_best_quality";
    private static final String REPOSITORY_AUTOMATIC_CHECK = "repository_automatic_check";
    private static final String REPOSITORY_AUTOMATIC_CHECK_INTERVAL = "repository_automatic_check_interval";
    private static final String METADATA_GENERATE_LOCAL_THUMBNAIL_VIDEO = "metadata_generate_local_thumbnail";
    private static final String METADATA_GENERATE_LOCAL_THUMBNAIL_IMAGE = "metadata_generate_local_thumbnail_image";
    private static final String METADATA_PREFERRED_LANGUAGE = "metadata_preferred_language";
    private static final String METADATA_USE_ORIGINAL_TITLE = "metadata_use_original_title";
    private static final String BROWSE_MENU_ITEM_OPTIONS = "browse_menu_item_options";
    private static final String BROWSE_MENU_SHOW_CATEGORY_NAME_IF_TRANSPARENT = "browse_menu_show_parent";
    private static final String BROWSE_MENU_PREFERRED_LANGUAGE = "browse_menu_preferred_language";
    private static final String CONSOLE_PREFERRED_LANGUAGE = "console_preferred_language";
    private static final String ONLINE_FEED_MAX_NUMBER_OF_ITEMS = "online_feed_max_num_items";
    private static final String ONLINE_FEED_EXPIRY_INTERVAL = "online_feed_expiry_interval";
    private static final String ONLINE_FEED_PREFERRED_QUALITY = "online_feed_prefered_quality";
    private static final String CUSTOMER_LICENSE = "customer_license";
    private static final String WEB_PASSWORD = "web_password";
    private static final String REMOTE_PREFERRED_DELIVERY_QUALITY = "remote_preferred_quality";
    private static final String REMOTE_ENABLE_PORT_FORWARDING = "enable_port_forwarding";
    private static final String REMOTE_EXTERNAL_ADDRESS = "remote_external_address";
    private static final String CONSOLE_SECURITY_PIN = "console_security_pin";
    private static final String CONSOLE_CHECK_FOR_UPDATES = "console_check_for_updates";
    private static final String BROWSE_MENU_DYNAMIC_CATEGORIES_NUMBER = "browse_menu_dyn_cat_number";
    private static final String SUBTITLES_PREFERRED_LANGUAGE = "subtitles_preferred_language";
    private static final String SUBTITLES_ENABLED = "subtitles_enabled";
    private static final String SUBTITLES_HARDSUBS_ENABLED = "subtitles_hardsubs_enabled";
    private static final String SUBTITLES_HARDSUBS_FORCE = "subtitles_hardsubs_force";
    private static final String SUBTITLES_EXTRACT_EMBEDDED = "subtitles_extract_embedded";
    private static final String SUBTITLES_HARDSUBS_CHARENC = "subtitles_character_encoding";
    private static final String RENDERER_ENABLED_BY_DEFAULT = "renderer_enabled_default";
    private static final String RENDERER_DEFAULT_ACCESS_GROUP_ID = "renderer_default_access_group_id";
    private static final String BROWSE_FILTER_OUT_SERIES = "browse_filter_out_series";
    private static Map<String, String> cache = new HashMap<String, String>();
    private static ConfigStorage storage;

    public static boolean isSearchHiddenFiles() {
        String value = cache.get(SEARCH_HIDDEN_FILES);
        if (ObjectValidator.isNotEmpty(value)) {
            return Boolean.valueOf(value);
        }
        return false;
    }

    public static void setSearchHiddenFiles(boolean search) {
        Configuration.storeConfigValue(SEARCH_HIDDEN_FILES, Boolean.toString(search));
    }

    public static boolean isSearchUpdatedFiles() {
        String value = cache.get(SEARCH_FOR_UPDATED_FILES);
        if (ObjectValidator.isNotEmpty(value)) {
            return Boolean.valueOf(value);
        }
        return true;
    }

    public static void setSearchUpdatedFiles(boolean search) {
        Configuration.storeConfigValue(SEARCH_FOR_UPDATED_FILES, Boolean.toString(search));
    }

    public static boolean isRetrieveArtFromOnlineSources() {
        String value = cache.get(RETRIEVE_ART_FROM_ONLINE_SOURCES);
        if (ObjectValidator.isNotEmpty(value)) {
            return Boolean.valueOf(value);
        }
        return true;
    }

    public static void setRetrieveArtFromOnlineSources(boolean retrieve) {
        Configuration.storeConfigValue(RETRIEVE_ART_FROM_ONLINE_SOURCES, Boolean.toString(retrieve));
    }

    public static String getBoundNICName() {
        String value = cache.get(BOUND_NIC_NAME);
        if (ObjectValidator.isNotEmpty(value)) {
            return value;
        }
        return null;
    }

    public static void setBoundNICName(String name) {
        if (ObjectValidator.isEmpty(name)) {
            Configuration.storeConfigValue(BOUND_NIC_NAME, "");
        } else {
            Configuration.storeConfigValue(BOUND_NIC_NAME, name);
        }
    }

    public static boolean isTranscodingEnabled() {
        String value = cache.get(TRANSCODING_ENABLED);
        if (ObjectValidator.isNotEmpty(value)) {
            return Boolean.valueOf(value);
        }
        return true;
    }

    public static void setTranscodingEnabled(boolean transcode) {
        Configuration.storeConfigValue(TRANSCODING_ENABLED, Boolean.toString(transcode));
    }

    public static String getTranscodingFolder() {
        String value = cache.get(TRANSCODING_FOLDER);
        if (ObjectValidator.isNotEmpty(value)) {
            return value;
        }
        String defaultTranscodeLocation = System.getProperty("serviio.defaultTranscodeFolder");
        if (defaultTranscodeLocation != null && FileUtils.fileExists(defaultTranscodeLocation)) {
            return defaultTranscodeLocation;
        }
        return System.getProperty("java.io.tmpdir");
    }

    public static void setTranscodingFolder(String folder) {
        if (ObjectValidator.isEmpty(folder)) {
            Configuration.storeConfigValue(TRANSCODING_FOLDER, System.getProperty("java.io.tmpdir"));
        } else {
            Configuration.storeConfigValue(TRANSCODING_FOLDER, folder);
        }
    }

    public static String getTranscodingThreads() {
        String value = cache.get(TRANSCODING_THREADS);
        if (ObjectValidator.isNotEmpty(value)) {
            return value;
        }
        return "auto";
    }

    public static void setTranscodingThreads(Integer threads) {
        if (threads == null) {
            Configuration.storeConfigValue(TRANSCODING_THREADS, "auto");
        } else {
            Configuration.storeConfigValue(TRANSCODING_THREADS, threads.toString());
        }
    }

    public static boolean isTranscodingDownmixToStereo() {
        String value = cache.get(TRANSCODING_DOWNMIX_TO_STEREO);
        if (ObjectValidator.isNotEmpty(value)) {
            return Boolean.valueOf(value);
        }
        return true;
    }

    public static void setTranscodingDownmixToStereo(boolean retrieve) {
        Configuration.storeConfigValue(TRANSCODING_DOWNMIX_TO_STEREO, Boolean.toString(retrieve));
    }

    public static boolean isTranscodingBestQuality() {
        String value = cache.get(TRANSCODING_BEST_QUALITY);
        if (ObjectValidator.isNotEmpty(value)) {
            return Boolean.valueOf(value);
        }
        return true;
    }

    public static void setTranscodingBestQuality(boolean bestQuality) {
        Configuration.storeConfigValue(TRANSCODING_BEST_QUALITY, Boolean.toString(bestQuality));
    }

    public static boolean isAutomaticLibraryRefresh() {
        String value = cache.get(REPOSITORY_AUTOMATIC_CHECK);
        if (ObjectValidator.isNotEmpty(value)) {
            return Boolean.valueOf(value);
        }
        return true;
    }

    public static void setAutomaticLibraryRefresh(boolean autoRefresh) {
        Configuration.storeConfigValue(REPOSITORY_AUTOMATIC_CHECK, Boolean.toString(autoRefresh));
    }

    public static Integer getAutomaticLibraryRefreshInterval() {
        String value = cache.get(REPOSITORY_AUTOMATIC_CHECK_INTERVAL);
        if (ObjectValidator.isNotEmpty(value)) {
            return Integer.parseInt(value);
        }
        return 5;
    }

    public static void setAutomaticLibraryRefreshInterval(Integer minutes) {
        if (minutes == null || minutes <= 0) {
            Configuration.storeConfigValue(REPOSITORY_AUTOMATIC_CHECK_INTERVAL, "5");
        } else {
            Configuration.storeConfigValue(REPOSITORY_AUTOMATIC_CHECK_INTERVAL, minutes.toString());
        }
    }

    public static boolean isGenerateLocalThumbnailForVideos() {
        String value = cache.get(METADATA_GENERATE_LOCAL_THUMBNAIL_VIDEO);
        if (ObjectValidator.isNotEmpty(value)) {
            return Boolean.valueOf(value);
        }
        return true;
    }

    public static void setGenerateLocalThumbnailForVideos(boolean generate) {
        Configuration.storeConfigValue(METADATA_GENERATE_LOCAL_THUMBNAIL_VIDEO, Boolean.toString(generate));
    }

    public static boolean isGenerateLocalThumbnailForImages() {
        String value = cache.get(METADATA_GENERATE_LOCAL_THUMBNAIL_IMAGE);
        if (ObjectValidator.isNotEmpty(value)) {
            return Boolean.valueOf(value);
        }
        return true;
    }

    public static void setGenerateLocalThumbnailForImages(boolean generate) {
        Configuration.storeConfigValue(METADATA_GENERATE_LOCAL_THUMBNAIL_IMAGE, Boolean.toString(generate));
    }

    public static String getMetadataPreferredLanguage() {
        String value = cache.get(METADATA_PREFERRED_LANGUAGE);
        if (ObjectValidator.isNotEmpty(value)) {
            return value;
        }
        return "en";
    }

    public static void setMetadataPreferredLanguage(String languageCode) {
        if (ObjectValidator.isEmpty(languageCode)) {
            Configuration.storeConfigValue(METADATA_PREFERRED_LANGUAGE, "en");
        } else {
            Configuration.storeConfigValue(METADATA_PREFERRED_LANGUAGE, languageCode);
        }
    }

    public static boolean isMetadataUseOriginalTitle() {
        String value = cache.get(METADATA_USE_ORIGINAL_TITLE);
        if (ObjectValidator.isNotEmpty(value)) {
            return Boolean.valueOf(value);
        }
        return false;
    }

    public static void setMetadataUseOriginalTitle(boolean useOriginalTitle) {
        Configuration.storeConfigValue(METADATA_USE_ORIGINAL_TITLE, Boolean.toString(useOriginalTitle));
    }

    public static Map<String, String> getBrowseMenuItemOptions() {
        String value = cache.get(BROWSE_MENU_ITEM_OPTIONS);
        if (ObjectValidator.isNotEmpty(value)) {
            return CollectionUtils.CSVToMap(value, ",");
        }
        return Collections.emptyMap();
    }

    public static void setBrowseMenuItemOptions(Map<String, String> itemsMap) {
        if (itemsMap != null) {
            Configuration.storeConfigValue(BROWSE_MENU_ITEM_OPTIONS, CollectionUtils.mapToCSV(itemsMap, ",", true));
        } else {
            Configuration.storeConfigValue(BROWSE_MENU_ITEM_OPTIONS, "");
        }
    }

    public static String getBrowseMenuPreferredLanguage() {
        String value = cache.get(BROWSE_MENU_PREFERRED_LANGUAGE);
        if (ObjectValidator.isNotEmpty(value)) {
            return value;
        }
        return "en";
    }

    public static void setBrowseMenuPreferredLanguage(String languageCode) {
        if (ObjectValidator.isEmpty(languageCode)) {
            Configuration.storeConfigValue(BROWSE_MENU_PREFERRED_LANGUAGE, "en");
        } else {
            Configuration.storeConfigValue(BROWSE_MENU_PREFERRED_LANGUAGE, languageCode);
        }
    }

    public static void setBrowseMenuShowNameOfParentCategory(boolean showTitle) {
        Configuration.storeConfigValue(BROWSE_MENU_SHOW_CATEGORY_NAME_IF_TRANSPARENT, Boolean.toString(showTitle));
    }

    public static boolean isBrowseMenuShowNameOfParentCategory() {
        String value = cache.get(BROWSE_MENU_SHOW_CATEGORY_NAME_IF_TRANSPARENT);
        if (ObjectValidator.isNotEmpty(value)) {
            return Boolean.valueOf(value);
        }
        return true;
    }

    public static String getConsolePreferredLanguage() {
        String value = cache.get(CONSOLE_PREFERRED_LANGUAGE);
        if (ObjectValidator.isNotEmpty(value)) {
            return value;
        }
        return null;
    }

    public static void setConsolePreferredLanguage(String languageCode) {
        if (ObjectValidator.isEmpty(languageCode)) {
            Configuration.storeConfigValue(CONSOLE_PREFERRED_LANGUAGE, "");
        } else {
            Configuration.storeConfigValue(CONSOLE_PREFERRED_LANGUAGE, languageCode);
        }
    }

    public static Integer getMaxNumberOfItemsForOnlineFeeds() {
        String value = cache.get(ONLINE_FEED_MAX_NUMBER_OF_ITEMS);
        if (ObjectValidator.isNotEmpty(value)) {
            return Integer.parseInt(value);
        }
        return 20;
    }

    public static void setMaxNumberOfItemsForOnlineFeeds(Integer number) {
        if (number == null) {
            Configuration.storeConfigValue(ONLINE_FEED_MAX_NUMBER_OF_ITEMS, "20");
        } else {
            Configuration.storeConfigValue(ONLINE_FEED_MAX_NUMBER_OF_ITEMS, number.toString());
        }
    }

    public static Integer getOnlineFeedExpiryInterval() {
        String value = cache.get(ONLINE_FEED_EXPIRY_INTERVAL);
        if (ObjectValidator.isNotEmpty(value)) {
            return Integer.parseInt(value);
        }
        return 24;
    }

    public static void setOnlineFeedExpiryInterval(Integer hours) {
        if (hours == null || hours <= 0) {
            Configuration.storeConfigValue(ONLINE_FEED_EXPIRY_INTERVAL, "24");
        } else {
            Configuration.storeConfigValue(ONLINE_FEED_EXPIRY_INTERVAL, hours.toString());
        }
    }

    public static PreferredQuality getOnlineFeedPreferredQuality() {
        String value = cache.get(ONLINE_FEED_PREFERRED_QUALITY);
        if (ObjectValidator.isNotEmpty(value)) {
            return PreferredQuality.valueOf(value);
        }
        return PreferredQuality.MEDIUM;
    }

    public static void setOnlineFeedPreferredQuality(PreferredQuality quality) {
        Configuration.storeConfigValue(ONLINE_FEED_PREFERRED_QUALITY, quality.toString());
    }

    public static String getCustomerLicense() {
        String value = cache.get(CUSTOMER_LICENSE);
        if (ObjectValidator.isNotEmpty(value)) {
            return value;
        }
        return null;
    }

    public static void setCustomerLicense(String licenseBody) {
        if (ObjectValidator.isEmpty(licenseBody)) {
            Configuration.storeConfigValue(CUSTOMER_LICENSE, "");
        } else {
            Configuration.storeConfigValue(CUSTOMER_LICENSE, licenseBody);
        }
    }

    public static String getWebPassword() {
        String value = cache.get(WEB_PASSWORD);
        if (ObjectValidator.isNotEmpty(value)) {
            return value;
        }
        return null;
    }

    public static void setWebPassword(String password) {
        if (ObjectValidator.isEmpty(password)) {
            Configuration.storeConfigValue(WEB_PASSWORD, "");
        } else {
            Configuration.storeConfigValue(WEB_PASSWORD, password);
        }
    }

    public static String getConsoleSecurityPin() {
        String value = cache.get(CONSOLE_SECURITY_PIN);
        if (ObjectValidator.isNotEmpty(value)) {
            return value;
        }
        return null;
    }

    public static void setConsoleSecurityPin(String password) {
        if (ObjectValidator.isEmpty(password)) {
            Configuration.storeConfigValue(CONSOLE_SECURITY_PIN, "");
        } else {
            Configuration.storeConfigValue(CONSOLE_SECURITY_PIN, password);
        }
    }

    public static DeliveryQuality.QualityType getRemotePreferredDeliveryQuality() {
        String value = cache.get(REMOTE_PREFERRED_DELIVERY_QUALITY);
        if (ObjectValidator.isNotEmpty(value)) {
            return DeliveryQuality.QualityType.valueOf(value);
        }
        return DeliveryQuality.QualityType.MEDIUM;
    }

    public static boolean isRemotePortForwardingEnabled() {
        String value = cache.get(REMOTE_ENABLE_PORT_FORWARDING);
        if (ObjectValidator.isNotEmpty(value)) {
            return Boolean.valueOf(value);
        }
        return false;
    }

    public static void setRemotePortForwardingEnabled(boolean enable) {
        Configuration.storeConfigValue(REMOTE_ENABLE_PORT_FORWARDING, Boolean.toString(enable));
    }

    public static void setRemotePreferredDeliveryQuality(DeliveryQuality.QualityType quality) {
        Configuration.storeConfigValue(REMOTE_PREFERRED_DELIVERY_QUALITY, quality.toString());
    }

    public static String getRemoteExternalAddress() {
        String value = cache.get(REMOTE_EXTERNAL_ADDRESS);
        if (ObjectValidator.isNotEmpty(value)) {
            return value;
        }
        return null;
    }

    public static void setRemoteExternalAddress(String address) {
        if (ObjectValidator.isEmpty(address)) {
            Configuration.storeConfigValue(REMOTE_EXTERNAL_ADDRESS, "");
        } else {
            Configuration.storeConfigValue(REMOTE_EXTERNAL_ADDRESS, address);
        }
    }

    public static boolean isConsoleCheckForUpdatesEnabled() {
        String value = cache.get(CONSOLE_CHECK_FOR_UPDATES);
        if (ObjectValidator.isNotEmpty(value)) {
            return Boolean.valueOf(value);
        }
        return true;
    }

    public static void setConsoleCheckForUpdatesEnabled(boolean check) {
        Configuration.storeConfigValue(CONSOLE_CHECK_FOR_UPDATES, Boolean.toString(check));
    }

    public static Integer getNumberOfFilesForDynamicCategories() {
        String value = cache.get(BROWSE_MENU_DYNAMIC_CATEGORIES_NUMBER);
        if (ObjectValidator.isNotEmpty(value)) {
            return Integer.parseInt(value);
        }
        return 10;
    }

    public static void setNumberOfFilesForDynamicCategories(Integer number) {
        if (number == null || number <= 0) {
            Configuration.storeConfigValue(BROWSE_MENU_DYNAMIC_CATEGORIES_NUMBER, "10");
        } else {
            Configuration.storeConfigValue(BROWSE_MENU_DYNAMIC_CATEGORIES_NUMBER, number.toString());
        }
    }

    public static List<String> getSubtitlesPreferredLanguages() {
        String value = cache.get(SUBTITLES_PREFERRED_LANGUAGE);
        return CollectionUtils.csvToList(value, ",", true);
    }

    public static void setSubtitlesPreferredLanguages(List<String> languageCodes) {
        if (languageCodes == null || languageCodes.size() == 0) {
            Configuration.storeConfigValue(SUBTITLES_PREFERRED_LANGUAGE, "");
        } else {
            Configuration.storeConfigValue(SUBTITLES_PREFERRED_LANGUAGE, CollectionUtils.listToCSV(languageCodes, ",", true));
        }
    }

    public static boolean isSubtitlesEnabled() {
        String value = cache.get(SUBTITLES_ENABLED);
        if (ObjectValidator.isNotEmpty(value)) {
            return Boolean.valueOf(value);
        }
        return true;
    }

    public static void setSubtitlesEnabled(boolean enabled) {
        Configuration.storeConfigValue(SUBTITLES_ENABLED, Boolean.toString(enabled));
    }

    public static boolean isHardSubsEnabled() {
        String value = cache.get(SUBTITLES_HARDSUBS_ENABLED);
        if (ObjectValidator.isNotEmpty(value)) {
            return Boolean.valueOf(value);
        }
        return false;
    }

    public static void setHardSubsEnabled(boolean enabled) {
        Configuration.storeConfigValue(SUBTITLES_HARDSUBS_ENABLED, Boolean.toString(enabled));
    }

    public static boolean isHardSubsForced() {
        String value = cache.get(SUBTITLES_HARDSUBS_FORCE);
        if (ObjectValidator.isNotEmpty(value)) {
            return Boolean.valueOf(value);
        }
        return false;
    }

    public static void setHardSubsForced(boolean enabled) {
        Configuration.storeConfigValue(SUBTITLES_HARDSUBS_FORCE, Boolean.toString(enabled));
    }

    public static boolean isEmbeddedSubtitlesExtracted() {
        String value = cache.get(SUBTITLES_EXTRACT_EMBEDDED);
        if (ObjectValidator.isNotEmpty(value)) {
            return Boolean.valueOf(value);
        }
        return false;
    }

    public static void setEmbeddedSubtitlesExtracted(boolean enabled) {
        Configuration.storeConfigValue(SUBTITLES_EXTRACT_EMBEDDED, Boolean.toString(enabled));
    }

    public static String getSubsCharacterEncoding() {
        String value = cache.get(SUBTITLES_HARDSUBS_CHARENC);
        if (ObjectValidator.isNotEmpty(value)) {
            return value;
        }
        return "UTF-8";
    }

    public static void setSubsCharacterEncoding(String enc) {
        Configuration.storeConfigValue(SUBTITLES_HARDSUBS_CHARENC, enc);
    }

    public static String getDatabaseUpdateId() {
        String value = cache.get(DATABASE_UPDATE_ID);
        if (ObjectValidator.isNotEmpty(value)) {
            return value;
        }
        String token = StringUtils.generateRandomToken();
        Configuration.setDatabaseUpdateId(token);
        return token;
    }

    public static void setDatabaseUpdateId(String token) {
        Configuration.storeConfigValue(DATABASE_UPDATE_ID, token);
    }

    public static boolean isRendererEnabledByDefault() {
        String value = cache.get(RENDERER_ENABLED_BY_DEFAULT);
        if (ObjectValidator.isNotEmpty(value)) {
            return Boolean.valueOf(value);
        }
        return true;
    }

    public static void setRendererEnabledByDefault(boolean enabled) {
        Configuration.storeConfigValue(RENDERER_ENABLED_BY_DEFAULT, Boolean.toString(enabled));
    }

    public static Long getRendererDefaultAccessGroupId() {
        if (LicensingManager.getInstance().isProVersion()) {
            String value = cache.get(RENDERER_DEFAULT_ACCESS_GROUP_ID);
            if (ObjectValidator.isNotEmpty(value)) {
                return new Long(value);
            }
            return AccessGroup.NO_LIMIT_ACCESS_GROUP_ID;
        }
        return AccessGroup.NO_LIMIT_ACCESS_GROUP_ID;
    }

    public static void setRendererDefaultAccessGroupId(Long id) {
        Configuration.storeConfigValue(RENDERER_DEFAULT_ACCESS_GROUP_ID, id != null ? id.toString() : "");
    }

    public static boolean isBrowseFilterOutSeries() {
        String value = cache.get(BROWSE_FILTER_OUT_SERIES);
        if (ObjectValidator.isNotEmpty(value)) {
            return Boolean.valueOf(value);
        }
        return false;
    }

    public static void setBrowseFilterOutSeries(boolean filter) {
        Configuration.storeConfigValue(BROWSE_FILTER_OUT_SERIES, Boolean.toString(filter));
    }

    private static void storeConfigValue(String configEntryName, String value) {
        cache.put(configEntryName, value);
        storage.storeValue(configEntryName, value);
    }

    private static void instantiateStorage() {
        try {
            Class<?> storageClass = Class.forName(ApplicationSettings.getStringProperty("configuration_storage_class"));
            storage = (ConfigStorage)storageClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            log.error(String.format("Cannot instantiate Profile. Message: %s", e.getMessage()));
        }
        catch (InstantiationException e) {
            log.error(String.format("Cannot instantiate Profile. Message: %s", e.getMessage()));
        }
        catch (IllegalAccessException e) {
            log.error(String.format("Cannot instantiate Profile. Message: %s", e.getMessage()));
        }
    }

    static {
        Configuration.instantiateStorage();
        Map<String, String> currentValues = storage.readAllConfigurationValues();
        for (Map.Entry<String, String> configEntry : currentValues.entrySet()) {
            cache.put(configEntry.getKey(), configEntry.getValue());
        }
    }
}

