/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.cache;

import org.apache.jcs.JCS;
import org.apache.jcs.access.exception.CacheException;
import org.serviio.cache.CacheDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCacheDecorator
implements CacheDecorator {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected JCS cache;
    protected String regionName;

    public AbstractCacheDecorator(String regionName) {
        try {
            this.cache = JCS.getInstance((String)regionName);
            this.regionName = regionName;
        }
        catch (CacheException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void evictAll() {
        try {
            this.cache.clear();
            this.log.debug(String.format("Cleared cache (%s)", this.regionName));
        }
        catch (CacheException e) {
            this.log.warn(String.format("Could not clean local cache (%s): %s", this.regionName, e.getMessage()));
        }
    }

    @Override
    public void shutdown() {
        this.cache.dispose();
    }
}

