/*
 * Decompiled with CFR 0.152.
 */
package org.serviio;

import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import org.serviio.ApplicationInstanceListener;
import org.serviio.ApplicationInstanceManager;
import org.serviio.ApplicationSettings;
import org.serviio.UPnPServerStatus;
import org.serviio.db.DatabaseManager;
import org.serviio.delivery.resource.VideoDeliveryEngine;
import org.serviio.external.DCRawWrapper;
import org.serviio.external.FFMPEGWrapper;
import org.serviio.library.local.LibraryManager;
import org.serviio.library.online.OnlineLibraryManager;
import org.serviio.library.search.SearchManager;
import org.serviio.licensing.LicensingManager;
import org.serviio.licensing.ServiioLicense;
import org.serviio.profile.ProfileManager;
import org.serviio.renderer.RendererManager;
import org.serviio.restlet.RestletServer;
import org.serviio.update.DBSchemaUpdateExecutor;
import org.serviio.update.UpdateChecker;
import org.serviio.upnp.Device;
import org.serviio.upnp.discovery.DiscoveryManager;
import org.serviio.upnp.service.contentdirectory.rest.access.PortMapper;
import org.serviio.upnp.service.contentdirectory.rest.resources.server.LoginServerResource;
import org.serviio.upnp.webserver.WebServer;
import org.serviio.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class MediaServer {
    private static final Logger log = LoggerFactory.getLogger(MediaServer.class);
    private static DiscoveryManager discoveryManager;
    private static UPnPServerStatus status;
    private static Map<String, Object> arguments;
    public static String VERSION;
    public static final String CHANGESET;
    private static final String ARGUMENT_STOP = "stop";
    private static Thread serverThread;
    private static boolean serviceInitializationInProcess;

    public static void main(String[] stringArray) {
        serverThread = Thread.currentThread();
        try {
            MediaServer.parseArguments(stringArray);
            MediaServer.checkForRunningInstances();
            MediaServer.redirectLegacyLoggingToSlf4j();
            MediaServer.printInformation();
            RestletServer.runServer();
            DBSchemaUpdateExecutor.updateDBSchema();
            Device.getInstance();
            ProfileManager.loadProfiles();
            OnlineLibraryManager.getInstance().startPluginCompilerThread();
            UpdateChecker.startCheckerThread();
            MediaServer.addShutdownHooks();
            if (!FFMPEGWrapper.ffmpegPresent()) {
                log.error("FFMPEG not found. Serviio will not work properly.");
            }
            if (!DCRawWrapper.dcrawPresent()) {
                log.warn("DCRAW not found. Support for raw image files will be missing.");
            }
            VideoDeliveryEngine.cleanupTranscodingEngine();
            PortMapper.getInstance().resetPortMapping();
            MediaServer.startServer();
            MediaServer.notifyEndInitialization();
            try {
                Thread.sleep(20000L);
                OnlineLibraryManager.getInstance().startFeedUpdaterThread();
                LibraryManager.getInstance().startLibraryAdditionsCheckerThread();
                LibraryManager.getInstance().startLibraryUpdatesCheckerThread();
                LibraryManager.getInstance().startPlaylistMaintainerThread();
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (RuntimeException runtimeException) {
            log.error(String.format("An unexpected error occured. Ending the application. Message: %s", runtimeException.getMessage()), (Throwable)runtimeException);
            MediaServer.exit();
        }
    }

    public static UPnPServerStatus getStatus() {
        return status;
    }

    public static boolean isServiceInitializationInProcess() {
        return serviceInitializationInProcess;
    }

    public static void exit() {
        serverThread.interrupt();
        System.exit(0);
    }

    public static void startServer() {
        if (status == UPnPServerStatus.STOPPED) {
            status = UPnPServerStatus.INITIALIZING;
            try {
                WebServer.start(WebServer.WEBSERVER_PORT);
            }
            catch (IOException e) {
                log.error("Cannot start web server, exiting", (Throwable)e);
                MediaServer.exit();
            }
            Device.getInstance().refreshBoundIPAddress();
            discoveryManager = DiscoveryManager.instance();
            discoveryManager.initialize();
            discoveryManager.deviceAvailable();
            RendererManager.getInstance().searchForActiveRenderers();
            status = UPnPServerStatus.STARTED;
        }
    }

    public static void stopServer() {
        if (status != UPnPServerStatus.STOPPED) {
            try {
                WebServer.stop();
            }
            catch (IOException e) {
                log.error("cannot stop web server");
                return;
            }
            if (discoveryManager != null) {
                discoveryManager.deviceUnavailable(true);
            }
            status = UPnPServerStatus.STOPPED;
        }
    }

    protected static void addShutdownHooks() {
        Runtime.getRuntime().addShutdownHook(new ShutdownHook());
    }

    protected static void redirectLegacyLoggingToSlf4j() {
        java.util.logging.Logger rootLogger = LogManager.getLogManager().getLogger("");
        Handler[] handlers = rootLogger.getHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            rootLogger.removeHandler(handlers[i]);
        }
        SLF4JBridgeHandler.install();
    }

    private static void printInformation() {
        log.info("------------------------------------------------------------------------");
        log.info("Serviio DLNA media streaming server v " + VERSION + " (rev. " + CHANGESET + ")");
        log.info("Petr Nejedly 2009-2014");
        log.info("http://www.serviio.org");
        log.info("");
        log.info("Java " + System.getProperty("java.version") + "-" + System.getProperty("java.vendor"));
        log.info("OS " + System.getProperty("os.name") + " " + System.getProperty("os.arch") + " " + System.getProperty("os.version"));
        log.info("File encoding: " + Charset.defaultCharset().displayName());
        log.info("Headless mode enabled: " + GraphicsEnvironment.isHeadless());
        log.info("User: " + System.getProperty("user.name"));
        log.info("User home dir: " + System.getProperty("user.home"));
        log.info("Temp dir: " + System.getProperty("java.io.tmpdir"));
        log.info("------------------------------------------------------------------------");
    }

    private static void printLicenseInformation() {
        ServiioLicense lic = LicensingManager.getInstance().getLicense();
        String licenseInfo = lic.getEdition().toString();
        if (lic.getEdition() == LicensingManager.ServiioEdition.PRO) {
            licenseInfo = licenseInfo + String.format(" (%s, id: %s)", new Object[]{lic.getType(), lic.getId()});
        }
        log.info("------------------------------------------------------------------------");
        log.info("License: " + licenseInfo);
        log.info("------------------------------------------------------------------------");
    }

    private static void checkForRunningInstances() {
        boolean stopRequested;
        boolean bl = stopRequested = arguments.containsKey(ARGUMENT_STOP) && arguments.get(ARGUMENT_STOP).equals(Boolean.TRUE);
        if (!ApplicationInstanceManager.registerInstance(stopRequested) || stopRequested) {
            MediaServer.exit();
        }
        ApplicationInstanceManager.setApplicationInstanceListener(new ApplicationInstanceListener(){

            @Override
            public void newInstanceCreated(boolean closeRequest) {
                if (closeRequest) {
                    MediaServer.exit();
                } else {
                    log.info("Serviio server instance is already running");
                }
            }
        });
    }

    private static void parseArguments(String[] args) {
        for (String arg : args) {
            if (!StringUtils.localeSafeToLowercase(arg).equals("-stop")) continue;
            arguments.put(ARGUMENT_STOP, true);
        }
    }

    private static void notifyEndInitialization() {
        serviceInitializationInProcess = false;
    }

    static {
        status = UPnPServerStatus.STOPPED;
        arguments = new HashMap<String, Object>();
        VERSION = ApplicationSettings.getStringProperty("version");
        CHANGESET = ApplicationSettings.getStringProperty("changeset");
        serviceInitializationInProcess = true;
    }

    private static class ShutdownHook
    extends Thread {
        private ShutdownHook() {
        }

        @Override
        public void run() {
            LibraryManager.getInstance().stopLibraryAdditionsCheckerThread();
            LibraryManager.getInstance().stopLibraryUpdatesCheckerThread();
            OnlineLibraryManager.getInstance().stopFeedUpdaterThread();
            OnlineLibraryManager.getInstance().stopPluginCompilerThread();
            OnlineLibraryManager.getInstance().shutdownCaches();
            LoginServerResource.shutdownTokenCache();
            PortMapper.getInstance().shutdownLeaseRenewer();
            PortMapper.getInstance().removePortMapping();
            SearchManager.getInstance().closeSearchEngine();
            MediaServer.stopServer();
            discoveryManager.shutDown();
            ApplicationInstanceManager.stopInstance();
            DatabaseManager.stopDatabase();
            VideoDeliveryEngine.cleanupTranscodingEngine();
        }
    }
}

