/*
 * Decompiled with CFR 0.152.
 */
package org.serviio;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import org.serviio.ApplicationInstanceListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationInstanceManager {
    private static final Logger log = LoggerFactory.getLogger(ApplicationInstanceManager.class);
    private static ApplicationInstanceListener subListener;
    public static final int SINGLE_INSTANCE_NETWORK_SOCKET = 44331;
    public static final String SINGLE_INSTANCE_SHARED_KEY = "$$NewInstance$$\n";
    public static final String CLOSE_INSTANCE_SHARED_KEY = "$$CloseInstance$$\n";
    private static ServerSocket socket;

    public static boolean registerInstance(boolean stopInstance) {
        boolean returnValueOnError = true;
        try {
            socket = new ServerSocket(44331, 10, InetAddress.getLocalHost());
            log.debug("Listening for application instances on socket 44331");
            Thread instanceListenerThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    boolean socketClosed = false;
                    while (!socketClosed) {
                        if (socket.isClosed()) {
                            socketClosed = true;
                            continue;
                        }
                        try {
                            Socket client = socket.accept();
                            BufferedReader in = new BufferedReader(new InputStreamReader(client.getInputStream()));
                            String message = in.readLine();
                            if (ApplicationInstanceManager.SINGLE_INSTANCE_SHARED_KEY.trim().equals(message.trim())) {
                                log.debug("Shared key matched - new application instance found");
                                ApplicationInstanceManager.fireNewInstance(false);
                            } else if (ApplicationInstanceManager.CLOSE_INSTANCE_SHARED_KEY.trim().equals(message.trim())) {
                                log.debug("Close key matched - close request found");
                                ApplicationInstanceManager.fireNewInstance(true);
                            }
                            in.close();
                            client.close();
                        }
                        catch (IOException e) {
                            socketClosed = true;
                        }
                    }
                }
            }, "Instance checker");
            instanceListenerThread.setDaemon(true);
            instanceListenerThread.start();
        }
        catch (UnknownHostException e) {
            log.error(e.getMessage(), (Throwable)e);
            return returnValueOnError;
        }
        catch (IOException e) {
            try {
                Socket clientSocket = new Socket(InetAddress.getLocalHost(), 44331);
                OutputStream out = clientSocket.getOutputStream();
                if (stopInstance) {
                    log.debug("Notifying first instance to stop.");
                    out.write(CLOSE_INSTANCE_SHARED_KEY.getBytes());
                } else {
                    log.debug("Port is already taken. Notifying first instance.");
                    out.write(SINGLE_INSTANCE_SHARED_KEY.getBytes());
                }
                out.close();
                clientSocket.close();
                log.debug("Successfully notified first instance.");
                return false;
            }
            catch (UnknownHostException e1) {
                log.error(e.getMessage(), (Throwable)e);
                return returnValueOnError;
            }
            catch (IOException e1) {
                log.error("Error connecting to local port for single instance notification");
                log.error(e1.getMessage(), (Throwable)e1);
                return returnValueOnError;
            }
        }
        return true;
    }

    public static void stopInstance() {
        try {
            if (socket != null) {
                socket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void setApplicationInstanceListener(ApplicationInstanceListener listener) {
        subListener = listener;
    }

    private static void fireNewInstance(boolean closeRequest) {
        if (subListener != null) {
            subListener.newInstanceCreated(closeRequest);
        }
    }
}

