/*
 * Decompiled with CFR 0.152.
 */
package br.com.andretanaka.andrehtgti2.geracargascripts.util;

import br.com.andretanaka.andrehtgti2.geracargascripts.util.CopiaArquivoAHT;
import br.com.andretanaka.andrehtgti2.geracargascripts.util.LocationAHT;
import com.maxmind.geoip.Location;
import com.maxmind.geoip.LookupService;
import com.maxmind.geoip.regionName;
import java.io.File;
import java.io.IOException;

public class GeoLocalizacaoViaIpAHT {
    String fileOrigemGeoLiteCityDat = "GeoLiteCity.dat";
    File fileDestino = new File("a.dat");

    public GeoLocalizacaoViaIpAHT() {
        try {
            this.apagaDat();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        GeoLocalizacaoViaIpAHT obj = new GeoLocalizacaoViaIpAHT();
        LocationAHT locationAHT = obj.getLocationCopiaDatSeNaoExistir("201.83.167.51");
        System.out.println(locationAHT);
    }

    public void copiaDat() throws IOException {
        CopiaArquivoAHT.copyFileFromStream(this.getClass().getResourceAsStream(this.fileOrigemGeoLiteCityDat), this.fileDestino, true);
    }

    public void apagaDat() {
        this.fileDestino.delete();
    }

    public LocationAHT getLocationCopiaDatSeNaoExistir(String ipAddress) {
        if (ipAddress != null && !ipAddress.trim().equals("")) {
            ipAddress = ipAddress.trim();
            try {
                if (!this.fileDestino.exists()) {
                    this.copiaDat();
                }
                LocationAHT locationAHT = this.getLocation(ipAddress, this.fileDestino);
                return locationAHT;
            }
            catch (Throwable e) {
                try {
                    this.copiaDat();
                    LocationAHT locationAHT = this.getLocation(ipAddress, this.fileDestino);
                    return locationAHT;
                }
                catch (Throwable e2) {
                    return new LocationAHT();
                }
            }
        }
        return new LocationAHT();
    }

    private LocationAHT getLocation(String ipAddress, File file) {
        LocationAHT locationAHT = null;
        try {
            locationAHT = new LocationAHT();
            LookupService lookup = new LookupService(file, 1);
            Location locationServices = lookup.getLocation(ipAddress);
            if (locationServices != null) {
                locationAHT.setCountryCode(locationServices.countryCode == null ? "" : locationServices.countryCode);
                locationAHT.setCountryName(locationServices.countryName == null ? "" : locationServices.countryName);
                locationAHT.setRegion(locationServices.region == null ? "" : locationServices.region);
                locationAHT.setRegionName(regionName.regionNameByCode((String)locationServices.countryCode, (String)locationServices.region));
                locationAHT.setCity(locationServices.city == null ? "" : locationServices.city);
                locationAHT.setPostalCode(locationServices.postalCode == null ? "" : locationServices.postalCode);
                locationAHT.setLatitude(String.valueOf(locationServices.latitude));
                locationAHT.setLongitude(String.valueOf(locationServices.longitude));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return locationAHT;
    }
}

