/*
 * Decompiled with CFR 0.152.
 */
package br.com.andretanaka.andrehtgti2.geracargascripts.arquivo;

import br.com.autbank.gen.util.ManipulaJavaUtilDate;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class GravaArquivo {
    public static String ARQUIVO_LOG = "Log_Execucao_SQL.txt";
    public static SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    public Date dataAtual = new Date();
    public String dataStamp = String.valueOf(ManipulaJavaUtilDate.getInstance((Date)this.dataAtual).getAno()) + "_" + ManipulaJavaUtilDate.getInstance((Date)this.dataAtual).getMes() + "_" + ManipulaJavaUtilDate.getInstance((Date)this.dataAtual).getDia();
    public static String FILE_SEPARATOR = System.getProperty("file.separator");
    public static String LINE_SEPARATOR = System.getProperty("line.separator");

    public void gravaArquivo(String arquivo, ArrayList array, String servidor, String bancoDeDados) throws IOException {
        try {
            if (array != null) {
                String[] conteudo = null;
                conteudo = array.toArray(new String[0]);
                arquivo = GravaArquivo.replaceFileUniversalPathAHT(arquivo);
                File file = new File(arquivo);
                String caminhoDir2 = file.getParentFile().getAbsolutePath();
                caminhoDir2 = GravaArquivo.replaceFileUniversalPathAHT(caminhoDir2);
                File diretorio2 = new File(caminhoDir2);
                diretorio2.mkdirs();
                System.out.println(file.getAbsolutePath());
                if (!file.exists()) {
                    file.createNewFile();
                }
                FileOutputStream out = new FileOutputStream(file, true);
                byte[] aux = null;
                int i = 0;
                while (i < conteudo.length) {
                    aux = conteudo[i].replaceAll("\r\r\n", "\r\n").getBytes();
                    out.write(aux);
                    ++i;
                }
                out.flush();
                out.close();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new IOException(e.getMessage(), e);
        }
    }

    public void deletaArquivo(String arquivo) {
        File file;
        if (arquivo.endsWith("CAD_DOMINIOS_TIPOS.sql")) {
            System.out.println("");
        }
        if ((file = new File(arquivo = GravaArquivo.replaceFileUniversalPathAHT(arquivo))).exists()) {
            file.delete();
        }
    }

    public static String replaceFileUniversalPathAHT(String path) {
        if (FILE_SEPARATOR.trim().equals("/")) {
            path = path.replaceAll("\\\\", FILE_SEPARATOR);
            path = path.replaceAll("\\\\\\\\", FILE_SEPARATOR);
        } else if (FILE_SEPARATOR.trim().equals("\\")) {
            path = path.replaceAll("/", String.valueOf(FILE_SEPARATOR) + FILE_SEPARATOR);
            path = path.replaceAll("//", String.valueOf(FILE_SEPARATOR) + FILE_SEPARATOR);
        }
        return path;
    }

    public void gravaLog(String txt) {
        OutputStreamWriter fileWriter = null;
        PrintWriter printWriter = null;
        try {
            try {
                File file = new File(ARQUIVO_LOG);
                if (!file.exists()) {
                    file.createNewFile();
                }
                fileWriter = new FileWriter(file, true);
                printWriter = new PrintWriter((Writer)fileWriter, true);
                printWriter.append(String.valueOf(simpleDateFormat.format(new Date())) + " - " + txt);
                printWriter.flush();
                fileWriter.flush();
            }
            catch (Throwable e) {
                e.printStackTrace();
                try {
                    printWriter.close();
                    fileWriter.close();
                }
                catch (Throwable throwable) {}
            }
        }
        finally {
            try {
                printWriter.close();
                fileWriter.close();
            }
            catch (Throwable throwable) {}
        }
    }

    protected String printStackTraceToString(Throwable t) {
        StringWriter errors = new StringWriter();
        t.printStackTrace(new PrintWriter(errors));
        String ret = "...##################################################################################################################################\r\n";
        ret = String.valueOf(ret) + "...##################### PrintStackTrace ############################################################################################\r\n";
        ret = String.valueOf(ret) + "...##################################################################################################################################\r\n";
        ret = String.valueOf(ret) + errors.toString();
        ret = String.valueOf(ret) + "...##################################################################################################################################\r\n";
        ret = String.valueOf(ret) + "...##################################################################################################################################\r\n";
        ret = String.valueOf(ret) + "...##################################################################################################################################\r\n";
        return ret;
    }
}

