//==================================================================
// Licensed Materials - Property of IBM
// (c) Copyright IBM Corp. 2003.  All rights reserved.
//
// US Government Users Restricted Rights - Use, duplication or
// disclosure restricted by GSA ADP Schedule Contract with IBM
// Corp.
//
// DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
// sample code created by IBM Corporation.  This sample code is
// not part of any standard or IBM product and is provided to you
// solely for the purpose of assisting you in the development of
// your applications.  The code is provided "AS IS", without
// warranty of any kind.  IBM shall not be liable for any damages
// arising out of your use of the sample code, even if they have
// been advised of the possibility of such damages.
//=================================================================

/**
 * @class public Tab_obj
 * This class is used to construct an object which represent a tab
 * This constructor will initialize the TabAdapter with it's corresponding tab control
 * @constructor Tab_obj
**/
function Tab_obj()
{
  this.Name   = '';
  this.height = 0;
  this.width  = 0;
  this.selectedTab = 1;
  this.containerDiv;
  this.theme;

  this.TabArray    = new Array();
  this.ButtonArray = new Array();

  this.setTabPage = setTabPage;
  this.activateTabPage = activateTabPage;
  this.updateControl = updateControl;

  // Events
  this.onactivatepage = null;
}
/**
* @method private ShowTab
*   The function is used to show and hide tabs based on the passed parameter
* @param int tabNo
*	the index of the tab which will be shown.
**/
function activateTabPage(tabNo)
{
  var theme_class  = "display_" + this.theme;
  var theme_buttonSel = "tabButtonSel_" + this.theme;
  var theme_button = "tabButton_" + this.theme;

  for(var i=1; i < this.TabArray.length; i++)
  {
    if ( i == tabNo )
    {
      this.TabArray[i][0].className = theme_class;
      this.ButtonArray[i].className = theme_buttonSel;
    }
    else
    {
      this.TabArray[i][0].className = "hide";
      this.ButtonArray[i].className = theme_button;
    }

  }
  this.selectedTab = tabNo;
  if (this.onactivatepage != null)
	this.onactivatepage();
}

/**
* @method private setTabPage
*   The function is used to set the data structure of the tab
* @param int tabNo
*	the index of the tab
* @param Object DivObj
*	HTML Div Object of the tab
* @param String Desc
* 	The name of the tab.
**/
function setTabPage(tabNo, DivObj, Desc)
{
  this.TabArray[tabNo] = new Array();

  var theme_class = "display_" + this.theme;
  DivObj.className = theme_class;
  this.TabArray[tabNo][0] = DivObj;
  this.TabArray[tabNo][1] = Desc;
}
/**
* @method private ShowTab
*   The function is used to find out what pane to show, and hide
* @param Event evt
*	window event object.
**/
function ShowTab(evt)
{
  var reqTab       = "";
  var ctrlName     = "";

  if (evt) //Mozilla???
  {
    reqTab       = evt.currentTarget.name;
    ctrlName     = evt.currentTarget.id;
  }
  else
  {
    reqTab       = event.srcElement.name;
    ctrlName     = event.srcElement.id;
  }

  var obj     = eval(ctrlName);


  var theme_class  = "display_" + obj.theme;
  var theme_buttonSel = "tabButtonSel_" + obj.theme;
  var theme_button = "tabButton_" + obj.theme;

  for(var i=1; i < obj.TabArray.length; i++)
  {
    if ( i == reqTab )
    {
      obj.TabArray[i][0].className = theme_class;
      obj.ButtonArray[i].className = theme_buttonSel;
    }
    else
    {
      obj.TabArray[i][0].className = "hide";
      obj.ButtonArray[i].className = theme_button;
    }

  }
  obj.selectedTab = reqTab;
  if (obj.onactivatepage != null)
	obj.onactivatepage();
}

/**
* @method public updateControl
*   This function integrate all the different parts and display the whole final tab panel.
* 	first, if tab has buttons, then need to create the tab buttons.
* 	second, add all the panels to the tab.
* 	third, if tab has navigation buttons, then need to construct the navigation buttons.(previous, next, finish)
**/
function updateControl()
{
  var theme_class = "container_" + this.theme;
  this.containerDiv.className    = theme_class;
  this.containerDiv.style.height = this.height;
  this.containerDiv.style.width  = this.width;

  var theme_class = "tabButton_" + this.theme;

  var buttonDiv = document.createElement("DIV");

  var tabTable  = document.createElement("table");
  var tabRow    = tabTable.insertRow(0);
  //var tabRow    = document.createElement("<tr>");
  //tabTable.appendChild(tabRow);

  for(var i=1; i < this.TabArray.length; i++)
  {
    var tabCell  = tabRow.insertCell(i-1);
	//var tabCell  = document.createElement("<td>");
	//tabRow.appendChild(tabCell);

    var tabButton = document.createElement("INPUT");
    tabButton.type = 'BUTTON';
    tabButton.value = this.TabArray[i][1];
    tabButton.name = i;
    tabButton.id   = this.Name;
    tabButton.className = theme_class;
	tabButton.onclick = ShowTab;

    this.ButtonArray[i] = tabButton;

    //tabCell.insertBefore(tabButton);
	tabCell.appendChild(tabButton);

  }

  //buttonDiv.insertBefore(tabTable);
  buttonDiv.appendChild(tabTable);

  //this.containerDiv.insertBefore(buttonDiv);
  this.containerDiv.appendChild(buttonDiv);

  theme_class = "display_" + this.theme;

  for(var i=1; i < this.TabArray.length; i++)
  {
    var divObj = this.TabArray[i][0];
    divObj.style.width  = this.width - 6;
    divObj.style.height = this.height - 38;
    divObj.style.position = 'relative';
    divObj.style.left  = 2;
    divObj.style.top = 5;

    //this.containerDiv.insertBefore(this.TabArray[i][0]);
    this.containerDiv.appendChild(this.TabArray[i][0]);

    if ( i == this.selectedTab )
      this.TabArray[i][0].className = theme_class;
    else
      this.TabArray[i][0].className = "hide";

  }

  return true;
}
