//==================================================================
// Licensed Materials - Property of IBM
// (c) Copyright IBM Corp. 2003.  All rights reserved.
//
// US Government Users Restricted Rights - Use, duplication or
// disclosure restricted by GSA ADP Schedule Contract with IBM
// Corp.
//
// DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
// sample code created by IBM Corporation.  This sample code is
// not part of any standard or IBM product and is provided to you
// solely for the purpose of assisting you in the development of
// your applications.  The code is provided "AS IS", without
// warranty of any kind.  IBM shall not be liable for any damages
// arising out of your use of the sample code, even if they have
// been advised of the possibility of such damages.
//==================================================================

/**
  * @class public SelectAndActivateEventHandler
  * @constructor SelectAndActivateEventHandler
  *    Generic event handler that responds to a selection event in a control, and activates a corresponding
  *    dataset in one or more target controls.
  *   The interface can be one of the following 4 situation.<br>
  * 1. User can select one target using target id drop-down list, and can leave reference name blank.<br>
  * 	SelectAndActivateEventHandler(thisEvent, [ODCRegistry.getClientAdapter('a1')]);<br>
  * 2. User can select one target using target id drop-down list, and one reference name.<br>
  *  	SelectAndActivateEventHandler(thisEvent, [[ODCRegistry.getClientAdapter('a1'), 'refName']]);<br>
  * 3. User can select multiple targets using target id drop-down list, and can leave reference name blank.<br>
  *    SelectAndActivateEventHandler(thisEvent, ODCRegistry.getClientAdapters([['target1',null], ['target2',null], ['target3','null']]));<br>
  * 4. User can select multiple targets using target id drop-down list, and can specify a reference name.<br>
  *   SelectAndActivateEventHandler(thisEvent, ODCRegistry.getClientAdapters([['target1',null], ['target2',null], ['target3','null']]), "refName");<br>
  * @param Object event
  * 	The event object from the event handler
  * @param Array adapterArray
  *		This is the array of target adapters
  * @param String referenceName
  *		This couldn't be null, if not, see the above description.
 **/
function SelectAndActivateEventHandler(event, adapterArray, referenceName)
 {

		var eobj = event.eobject;
		var propertyname = event.propertyName;

  	   try
     		{
    		   if (null != eobj)
     		   {
					if(referenceName)
					{

						//case 4
						var eobj1 = eobj;
						eobj1 = getEobjectFromFeatureName(eobj, referenceName);

						for(var i=0; i<adapterArray.length; i++)
						{
							adapterArray[i].activateDataSet(eobj1);
							adapterArray[i].refresh();
						}

					}else{


						for (var i = 0; i < adapterArray.length; ++i)
          				{
							var adapterArri = adapterArray[i];
							if(adapterArri.length!=null){
								//case 2

								//fix bug when the first target adapter is binder adapter, rest of them are datagrid, graphdraw etc.
								var eobj1 = eobj;

								eobj1 = getEobjectFromFeatureName(eobj, adapterArri[1]);


								adapterArri[0].activateDataSet(eobj1);
								adapterArri[0].refresh();

							}else{
								//case 1 or 3

             					adapterArri.activateDataSet(eobj);
             					adapterArri.refresh();
							}

          				 }
					}
     			    return true;
			     }

   	   }
      catch (e)
	      {
     		  return false;
   	   }

 }



/**
  * @method public getEobjectFromFeatureName
  *    The function is used to get the right eobject in some special cases in selectandactivehandler and selectandsethandler,
  *	like the source efeatureis "["Usr.Portfolios[0].Positions[0].Stock.Symbol", "_26", "Symbol"]".
  * @parameter EObject eobj
  *    parent eobject
  * @parameter String featureName
  *	   The efeature name which is used to get the eobject.
 **/
 function getEobjectFromFeatureName(eobj,featureName)
 {

		if(featureName.indexOf(".")!=-1){

			var	srcFeatureArray = featureName.split(".");


			if(srcFeatureArray!=null)
			{

				for(var j=0; j<srcFeatureArray.length-1; j++)
				{
					eobj = getEobjectInternal(eobj, srcFeatureArray[j]);

				}
			}
		}else {

			eobj = getEobjectInternal(eobj, featureName);


		}

	return eobj;

 }



 function getEobjectInternal(eobj, featureName)
 {
		var tempIndex = featureName.indexOf("[");
		if(tempIndex!=-1)
		{


			var tempFeatureName = featureName.substring(0,tempIndex);
			var index = featureName.substring(tempIndex+1, featureName.length-1);

			var returnObjArr = eobj.eGet(tempFeatureName);
			if(returnObjArr)
				eobj= returnObjArr[Number(index)];
			else
				eobj = null;

		}else{
			eobj = eobj.eGet(featureName);

		}
		return eobj;

 }





/**
  * @class public SelectAndSetEventHandler
  * @constructor SelectAndSetEventHandler
  *    The constructor initializes the handler's internal data structures based on the parameters passed.
  *    Generic event handler that responds to a selection event in a control, and copies data from the selected item
  *   to target controls which can accept the data corresponding to a single attribute.
  *   It can handler five cases:
  *	  Take portofolio data model as example,<br>
  *		1. source EFeatureName is null,  target EFeatureName is not null, like,<br>
  *		   sourceObj is a stock obj, and the eobj id is the root xmi id and target EFeaturename is "PlaceHolderStock".<br>
  *		2. source EfeatureName is not null, so as targetEFeatureName, they are all eattribute.<br>
  *	       sourceObj is "position", source eattributeName is "Symbol", and the eobj id is the xmi id of "PlaceHolderStock" eobject, target eattributeName is "Symbol",<br>
  *		3. source EFeatureName is not null, so as targetEfeatureName, they are all ereference.<br>
  *		   sourceObj is  "Position", source ereferencename is "Stock", eobj id is root xmi id, and target ereferencename is "PlaceHolderStock".<br>
  *		4. source EFeatureName is not null, but targetEfeaturename is null.<br>
  *	       sourceObj is "Position", source ereferencename is "Stock", eobj id is the xmi id of the "PlaceHolderStock" eobject.<br>
  *		5. source EFeatureName is null and targetEFeatureName is nll.<br>
  *		   sourceObj is "Stock" and eobj id is the xmi id of the "PlaceHolderStock" eobject.<br>
  * @parameter String typeActivate
  *    The EClass type for which the event should be active for. for instance, in a Tree, different nodes might map to
  *   different types, and you only want a particular event to be triggered for a particular type
  * @parameter ControlMetaData[] ControlMetaDataArray
  *    An array of triplets including<BR>
  * &nbsp;&nbsp;&nbsp;- String srcEFeatureName: The source efeature Name
  * &nbsp;&nbsp;&nbsp;- String TargetEObjectID: The eobject id of the target object
  * &nbsp;&nbsp;&nbsp;- String targetEFeatureName: The efeature name of the target eobject
 **/
function SelectAndSetEventHandler(event, ControlMetaDataArray)
 {

	var eobj = event.eobject;
	var propertyname = event.propertyName;
	var model = event.model;



    try
  {
     if (null != eobj)
     {



			 for (var i = 0; i < ControlMetaDataArray.length; ++i)
			 {

				 var eobj1 = eobj;
				 var controlMDArri = ControlMetaDataArray[i];

				//add one more logic to handle source eFeature is something like "["Usr.Portfolios[0].Positions[0].Stock.Symbol", "_26", "Symbol"]".
				if(controlMDArri[0]!=null&&controlMDArri[0].indexOf(".")>-1){

					eobj1 = getEobjectFromFeatureName(eobj, controlMDArri[0]);

					var srcFeatureArray = controlMDArri[0].split(".");

					controlMDArri[0] = srcFeatureArray[srcFeatureArray.length-1];

				}else if(controlMDArri[0]!=null&&controlMDArri[0].indexOf("[")>-1){
					//in case the source eFeature is something like "Positions[0]"
					eobj1 = getEobjectFromFeatureName(eobj, controlMDArri[0]);
					var tempIndex = controlMDArri[0].indexOf("[");

					controlMDArri[0] = controlMDArri[0].substring(0,tempIndex);

				}


				var targetObj = (typeof(controlMDArri[1]) != "object")?findEObjectByXMIID(model, controlMDArri[1]):controlMDArri[1];

				if(controlMDArri[0] ==null&&controlMDArri[2]==null)
				{
					//case 5;
					if(eobj1.EClass.Name== targetObj.EClass.Name)
					{
						for (var k = 0; k < eobj1.Members.length; ++k) {
						//	var member = targetObj.AddMember(returnObjs.Members[k].Name,returnObjs.Members[k].EStructuralFeature);
							if (eobj1.Members[k].EStructuralFeature.CLASSTYPE != EStructuralFeature.CLASSTYPE_EATTRIBUTECALCULATE){
							//if (eobj1.Members[k].EStructuralFeature.CLASSTYPE != "EAttributeCalculate"){

								targetObj.eSet(eobj1.Members[k].Name,eobj1.eGet(eobj1.Members[k].Name));
							}
						}


					}

			   }else if(controlMDArri[0] == null&&controlMDArri[2]!=null)
			   {
				   //case 1:
				   var targetEference = targetObj.eGet(controlMDArri[2]);
				   if(targetEference!=null && targetEference.EClass.Name == eobj1.EClass.Name)
				   {

						for (var k = 0; k < eobj1.Members.length; ++k) {
						//	var member = targetObj.AddMember(returnObjs.Members[k].Name,returnObjs.Members[k].EStructuralFeature);
							if (eobj1.Members[k].EStructuralFeature.CLASSTYPE != EStructuralFeature.CLASSTYPE_EATTRIBUTECALCULATE){
							//if (eobj1.Members[k].EStructuralFeature.CLASSTYPE != "EAttributeCalculate"){

								targetEference.eSet(eobj1.Members[k].Name,eobj1.eGet(eobj1.Members[k].Name));
							}
						}


				   }


			   }else if(controlMDArri[0] != null&&controlMDArri[2]==null)
			   {
				   //case 4:
				   var sourceObj = eobj1.eGet(controlMDArri[0]);
				   if(sourceObj.length==null)
				   {
						for (var k = 0; k < sourceObj.Members.length; ++k) {
						//	var member = targetObj.AddMember(returnObjs.Members[k].Name,returnObjs.Members[k].EStructuralFeature);
							if (sourceObj.Members[k].EStructuralFeature.CLASSTYPE != EStructuralFeature.CLASSTYPE_EATTRIBUTECALCULATE){
							//if (sourceObj.Members[k].EStructuralFeature.CLASSTYPE != "EAttributeCalculate"){

								targetObj.eSet(sourceObj.Members[k].Name,sourceObj.eGet(sourceObj.Members[k].Name));
							}
						}

				   }else{
					   		//multiple eobjects return, like portfolio has mutilple position, don't handle it now.
							//ereference is null;
					   return;
				   }

			   }else if(controlMDArri[0] != null&&controlMDArri[2]!=null)
			   {
				   //case 2 and 3:

				    var targetEference = targetObj.eGet(controlMDArri[2]);

					for (var j = 0; j < eobj1.Members.length; ++j)
						{
							if(eobj1.Members[j].Name == controlMDArri[0]){
									if (eobj1.Members[j].EStructuralFeature.CLASSTYPE == EStructuralFeature.CLASSTYPE_EREFERENCE)
									//if (eobj1.Members[j].EStructuralFeature.CLASSTYPE == "EReference")
									{

										//copy erefernce, can't new EObject since id is changed.
											//targetObj = null;
											//targetObj = new EObject(eobj.Members[j].Value.EClass);


											var returnObjs = eobj1.eGet(controlMDArri[0]);

											if(returnObjs.length ==null){
												//check if they are the same type
												if(returnObjs.EClass.Name == targetEference.EClass.Name){


													for (var k = 0; k < returnObjs.Members.length; ++k) {
													//	var member = targetObj.AddMember(returnObjs.Members[k].Name,returnObjs.Members[k].EStructuralFeature);
														if (returnObjs.Members[k].EStructuralFeature.CLASSTYPE != EStructuralFeature.CLASSTYPE_EATTRIBUTECALCULATE){
													//	if (returnObjs.Members[k].EStructuralFeature.CLASSTYPE != "EAttributeCalculate"){

															targetEference.eSet(returnObjs.Members[k].Name,returnObjs.eGet(returnObjs.Members[k].Name));
														}
													}
												}

											}else{
												//multiple eobjects return, like portfolio has mutilple position, don't handle it now.
												//ereference is null;

												return;
											}



									}else
									{// copy eattribute


										targetObj.eSet(controlMDArri[2],eobj1.eGet(controlMDArri[0]));

									}

									break;
								}//if(eobj.Members[j].Name == ControlMetaDataArray[i][0]){

						}//for(var j = 0; j < eobj.Members.length; ++j)

			   		}
				}//forvar i = 0; i < ControlMetaDataArray.length; ++i)

     }//if(null != eobj)
	return true;

  } catch (e)
  {

    return false;
  }

}

/**
  * @class public FormSubmitHandler
  * @constructor FormSubmitHandler
  *    The constructor initializes the handler's internal data structures based on the parameters passed
  *    Generic event handler that responds to submit a form which right now mainly used to submit diffgram
  * @param String      formId
  * @return boolean true if form submission is successful.
  * @exception EObjectError
  *   An exception will be thrown if formId is null or form is not found using formId.
**/

 function FormSubmitHandler(formId)
 {
	 this._formId = formId;

	 this.handle = function ()
	 {

		ODCPageControl.saveAllToForm(this._formId, null);
		//eval(this._formName).submit();
	   var Form = null;
      if(this._formId != null)
      {
         Form = document.getElementById(this._formId);
         if(Form == null)
         {
            //alert("No form id is specified !");
            var args = new Array;
			   args[0] = this._formId;
            var Msg = NlsFormatMsg(form_name_notfound, args);
			   Log.error("genericEventHandler FormSubmitHandler.handle()", Msg);

			   throw new EObjectError(Msg);
         }
      }
      else
      {
         //alert("No form id is found !");
         var args = new Array;
			args[0] = "FormSubmitHandler.handle()";
         var Msg = NlsFormatMsg(formId_notexist, args);
			Log.error("genericEventHandler FormSubmitHandler.handle()", Msg);

			throw new EObjectError(Msg);

      }
      Form.submit();

      return true;

  	 }
 }



 function Select(clientId, model, mapArray, targetEObjectID, targetEReference){
	this.clientId = clientId;
	this.model = model;
	this.mapArray = mapArray;
	this.targetEObjectID = targetEObjectID;
	this.targetEObject = findEObjectByXMIID(this.model, this.targetEObjectID);
	this.targetEReference = targetEReference;
	this.value = null;
	this.eventHandler = null;
	this.element = document.getElementById(this.clientId);
	if(this.element){
		if(this.element.tagName.toLowerCase() == "select"){
			this.type = Select.SELECT;
			if(this.element.attachEvent){
				this.element.attachEvent("onchange", this.handleSelect);
			}
			else{
				this.element.addEventListener("change", this.handleSelect, false);
			}
			this.element.selectControl = this;
		}
		else{
			this.controlsArray = this.findControlsArray(this.clientId);
			if(this.controlsArray && this.controlsArray.length > 0){
				if(this.controlsArray[0].type == "radio"){
					this.type = Select.RADIO;
					this.addEventListener(this.handleRadio);
				}
				else if(this.controlsArray[0].type == "checkbox"){
					this.type = Select.CHECKBOX;
					this.addEventListener(this.handleCheckbox);
				}
			}
		}
	}

}

//some constants for internal use
Select.SELECT = "select";
Select.CHECKBOX = "checkbox";
Select.RADIO = "radio";
Select.EVENT = "onchange";

Select.prototype.fireEvent = function(eventName){
	if(eventName && eventName.toLowerCase() == Select.EVENT){
		this.onchange();
	}
}

Select.prototype.attachEvent = function(eventName, eventHandler){
	if(eventName && eventName.toLowerCase() == Select.EVENT && eventHandler){
		this.eventHandler = eventHandler;
		this.event = new Object();
		this.event.srcElement = this;
	}
}

Select.prototype.onchange = function(){
	if(this.type == Select.SELECT){
		if(this.value){
			//FIXME unshift is wrong
			var valueArray = new Array();
			if(typeof(value) == "string"){
				valueArray.unshift(this.value);
			}
			else{
				valueArray = this.value;
			}
			var options = this.element.options;
  			for(var i=0; i<options.length; i++){
  				var selected = false;
  				for(var j=0; j<valueArray.length; j++){
  					if(options[i].value == valueArray[j]){
  						options[i].selected = true;
  						selected = true;
  					}
  				}
  				if(!selected){
  					options[i].selected = false;
  				}
  			}
		}
	}
	else if(this.type == Select.CHECKBOX || this.type == Select.RADIO){
		if(this.value && this.controlsArray){
			var selectedArray = new Array();
			if(typeof(value) == "string"){
				selectedArray.unshift(value);
			}
			else{
				selectedArray = this.value;
			}
  			for(var i=0; i<this.controlsArray.length; i++){
  				var selected = false;
  				for(var j=0; j<selectedArray.length; j++){
  					if(this.controlsArray[i].value == selectedArray[j]){
  						this.controlsArray[i].checked = true;
  						selected = true;
  					}
  				}
  				if(!selected){
  					this.controlsArray[i].checked = false;
  				}
  			}
		}
	}
}

Select.prototype.findControlsArray = function(groupName){
  	var nodeArray = document.getElementsByTagName('input');
	var controlArray = new Array();
  	for(var i = 0; i < nodeArray.length; i++){
		if(nodeArray[i].getAttribute('name') == groupName){
			controlArray.push(nodeArray[i]);
		}
	}
	return controlArray;
}

Select.prototype.handleSelect = function(){
	var element = this.event.srcElement ? this.event.srcElement : this.event.target;
	if(element.multiple){
		var optionsArray = element.options;
		var selectedIndices = new Array();
		for(var i=0; i<optionsArray.length; i++){
			var option = optionsArray[i];
			if(option.selected){
				selectedIndices.push(i);
			}
		}
		var objectArray = new Array();
		for(var k =0; k < selectedIndices.length; k++){
			 var indexObject = findEObjectByXMIID(element.selectControl.model, element.selectControl.mapArray[selectedIndices[k]]);
			 objectArray.push(indexObject.eGet("value"));
		}
		element.selectControl.targetEObject.eSet(element.selectControl.targetEReference, objectArray);
	}
	else{
		var sourceObject = findEObjectByXMIID(element.selectControl.model, element.selectControl.mapArray[element.selectedIndex]);
		element.selectControl.targetEObject.eSet(element.selectControl.targetEReference, sourceObject.eGet("value"));
	}
}

Select.prototype.handleRadio = function(){
	var control = this.event.srcElement ? this.event.srcElement.selectControl : this.event.target.selectControl;
	var targetIndex = -1;
	for(var i = 0; i < control.controlsArray.length; i++)
	{
		if(control.controlsArray[i].checked){
			targetIndex = i;
		}
	}
	var sourceObject = findEObjectByXMIID(control.model, control.mapArray[targetIndex]);
	if(targetIndex == -1)
		control.targetEObject.eSet(control.targetEReference, control.targetEObject.eGet("value"));
	else
		control.targetEObject.eSet(control.targetEReference, sourceObject.eGet("value"));
}

Select.prototype.handleCheckbox = function(){
	var control = this.event.srcElement ? this.event.srcElement.selectControl : this.event.target.selectControl;
	var objectArray = new Array();
		for(var i = 0; i < control.controlsArray.length; i++){
			var checkboxControl = control.controlsArray[i];
			if(checkboxControl.checked){
				var indexObject = findEObjectByXMIID(control.model, control.mapArray[i]);
				objectArray.push(indexObject.eGet("value"));
			}
		}
	control.targetEObject.eSet(control.targetEReference, objectArray);
}

Select.prototype.addEventListener = function(func){
	if(this.controlsArray && this.controlsArray.length > 0){
		for(var i=0; i<this.controlsArray.length; i++){
			if(this.controlsArray[0].attachEvent){
				this.controlsArray[i].attachEvent("onclick", func);
			}
			else{
				this.controlsArray[i].addEventListener("click", func, false);
			}
			this.controlsArray[i].selectControl = this;
		}
	}
}