//==================================================================
// Licensed Materials - Property of IBM
// (c) Copyright IBM Corp. 2003.  All rights reserved.
//
// US Government Users Restricted Rights - Use, duplication or
// disclosure restricted by GSA ADP Schedule Contract with IBM
// Corp.
//
// DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
// sample code created by IBM Corporation.  This sample code is
// not part of any standard or IBM product and is provided to you
// solely for the purpose of assisting you in the development of
// your applications.  The code is provided "AS IS", without
// warranty of any kind.  IBM shall not be liable for any damages
// arising out of your use of the sample code, even if they have
// been advised of the possibility of such damages.
//==================================================================


//==================================================================
// Usage:
// 1.Construct currency object:
// 	var currencyValue = new currency("1234.56_USD");
// 2. Call
// currencyValue.toString() to output the currency object in string
// currencyValue.multiply(/*number like integer or float*/value) to output
// 						 amount of currency object multiply the quantity
// currencyValue.divide(/*number like integer or float*/value) to output
// 						 amount of currency object divided by the quantity
// currencyValue.add(/*currency object*/value) to add the amount of two
//					currency object. if currency code is different,throw exception
// currencyValue.substract(/*currency object*/value) to substract the amount of second
//					currency object. if currency code is different,throw exception
// ==================================================================
function currency(value)
{

	this.currencyDesc = value.split("_")[1];
	this.currencyAmount = value.split("_")[0];

	this.multiply = function(quantity)
	{
		var result = this.currencyAmount*quantity;

		return new String(result+"_"+this.currencyDesc);

	}

	this.divide = function(quantity)
	{
		var result = this.currencyAmount/quantity;
		return new String(result+"_"+this.currencyDesc);

	}

	this.add = function(secondCur)
	{

		if(this.currencyDesc != secondCur.currencyDesc)
		{
			var args = new Array;
			args[0] = this.currencyDesc;
			args[1] = secondCur.currencyDesc;
			var Msg = NlsFormatMsg(add_mismatch_currencycode, args);
			Log.error("currency.add", Msg);
			throw new NLSServiceError(Msg);

		}else{
			var result = Number(this.currencyAmount) + Number(secondCur.currencyAmount);
			return new String(result+"_"+this.currencyDesc);
		}
	}

	this.subtract = function(secondCur)
	{
		if(this.currencyDesc != secondCur.currencyDesc)
		{
			var args = new Array;
			args[0] = this.currencyDesc;
			args[1] = secondCur.currencyDesc;
			var Msg = NlsFormatMsg(subtract_mismatch_currencycode, args);
			Log.error("currency.subtract", Msg);


			throw new NLSServiceError(Msg);

		}else{
			var result = Number(this.currencyAmount) - Number(secondCur.currencyAmount);
			return new String(result+"_"+this.currencyDesc);
		}


	}

	this.toString = function()
	{
			return (this.currencyAmount + "_" + this.currencyDesc);
	}

}