//==================================================================
// Licensed Materials - Property of IBM
// (c) Copyright IBM Corp. 2003.  All rights reserved.
//
// US Government Users Restricted Rights - Use, duplication or
// disclosure restricted by GSA ADP Schedule Contract with IBM
// Corp.
//
// DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
// sample code created by IBM Corporation.  This sample code is
// not part of any standard or IBM product and is provided to you
// solely for the purpose of assisting you in the development of
// your applications.  The code is provided "AS IS", without
// warranty of any kind.  IBM shall not be liable for any damages
// arising out of your use of the sample code, even if they have
// been advised of the possibility of such damages.
//==================================================================

var GlobalID = 0;
var G_ModelLoader = null;

/**
* @method public NewID
* 	This method is used to generate a unique ID for an eobject.
* @return String
*	Returns new generated eobject ID.
**/
function NewID()
{
	return "genid_" + ++GlobalID;
}
/**
* @method public isBoolean
* 	This method is used to detect the passed in value is a boolean or not
* @param object obj
*	the value which is need to be checked.
* @return boolean
*	true if the value is boolean, otherwise false;
**/
function isBoolean(obj)
{
	if(typeof obj == 'boolean')
	{
		return true;
	}

	return false;
}


/**
* @method private CompareXMIId
* 	This function will be executed on every node (every eobject) with two parameters
*  (eobject and criteria) passed in.
* @param EObject anEobject
*	a root eobject containing many children
* @param String aXMIId
*	The aXMIId of an eobject
* @return Boolean
*	Returns true if the eobject's XMIId matches with the input XMIId.  Otherwise return false
**/
function CompareXMIId(anEobject, aXMIId)
{
	if(anEobject.ID == aXMIId)
	{
		return true ;
	}

	return false;
}



/**
* @method public findEObjectByXMIID
* 	This function is used for finding an eobject by a given XMI ID.
* @param EObject eobject
*	a root eobject containing many children
* @param String xmiID
*	an XMI ID generated by ODC export utility
* @return EObject
*	Returns targetObj an eobject whose XMIID matches with the input xmiID
**/
function findEObjectByXMIID(eobject, xmiID)
{
//DEL 	Profile.Start("<Global>", "findEObjectByXMIID");	// Debug

	 //Reset this array
	var objects = new Array();
	//var targetObj = findEObjectByXMIIDInternal(eobject, xmiID, objects);
	var targetObj = traverseGraph(eobject, xmiID, objects, CompareXMIId);

//DEL 	Profile.End("<Global>", "findEObjectByXMIID");	// Debug

	return targetObj;
}


/**
* @method private CompareAtrNameValue
* 	This function will be executed on every node (every eobject) with two parameters
*  (eobject and criteria) passed in.
* @param EObject anEobject
*	a root eobject containing many children
* @param String value
*	The value of an attribute of eobject
* @param String name
*	The name of an attribute of eobject
* @return Boolean
*	Returns true if the eobject's XMIId matches with the input XMIId.  Otherwise return false
**/
function CompareAtrNameValue(anEobject, value, name)
{
	if(anEobject.eGet(name) == value)
	{
		return true ;
	}

	return false;
}



/**
* @method public findEObjectByAtrName
* 	This function is used for finding an eobject by a given XMI ID.
* @param EObject eobject
*	a root eobject containing many children
* @param String atrName
*	The name of an attribute of eobject
* @param String atrValue
*	The value of an attribute of eobject
* @return EObject
*	Returns targetObj an eobject whose XMIID matches with the input xmiID
**/
function findEObjectByAtrName(eobject, atrName, atrValue)
{
//DEL 	Profile.Start("<Global>", "findEObjectByXMIID");	// Debug

	 //Reset this array
	var objects = new Array();
	//var targetObj = findEObjectByXMIIDInternal(eobject, xmiID, objects);
	var targetObj = traverseGraph(eobject, atrValue, objects, CompareAtrNameValue, atrName);

//DEL 	Profile.End("<Global>", "findEObjectByXMIID");	// Debug

	return targetObj;
}


/**
* @method private CompareXMIId
* 	This function will be executed on every node (every eobject) with two parameters
*  (eobject and criteria) passed in.
* @param EObject anEobject
*	a root eobject containing many children
* @param String aSignature
*	The signature of an eobject
* @return Boolean
*	Returns true if the eobject's signature matches with the input signature.  Otherwise return false
**/
function CompareSignature(anEobject, aSignature)
{
//DEL 	Profile.Start("<Global>", "CompareSignature");	// Debug

	var res = (anEobject.getSignature() == aSignature);

//DEL 	Profile.End("<Global>", "CompareSignature");	// Debug

	return res;
}

/**
* @method public findEObjectBySignature
* 	This function is used for finding an eobject by a given signature.
* @param EObject eobject
*	a root eobject containing many children
* @param String aSignature
*	The signature of an eobject
* @return EObject
*	Returns targetObj an eobject whose signature matches with the input signature
**/
function findEObjectBySignature(eobject, aSignature)
{
//DEL 	Profile.Start("<Global>", "findEObjectBySignature");	// Debug

	 //Reset this array
	var objects = new Array();
	var targetObj = traverseGraph(eobject, aSignature, objects, CompareSignature);

//DEL 	Profile.End("<Global>", "findEObjectBySignature");	// Debug

	return targetObj;
}


/**
* @method public findEObjectByVBL
* 	This function is used for finding an eobject by a given vblExpression and an optional model name.
* @param String vblExpression
*	a VBL expression of Client model, such as root.users[0].portfolios[0].positions[0]
* @param String modelName
*	an model name, optional. If this is supplied, it will be used to get the model object from the client-side registry.
* @return EObject
*	Returns EObject an eobject which is retrieved  using an VBL expression
**/
function findEObjectByVBL(vblExpression, modelName)
{

   //alert("begin findEObjectByVBL()");
   var targetObj = null;
   //Get model object first
   var xmlHandler = null;

   //add code to strip out {# } from vblExpression
   var index = vblExpression.indexOf("#{");
   if(index != -1)
   {
      vblExpression = vblExpression.substring(2);
   }

   var rightBraceIndex = vblExpression.indexOf("}");
   if(rightBraceIndex != -1)
   {
      vblExpression = vblExpression.substring(0, rightBraceIndex)
   }
   //fenil change
	//now the vbl expression has been stripped of the #{..remove the sc_
	//no stripping the sc_ now
	//vblExpression = vblExpression.replace(/^sc_[^\.]*\./,"");


	var modelNames = ODCRegistry.getModelNames();
   //if modelName is suppied, use it to retrieve the model obj
   if(modelName != null && modelName != "")
   {
      //xmlHandler = ODCPageControl._Controls[modelName];
      xmlHandler = ODCRegistry.Models[modelName];
      for(var key in modelNames){
      	var modName = modelNames[key];
      	if(modName == modelName){
      		vblExpression  = vblExpression.substring(key.length, vblExpression.length);
      	}
      	break;
      }

   }
   else
   {
      //get the model name  from VBL
      // This logic needs to be changed to match the java logic
      //var modelNameFromVBL = refArray[0]
      //var tempIndex = refArray[0].indexOf("[");
      //if(tempIndex!=-1)
      //{
       //  modelNameFromVBL = modelNameFromVBL.substring(0,tempIndex);
      //}


		var index = -1;
		var matchedKey = null;
		for(var key in modelNames){
			var tempIndex  = -1;
			if(vblExpression.indexOf(key) == 0){
				tempIndex = key.length-1;
			}
			if(tempIndex > index){
				index = tempIndex;
				matchedKey = key;
			}
		}
		var modelNameFromVBL = modelNames[matchedKey];
		//remove the matched key from the VBL
		vblExpression = vblExpression.substring(index+1, vblExpression.length);


      //hard-coded now
      //need new registry to register model using its model name as key
      //xmlHandler = ODCPageControl._Models[0][1];
      xmlHandler = ODCRegistry.Models[modelNameFromVBL];

   }

   var root = xmlHandler.Root;
   var rootRefName = xmlHandler.RootMemberName;
   vblExpression = rootRefName + vblExpression;
   var eobj = root;

   var refArray = vblExpression.split(".");
   //need checking to make sure that it is a ref
   if(refArray!=null)
   {
       //Loop thru the whole expression
      for(var j=0; j<refArray.length; j++)
      {

         var refName = refArray[j];
         var tempIndex = refName.indexOf("[");
         if(tempIndex!=-1)
         {


            refName = refName.substring(0,tempIndex);
            //Root ref name is not set following  convention, and it is set by WDO code using Class name, such as Root, instead of root
            //So we have to replace it with the one from XMIHandler
            //if(j==0)
            //{
            //   refName = rootRefName;
            //}

            var index = refArray[j].substring(tempIndex+1, refArray[j].length-1);

            var returnObjArr = eobj.eGet(refName);

            eobj = returnObjArr[Number(index)];

         }
         else
         {
            //Root ref name is not set following  convention, and it is set by WDO code using Class name, such as Root, instead of root
            //So we have to replace it with the one from XMIHandler
            //if(j==0)
            //{
             //  refName = rootRefName;
            //}
            var tempObj = eobj.eGet(refName);

            //Root object is stored as an array, not as a single object because of eAdd() is called at model output time
            //This may have to change
            if(j==0)
            {
               eobj= tempObj[0];
            }
            else
            {
               eobj = tempObj;
            }

         }

      }
   }
   targetObj = eobj;
   return targetObj;
}


/**
* @method public traverseGraph
* 	This generic function is used to recursively search for an eobject by a given visitor and  search criteria.
* @param EObject eobject
*	a root eobject containing many children
* @param String criteria
*	The criteria for our search
* @param Array objects
* 	an array to keep track of objects which have been traversed
* @param visitor
* 	a JavaScript function defined provided by an application.  This function will be executed on every node (every eobject) with two parameters
*  (eobject and criteria) passed in.
*  its execution.
* @return EObject
*	Returns targetObj an eobject whose XMIID matches with the input xmiID
**/

function traverseGraph(eobject, criteria, objects, visitor, atrname)
{
//DEL 	Profile.Start("<Global>", "traverseGraph");	// Debug

	var targetObj = null;

	if (
		null == eobject
		|| "object" != typeof(eobject)
	)
	{
//DEL 		Profile.End("<Global>", "traverseGraph");	// Debug

		return null;
	}

	//we have a match
	//if (eobject.ID == xmiID)
	if(visitor(eobject, criteria,atrname))
	{
		targetObj = eobject;

//DEL 		Profile.End("<Global>", "traverseGraph");	// Debug

		return  targetObj;
	}

	for (var i = 0; i < objects.length; ++i)
	{
		// object already searched
		if (eobject == objects[i])
		{
//DEL 			Profile.End("<Global>", "traverseGraph");	// Debug

			return targetObj;
		}
	}
	objects[objects.length] = eobject;


	for (var i = 0; i < eobject.Members.length; ++i)
	{
		//Attributes do not need to be processed here
		//So we only need to look into references.
		if ( eobject.Members[i].EStructuralFeature.CLASSTYPE & (EStructuralFeature.CLASSTYPE_EATTRIBUTE | EStructuralFeature.CLASSTYPE_EATTRIBUTECALCULATE) != 0)
		{
			continue;
		}

		var name = eobject.Members[i].Name;
		var value = eobject.eGet(name);
		if (null == value)
		{
			continue;
		}

		//if it is an ERerenece
		if ("object" == typeof(value))
		{
			//if it is an array
			if (value.length != null && "number" == typeof(value.length))
			{
				//loop thru all references
				for (var j = 0; j < value.length; ++j)
				{
					//if it is an object and we have a match
					//if ("object" == typeof(value[j]) && value[j].ID == xmiID)
					if ("object" == typeof(value[j]) && visitor(value[j], criteria,atrname))
					{
						targetObj =  value[j];

//DEL 						Profile.End("<Global>", "traverseGraph");	// Debug

						return targetObj;
					}
					else
					{
						var targetObj = traverseGraph(value[j], criteria, objects, visitor,atrname);
						//We have a match and return
						if (targetObj != null)
						{
//DEL 							Profile.End("<Global>", "traverseGraph");	// Debug

							return targetObj;
						}
					}
				}// inner loop
			}
			else //single eobject
			{
				//if it is an object and we have a match
				//if ("object" == typeof(value) && value.ID == xmiID)
				if (visitor(value, criteria,atrname))
				{
					targetObj = value;

//DEL 					Profile.End("<Global>", "traverseGraph");	// Debug

					return  targetObj;
				}
				else
				{
					var targetObj = traverseGraph(value, criteria, objects, visitor,atrname);
					//We have a match and return
					if (targetObj != null)
					{
//DEL 						Profile.End("<Global>", "traverseGraph");	// Debug

						return targetObj;
					}
				}

			}

		}//if
	}//outer loop

//DEL 	Profile.End("<Global>", "traverseGraph");	// Debug

	return targetObj;
}

/**
* @method Public mergeData
*    Method to merge an eobject or an array of eobjects of the same type to an existing WDO4JS model.
*    This method is used as a public method to start this process and this method will call a private
*    method: mergeInternal() to recursively traverse through the graph.
* @param eobject newData
*    An eobject or an array of eobjects of the same type.
* @param eobject parentEObj
*    An eobject into which new data will be merged.
* @param String refName
*    The eReference name for parentEObj and newData will be merged into.
* @exception EObjectError
*    An exception will be thrown if refName provided is not a ERference for parentEObj.
**/

function mergeData(newData, parentEObj, refName)
{
   //alert("mergeData()");
   var member = null;
   //need some checking here to make sure that the refName is indeed an eRef
   for (var i = 0; i < parentEObj.Members.length; ++i)
   {

      feature = parentEObj.Members[i].EStructuralFeature;

      //If it is a eRef
		if( parentEObj.Members[i].Name == refName)
      {
         //if( feature.CLASSTYPE != "EReference")
         if( feature.CLASSTYPE != EStructuralFeature.CLASSTYPE_EREFERENCE)
         {
   		   //throw an exception
            var args = new Array;
   		   args[0] = refName;
            args[1] = parentEObj.EClass.Name;
            var Msg = NlsFormatMsg(not_a_reference, args);
            Log.error("mergeData", Msg);
            throw new EObjectError(Msg);
         }
         else
         {
            member = parentEObj.Members[i];
            break;
         }
      }

   }

   //Reset this array to keep track which eobject has been merged
   var objects = new Array();
   mergeInternal(newData, parentEObj, member, objects);
   //alert("mergeData() end");
}

/**
* @method Private mergeInternal
*    Method to recusively walk thru all eobjects to merge them into an exsiting WDO4JS model.
*    This method will keep tracking of eobjects which have been merged.  If it has been merged, it will simply skip
*    and will  continue to process other eobjects.  This method will call a private
*    method: mergeSingleObjectToModel().
* @param eobject newData
*    An eobject or an array of eobjects of the same type.
* @param eobject parentEObj
*    An eobject into which new data will be merged.
* @param Member member
*    An Member object into which the new eobject belongs to inside the parentObj.
* @param Array objects
*    The array to keep tacking of what objects have been processed.
* @exception EObjectError
*    An exception will be thrown if ECORENS or Root eobject is null.
**/
function mergeInternal(newData, parentEObj, member, objects)
{
   //alert("mergeInternal()");
   if (newData != null)
   {

      // if  newData is a list
      if (newData.length != null && "number" == typeof(newData.length))
      {
         for (var j = 0; j < newData.length; ++j)
         {

             mergeSingleObjectToModel(newData[j], parentEObj, member, objects);
         }
      }
      //newData is a single object
      else
      {

         mergeSingleObjectToModel(newData, parentEObj, member, objects);

      }
   }

}

/**
* @method Private mergeSingleObjectToModel
*    Method to merge one single eobjectinto an exsiting WDO4JS model.
*    This method will keep tracking of eobjects which have been merged.  If it has been merged, it will simply skip.
*    This method will call two private methods: mergeObject() and insertObject(). mergeObject() method will in turn
*    recursively call mergerInternal() method.
* @param eobject newEObj
*    An new eobject to be merged.
* @param eobject parentEObj
*    An eobject into which new data will be merged.
* @param Member member
*    An Member object into which the new eobject belongs to inside the parentObj.
* @param Array objects
*    The array to keep tacking of what objects have been processed.
* @exception EObjectError
*    An exception will be thrown if ECORENS or Root eobject is null.
**/
function mergeSingleObjectToModel(newEObj, parentEObj, member, objects)
{
   //alert("mergeSingleObjectToModel() newEObj:" + newEObj.toStr() );
   for (var i = 0; i < objects.length; ++i)
   {
      // object already merged
      if (newEObj == objects[i])
      {
         return;
      }
   }

   objects[objects.length] = newEObj;

   //loop thru every old object
   oldEObjList = parentEObj.eGet(member.Name);
   //if oldEObjList is a list
   if(oldEObjList.length != null && "number" == typeof(oldEObjList.length))
   {
      var match = false;
      for(var i=0; i<oldEObjList.length; ++i)
      {
         var oldEObj =  oldEObjList[i];

         if(oldEObj && oldEObj.getSignature() == newEObj.getSignature())
         {

            mergeNewObjectWithOldObject(newEObj, oldEObj, objects);
            match = true;
            break;
         }

      }

      if(match== false)
      {
         //parentEObj.eAdd(newData[j], refName);
         insertObject(newEObj, parentEObj, member);

      }


   }
   //oldEObjList is not a list
   else
   {
      if(oldEObjList.getSignature() == newEObj.getSignature())
      {
         mergeNewObjectWithOldObject(newEObj, oldEObjList, objects);
      }
      else
      {
         //parentEObj.eAdd(newData[j], refName);
         insertObject(newEObj, parentEObj, member);

      }
   }
}
/**
* @method private mergeNewObjectWithOldObject
*    Method to merge two eobjects eAttibute by eAttribute, eReference by eReference.  For eAttibute,
*    we simply copy the vale to replace the old one except xmiid field.  For eReference, we have to
*    recursively going thru all its children by calling mergeInternal() method.
* @param eObject newEObj
*    The new eObject to contain all new values.
* @param eObject oldEObj
*    The old eObject to be updated.
* @param Array objects
*    The array to keep tacking of what objects have been processed.
**/
function mergeNewObjectWithOldObject(newEObj, oldEObj, objects)
{

   //alert("mergeNewObjectWithOldObject()");
   //loop thru all members, copy attributes, call mergeInternal() for each eReferenc
  	for (var i = 0; i < oldEObj.Members.length; ++i)
   {

      var feature = oldEObj.Members[i].EStructuralFeature;
		var member = oldEObj.Members[i];

		var name = oldEObj.Members[i].Name;

      var value = newEObj.eGet(name);

		if (null == value)
			continue;

      //If it is a eRef
      //here key fields may not need to copy either.
		//if ("object" == typeof(value) && feature.CLASSTYPE == "EReference" )
      if ("object" == typeof(value) && feature.CLASSTYPE == EStructuralFeature.CLASSTYPE_EREFERENCE)
      {
		    //recursive call
          mergeInternal(value, oldEObj, member, objects);
		}
      else if (feature.CLASSTYPE == EStructuralFeature.CLASSTYPE_EATTRIBUTECALCULATE)
      {
		   continue;
      }
       //if it is an eAttr
		else
      {
         //if is is an id field or it is part of key, we do not need to copy.
         if(feature.Type == "id" || feature.iD == true)
         {
            continue;
         }

        //testing purpose
        /*if (name == "Price")
        {
           value = value + 1000;
        }
        else if("string" == typeof(value))
        {
           value = value + "  merged";
        } */


         //oldEObj.eSet(name, value);
         oldEObj.eSet(name, value);

      }

	}
}

/**
* @method private insertObject
*    Method to help add a new eobject into its parentObject according to its cardinality.  If its cardinality is greater than 1,
*    eAdd() is used.  Otherwise, eSet() is used.
* @param eobject newEObj
*    An eobject to be added to the parentObj as a child.
* @param eobject parentObj
*    An eobject into which the new eobject will be added.
* @param Member member
*    An Member object into which the new eobject belongs to inside the parentObj.
**/
function insertObject(newEObj, parentObj, member)
{
   //alert("insertObject()");
   //#Satish: Observed "Illegal Output Parameter Mapping" JS Error if  the WebService returns
   //output of type Complex and there is no parameter mapping.
   //If the signature of two objects  is different then it used to call "eAdd()" method on that object always,
   //Which was illegal. There should be proper check for Cardinality.There was the bug in the following condition
   //which is fixed now.
   //Fixed :
   //1)Replaced the very first (if we move left to right in the following if condition)
   //OR (||) condition by AND (&&) condition.
   //2)Put rest of the remaining expression within parenthesis
   var ref = member.EStructuralFeature;
  	if (parentObj.eGet(member.Name) != null	&&
       (ref.getUpperBound() == -1		||
       ref.getUpperBound() > 1		   ||
	    (ref.getLowerBound() < ref.getUpperBound() && ref.getUpperBound() > 1))
      )
   {

	   parentObj.eAdd(member.Name, newEObj);
   }
   else
   {
	   parentObj.eSet(member.Name, newEObj);
   }
}



/**
 * @method public NlsFormatMsg
 * 	This function is used to nls format the alert or error or lable etc message
 * @param String template
 *	name of the nls message
 * @param Array args
 *	an array of parameter to replace the {0} info in nls mssage
 * @return String
 *	Returns a nls message which has all the parameters replaced by the input parameters
 **/
function NlsFormatMsg(template, args)
{
//DEL 	Profile.Start("<Global>", "NlsFormatMsg");	// Debug

	if (template == null)
	{
//DEL 		Profile.End("<Global>", "NlsFormatMsg");	// Debug

		return "";
	}

	if (args == null)
	{
//DEL 		Profile.End("<Global>", "NlsFormatMsg");	// Debug

		return template;
	}

	var result = template;
	var regExp;
	for (var i = 0; i < args.length; i++)
	{
		var match = "{" + i + "}";
		result = result.replace(match, args[i]);
	}

//DEL 	Profile.End("<Global>", "NlsFormatMsg");	// Debug

	return result;
}




/**
 * @method public checkForwardSlash
 * 	This function is used to check whether there is an ending forward slash.
 * 	If not, add one at the end of the string.  If yes, do nothing
 * @param String urlPrefix
 *	the prefix to be processed.
 * @return String
 *	Returns the string after it is processed.
 **/
function checkForwardSlash(urlPrefix)
{
	var resultUrlPrefix = urlPrefix;
	//We only process it if it is not null and not empty
	if(
		urlPrefix != null
		&& urlPrefix !=""
	)
	{
		var length = urlPrefix.length;
		var lastChar = urlPrefix.charAt(length-1);
		//If we do not found "/", or there is no slash at the end of the string
		//append one at the end.
		if(lastChar != "/")
		{
			resultUrlPrefix = resultUrlPrefix + "/";
		}
	}
	else
	{
		//make it as an empty string
		resultUrlPrefix ="";
	}

	return resultUrlPrefix;
}


/**
 * @method public escapeSpecialChars
 * 	This function is used to escape special characters in a string,
 * 	such as ',", and \. It will check whether escaping has been done before
 * 	escape a character.  For example, if we see a \, we will check if we have
 * 	another \ after the first one. If true, do nothing.  Otherwise, add a new \
 * 	to escape the first one.
 * @param String aString
 *	the input string.
 * @return String
 *	Returns the string after it is processed.
 **/
function escapeSpecialChars(aString)
{
	var result = "";

	if(
		aString == null
		|| aString == ""
	)
	{
//DEL 		Profile.End("<Global>", "escapeSpecialChars");	// Debug

		return aString;
	}

	for (var i=0; i < aString.length; i++ )
	{
		if (aString.charAt(i) == "\'")		 result += "\\\'";
		else if (aString.charAt(i) == "\"")  result += "\\\"";
		else if (aString.charAt(i) == "\\")  result += "\\\\";
		else result += aString.charAt(i);
	}

	return result;
}


/**
 * @method public escapeSpecialChars
 * 	This function is used to trim space from string at the beginning or end
 * @param String str
 *	the input string.
 * @return String
 *	Returns the string after it is processed.
 **/
function Trim(str)
{
	if (
		null == str
		|| 0 == str.length
	)
	{
		return str;
	}

	while (
		str.length > 0
		&& " " == str.substring(0,1)
	)
	{
		str = str.substring(1,str.length);
	}

	while (
		str.length > 0
		&& " " == str.substring(str.length-1,str.length)
	)
	{
		str = str.substring(0,str.length-1);
	}

	return str;
}


/**
* @method public pause
* 	This function is used to pause program progress for a while
* @param int numberMillis
*	The number of millisecond to pause
**/
function pause(numberMillis)
{
	var dlg = 'window.setTimeout(' + ' function () { window.close(); }, ' + numberMillis + ');';
	if (navigator.appName == "Netscape") // Won't work for unsigned scripts
	{
		var result= openDialog(
						'javascript:document.writeln(' + '"<script>' + dlg + '<' + '/script>"',
						'pauseDialog',
						'modal=1,width=10,height=10'
						);
		alert(result);
	}
	else
	{
		var result =  window.showModalDialog('javascript:document.writeln(' + '"<script>' + dlg + '<' + '/script>")');
	}
}

/**
* @method public gc
* 	This function is a javascript garbage collecion fuction. Currently only datagrid and input text field are found
* to have IE memeory leak problem. So right now the function loop the registed control array and only handle datagrid
* and input text field.
**/

function gc(){
	if(isIE())
	{
		var controlArr = ODCPageControl._Controls;
		var controllen = controlArr.length;

		for(var j=0; j<controllen; j++)
		{
			if (
				controlArr[j][1].Type!='undefined'
				&& controlArr[j][1].Type == "DataGrid"
			)
			{
				if(controlArr[j][1].DataArray!=null)
				{
				 	var len = controlArr[j][1].DataArray.length;

					for(var i=0; i<len; i++)
					{
						for(var k=0; k<controlArr[j][1].DataArray[i].length; k++)
						{
							controlArr[j][1].DataArray[i][k].OnPropertyBinderChange =null;
							controlArr[j][1].DataArray[i][k].onchange = null;
							controlArr[j][1].DataArray[i][k].propertyBinder= null;

							controlArr[j][1].DataArray[i][k] = null;
						}
					}
				}

				if(controlArr[j][1].Adapter.EObjects!=null)
				{
					var len = controlArr[j][1].Adapter.EObjects.length;
					for(var i=0;i<len; i++)
					{
						controlArr[j][1].Adapter.EObjects[i].PropertyBinders = null;
					}
				}

				controlArr[j][1].eventArray = null;

				controlArr[j][1].Adapter = null;
				controlArr[j][1].HTMLTable.GridControl = null;
				controlArr[j][1] = null;
			}
			else
			if(controlArr[j][0].indexOf("ODCInputTextControl")!=-1)
			{
				controlArr[j][1].onchange = null;
				controlArr[j][1].propertyBinder = null;
			}
			else
			{
				if(controlArr[j][1].eventArray != null)
				{
					controlArr[j][1].eventArray = null;
				}
			}
		}
	}
}

function findForm(control)
{
	/*alert(control.tagName);
	if(
		control == null
		|| control.parentNode == "undefined"
		)
	{
		return null;
	}

	var parent = control.parentNode;
	if (
		parent != null
		&& parent.tagName.toLowerCase() == "form"
	)
	{
		return parent;
	}
	else
	{
		findForm(parent);
	}*/

	return control.form;
}


/**
* @method public getWindowSize
*   This function is used to get the browser size
* @return array sizeArr
**/
function getWindowSize()
{
	var sizeArr= new Array(2);
	sizeArr[0] = (isIE())?document.body.offsetWidth:window.innerWidth;
	sizeArr[1] = (isIE())?document.body.offsetHeight:window.innerHeight;

	return sizeArr;

}


function getModelValue(obj){
	if(obj == null || obj == 'undefined'){
		return obj;
	}
	if(obj instanceof Date){
		//return the milisecond timestamp of the date
		return obj.getTime();
	}
	else if(obj instanceof Number){
		//return the primitive numeric value of the number
		return obj.valueOf();
	}
	else{
		return obj;
	}
}

function modelValueToObject(conv, value){
	if(conv instanceof hX_2.DateTimeConverter){
		if(value instanceof String){
			value = Number(value);
		}
		return new Date(value);
	}
	else if(conv instanceof hX_2.NumberConverter){
		return new Number(value);
	}
	else{
		return value;
	}
}


/**
* @method public uppercaseFirstLetter
*   This function is used to change the first letter of an attribute or reference to uppercase
* @param String name of an attribute or reference of an eobject
* @return String an attribute or reference name with its first letter in uppercase
**/
function uppercaseFirstLetter(name)
{

   if(name != null && name !="")
   {
      var firstChar = name.charAt(0).toUpperCase();
      var restPart = name.substring(1);
      name = firstChar + restPart;
   }
	return name;
}



//Global variables for the function below
var XMLReservedChars = ['\"', '&', '<', '>', '\''];
var escapeEntities = ['&quot;', '&amp;', '&lt;', '&gt;', '&apos;'];
var escapeCharSkipIndex = [6, 5, 4, 4, 6];
/**
* @method public convertXMLEscapingtoJS
*   This function is used to  removes escaping for XML reserved characters so that the string is a valid JS string
* @param String The raw string which has been ecoded using XML entity references
* @return String The string gets converted back to the original characters.
**/
function convertXMLEscapingtoJS(s)
{
   if (s != null)
   {
      var s1 = s;
      for (var i=0; i< escapeEntities.length; i++)
      {
      	var index = s.indexOf(escapeEntities[i]);
      	while (index != -1)
      	{
      		s1  = s.substring(0, index);
      		s1 += XMLReservedChars[i];
      		s1 += s.substring(index+escapeCharSkipIndex[i]);
      		s = s1;
      		index = s.indexOf(escapeEntities[i]);
      	}
      }
      return s1;
   }
   return null;
}

function  getXMLReservedCharIndex(c)
{
   for (var i=0; i<XMLReservedChars.length; i++)
     if (XMLReservedChars[i] == c)
       return i;
   return -1;
}

// Adds double quotes around the string, and escapes '\' and '"' and other XML reserved characters with a '\'
function escapeForXML(s)
{


    if ( typeof(s) != "string")
       return s;

    //if(s.indexOf("<>") != -1)
    //alert("begin escapeVXML()");

    var XXX = "";

    var len = s.length;

    var i = 0;
    var j = 0;
    while (j < len)
    {
       var index = -1;
       while ( j < len && index == -1 )
       {
         index = getXMLReservedCharIndex(s.charAt(j++));
         if (index != -1)
           j--;
       }
       XXX = XXX + s.substring(i, j);

       if (j == len)
        break;

       if (index >= 0)
       {

          XXX = XXX + escapeEntities[index];
       }

       ++j;
       i = j;
    }
    return XXX;

}



function iconLibrary(obj,stylename)
{
	var iconLib = new Array();
	var styleValue = getEffectiveStyle(obj, stylename);
	var iconArray = styleValue.split("|");
	var len = iconArray.length-1;

	for(var i=1; i<len; i++)
	{

		var temp = iconArray[i].split("=");
		iconLib[temp[0]] = temp[1];

	}
	if(len>0)
		return iconLib;
	else
		return null;
}


// Public: Get the actual (effective) value of a style property, that is, style after CSS is applied to the object
function getEffectiveStyle(obj, stylething1, stylething2) {
		var rvalue;
		//var elem = this.p.getElementById(obj);
		var elem = obj;
		if (elem) {
			// IE
			if (elem.currentStyle) {
				var cstyle = (stylething2) ? stylething2 : CSStagToDOMtag (stylething1);
				rvalue = elem.currentStyle.getAttribute(cstyle);
			// W3C
			} else if (window.getComputedStyle) {

				var compStyle = window.getComputedStyle(elem, "");
				rvalue = compStyle.getPropertyValue(stylething1);
			}
		}
		return (rvalue);
	}

// Helper Implementation: Convert a CSS tag name to a DOM tag name
function CSStagToDOMtag(value) {
		var work = value;
		var q = work.indexOf("-");
		while (q >= 0) {
			work = work.substring(0, q) + (work.substring(q+1, q+2)).toUpperCase() + work.substring(q+2);
			q = work.indexOf("-");
		}
		return work;
	}



function getBorderSize(obj, style, defaultValue)
{
	var width = defaultValue;
	var bname = "border-" + style + "-style";

	if ((getEffectiveStyle(obj, bname)) == "none") {

		width = 0;
	} else {

		bname = "border-" + style + "-width";

		var value = getEffectiveStyle(obj, bname);
		if(value)
			width =  (value == "") ? defaultValue : ((value == "thin") ? 2 : ((value == "medium") ? 3 : ((value == "thick") ? 4 : parseInt(value))));
		else
			width = defaultValue;
	}
	return width;
}


	function SortRows(columnName,rows) // private
	{
		//////////////////////////////////////////////////////////////////////////
		// Private Functions
		function SortObj(direction,value,row)	// private
		{


			this.m_direction = direction
			this.m_value	 = value;
			this.m_row		 = row;


		}

		function SortFunction(sortObj1,sortObj2)	// private
		{


			if (sortObj1.m_value == sortObj2.m_value)
			{


				return 0;
			}

			var obj1 = sortObj1.m_value;
			var obj2 = sortObj2.m_value;
			var ret = 1;

			if (
				"string" == typeof(obj1)
				&& "string" == typeof(obj2)
			)
			{
				ret = obj1.localeCompare(obj2);
			}else{
				ret = (obj1 > obj2) ? 1 : -1;
			}


			var rtu =  (sortObj1.m_direction == 0) ? ret : -1 * ret;
			return rtu;




		}
		// Private Functions End
		//////////////////////////////////////////////////////////////////////////



		var sortArray = new Array();
		columName = Trim(columnName);
		if (null == columName)
		{


			return sortArray;
		}

		var tokens = columnName.split(" ");
		if (
			null == tokens
			|| tokens.length == 0
		)
		{


			return sortArray;
		}

		var direction = "asc";
		columnName = Trim(tokens[0]);
		if (tokens.length > 1)
		{
			var d = Trim(tokens[1]).toLowerCase();
			if (d.length > 4)
			{
				d = d.substring(0,4);
			}

			if (d == "desc")
			{
				direction = d;
			}
		}

		for (var i = 0; i < rows.length; ++i)
		{
			sortArray[sortArray.length] = new SortObj((direction == "asc") ? 0 : 1,rows[i].eGet(columnName),rows[i]);
		}

		if (sortArray.length > 1)
		{
			sortArray.sort(SortFunction);
		}



		return sortArray;
	}

	function SortAllColumns(sortArray,columns,columnsIndex)	// private
	{


		if (columnsIndex >= columns.length)
		{


			return sortArray;
		}

		var newSortArray = new Array();
		var i = 0;
		while (i < sortArray.length)
		{
			var rows = new Array();
			var value = sortArray[i].m_value;
			while (i < sortArray.length && value == sortArray[i].m_value)
			{
				rows[rows.length] = sortArray[i].m_row;
				++i;
			}

			var subSortArray = SortRows(columns[columnsIndex],rows);
			subSortArray = SortAllColumns(subSortArray,columns,columnsIndex+1);
			newSortArray = newSortArray.concat(subSortArray);
		}



		return newSortArray;
	}
	// Private Functions End
	//////////////////////////////////////////////////////////////////////////



function getURLPrefix(encodedURL, sampleURL)
{
	return (encodedURL.substring(0,encodedURL.indexOf(sampleURL)));
}

function getURLPostfix(encodedURL, sampleURL)
{
	return (encodedURL.substring(encodedURL.indexOf(sampleURL)+sampleURL.length));
}