/*
 * @(#)ClipboardHandler.java	1.7 10/03/24
 * 
 * Copyright (c) 2006, Oracle and/or its affiliates. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * -Redistribution of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 * 
 * -Redistribution in binary form must reproduce the above copyright notice, 
 *  this list of conditions and the following disclaimer in the documentation
 *  and/or other materials provided with the distribution.
 * 
 * Neither the name of Oracle or the names of contributors may 
 * be used to endorse or promote products derived from this software without 
 * specific prior written permission.
 * 
 * This software is provided "AS IS," without a warranty of any kind. ALL 
 * EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING
 * ANY IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
 * OR NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN MICROSYSTEMS, INC. ("SUN")
 * AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE
 * AS A RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
 * DERIVATIVES. IN NO EVENT WILL SUN OR ITS LICENSORS BE LIABLE FOR ANY LOST 
 * REVENUE, PROFIT OR DATA, OR FOR DIRECT, INDIRECT, SPECIAL, CONSEQUENTIAL, 
 * INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER CAUSED AND REGARDLESS OF THE THEORY 
 * OF LIABILITY, ARISING OUT OF THE USE OF OR INABILITY TO USE THIS SOFTWARE, 
 * EVEN IF SUN HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 * 
 * You acknowledge that this software is not designed, licensed or intended
 * for use in the design, construction, operation or maintenance of any
 * nuclear facility.
 */

import javax.jnlp.ClipboardService;
import javax.jnlp.ServiceManager;
import javax.jnlp.UnavailableServiceException;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.DataFlavor;
import java.io.IOException;

/**
 */
public class ClipboardHandler {
    static private boolean _initialized = false;
    static private ClipboardService _cs = null;
    static private String _content = "";
    
    public static void toClipboard(String txt) {
	System.out.println("toClipboard: " + txt);
	initialize();
	if (_cs != null) {
	    _cs.setContents(new StringSelection(txt));
	} else {
	    _content = txt;
	}
    }
    
    public static String fromClipboard() {
	System.out.println("fromClipboard: ");
	initialize();
	if (_cs != null) {
	    Transferable t = _cs.getContents();
	    try {
		return (String)t.getTransferData(DataFlavor.stringFlavor);
	    } catch(Throwable ex) {
		System.out.println(ex);
		return "";
	    }
	} else {
	    return _content;
	}
    }
    
    static private synchronized void initialize() {
	if (_initialized) return;
	_initialized = true;
	try {
	    _cs = (ClipboardService)ServiceManager.lookup("javax.jnlp.ClipboardService");
	} catch(UnavailableServiceException e) {
	    _cs = null;
	}
    }
}
